/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.util;

import com.github.hexosse.wecuife.util.Vector2;
import com.github.hexosse.wecuife.util.Vector2m;
import net.minecraft.entity.Entity;

public class Vector3
implements Comparable<Vector3> {
    public static final Vector3 ZERO = new Vector3(0.0, 0.0, 0.0);
    public static final Vector3 UNIT_X;
    public static final Vector3 Forward;
    public static final Vector3 UNIT_Y;
    public static final Vector3 Up;
    public static final Vector3 UNIT_Z;
    public static final Vector3 Right;
    public static final Vector3 ONE;
    protected double x;
    protected double y;
    protected double z;

    public Vector3(Entity entity, double partialTicks) {
        this(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks, entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * partialTicks, entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Double x, Double y, Double z) {
        this((double)x, (double)y, (double)z);
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(Vector3 clone) {
        this(clone.getX(), clone.getY(), clone.getZ());
    }

    public Vector3(Vector2 vector, double z) {
        this(vector.getX(), vector.getY(), z);
    }

    public Vector3(Vector2 vector) {
        this(vector, 0.0);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3 add(Vector3 that) {
        return Vector3.add(this, that);
    }

    public Vector3 subtract(Vector3 that) {
        return Vector3.subtract(this, that);
    }

    public Vector3 scale(double scale) {
        return Vector3.scale(this, scale);
    }

    public double dot(Vector3 that) {
        return Vector3.dot(this, that);
    }

    public Vector3 cross(Vector3 that) {
        return Vector3.cross(this, that);
    }

    public Vector2 toVector2() {
        return Vector3.toVector2(this);
    }

    public Vector2m toVector2m() {
        return Vector3.toVector2m(this);
    }

    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 abs() {
        return new Vector3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double distance(Vector3 a2) {
        return Vector3.distance(a2, this);
    }

    public Vector3 pow(double power) {
        return Vector3.pow(this, power);
    }

    public double lengthSquared() {
        return Vector3.lengthSquared(this);
    }

    public double length() {
        return Vector3.length(this);
    }

    public double fastLength() {
        return Vector3.fastLength(this);
    }

    public Vector3 normalize() {
        return Vector3.normalize(this);
    }

    public double[] toArray() {
        return Vector3.toArray(this);
    }

    @Override
    public int compareTo(Vector3 o) {
        return Vector3.compareTo(this, o);
    }

    public boolean equals(Object o) {
        return Vector3.equals(this, o);
    }

    public String toString() {
        return String.format("{ %f, %f, %f }", this.x, this.y, this.z);
    }

    public static double length(Vector3 a2) {
        return Math.sqrt(Vector3.lengthSquared(a2));
    }

    public static double fastLength(Vector3 a2) {
        return Math.sqrt(Vector3.lengthSquared(a2));
    }

    public static double lengthSquared(Vector3 a2) {
        return Vector3.dot(a2, a2);
    }

    public static Vector3 normalize(Vector3 a2) {
        return Vector3.scale(a2, 1.0 / a2.length());
    }

    public static Vector3 subtract(Vector3 a2, Vector3 b2) {
        return new Vector3(a2.getX() - b2.getX(), a2.getY() - b2.getY(), a2.getZ() - b2.getZ());
    }

    public static Vector3 add(Vector3 a2, Vector3 b2) {
        return new Vector3(a2.getX() + b2.getX(), a2.getY() + b2.getY(), a2.getZ() + b2.getZ());
    }

    public static Vector3 scale(Vector3 a2, double b2) {
        return new Vector3(a2.getX() * b2, a2.getY() * b2, a2.getZ() * b2);
    }

    public static double dot(Vector3 a2, Vector3 b2) {
        return a2.getX() * b2.getX() + a2.getY() * b2.getY() + a2.getZ() * b2.getZ();
    }

    public static Vector3 cross(Vector3 a2, Vector3 b2) {
        return new Vector3(a2.getY() * b2.getZ() - a2.getZ() * b2.getY(), a2.getZ() * b2.getX() - a2.getX() * b2.getZ(), a2.getX() * b2.getY() - a2.getY() * b2.getX());
    }

    public static Vector3 ceil(Vector3 o) {
        return new Vector3(Math.ceil(o.x), Math.ceil(o.y), Math.ceil(o.z));
    }

    public static Vector3 floor(Vector3 o) {
        return new Vector3(Math.floor(o.x), Math.floor(o.y), Math.floor(o.z));
    }

    public static Vector3 round(Vector3 o) {
        return new Vector3(Math.round(o.x), Math.round(o.y), Math.round(o.z));
    }

    public static Vector3 abs(Vector3 o) {
        return new Vector3(Math.abs(o.x), Math.abs(o.y), Math.abs(o.z));
    }

    public static Vector3 min(Vector3 o1, Vector3 o2) {
        return new Vector3(Math.min(o1.x, o2.x), Math.min(o1.y, o2.y), Math.min(o1.z, o2.z));
    }

    public static Vector3 max(Vector3 o1, Vector3 o2) {
        return new Vector3(Math.max(o1.x, o2.x), Math.max(o1.y, o2.y), Math.max(o1.z, o2.z));
    }

    public static Vector3 rand() {
        return new Vector3(Math.random(), Math.random(), Math.random());
    }

    public static double distance(Vector3 a2, Vector3 b2) {
        double xzDist = Vector2.distance(a2.toVector2(), b2.toVector2());
        return Math.sqrt(Math.pow(xzDist, 2.0) + Math.pow(Math.abs(Vector3.subtract(a2, b2).getY()), 2.0));
    }

    public static Vector3 pow(Vector3 o, double power) {
        return new Vector3(Math.pow(o.x, power), Math.pow(o.y, power), Math.pow(o.z, power));
    }

    public static Vector2 toVector2(Vector3 o) {
        return new Vector2(o.x, o.z);
    }

    public static Vector2m toVector2m(Vector3 o) {
        return new Vector2m((Double)o.x, (Double)o.z);
    }

    public static double[] toArray(Vector3 a2) {
        return new double[]{a2.getX(), a2.getY(), a2.getZ()};
    }

    public static int compareTo(Vector3 a2, Vector3 b2) {
        return (int)a2.lengthSquared() - (int)b2.lengthSquared();
    }

    public static boolean equals(Object a2, Object b2) {
        if (!(a2 instanceof Vector3) || !(b2 instanceof Vector3)) {
            return false;
        }
        if (a2 == b2) {
            return true;
        }
        Vector3 x = (Vector3)a2;
        Vector3 y = (Vector3)b2;
        return x.getX() == y.getX() && x.getY() == y.getY() && x.getZ() == y.getZ();
    }

    public int hashCode() {
        return (int)(this.x * this.y % this.z);
    }

    static {
        Forward = UNIT_X = new Vector3(1.0, 0.0, 0.0);
        Up = UNIT_Y = new Vector3(0.0, 1.0, 0.0);
        Right = UNIT_Z = new Vector3(0.0, 0.0, 1.0);
        ONE = new Vector3(1.0, 1.0, 1.0);
    }
}

