/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.util;

import com.github.hexosse.wecuife.util.Vector3;

public class Vector2
implements Comparable<Vector2> {
    public static final Vector2 ZERO = new Vector2(0.0, 0.0);
    public static final Vector2 UNIT_X = new Vector2(1.0, 0.0);
    public static final Vector2 UNIT_Y = new Vector2(0.0, 1.0);
    public static Vector2 ONE = new Vector2(1.0, 1.0);
    protected double x;
    protected double z;

    public Vector2(double x, double y) {
        this.x = x;
        this.z = y;
    }

    public Vector2(Double x, Double y) {
        this((double)x, (double)y);
    }

    public Vector2() {
        this(0.0, 0.0);
    }

    public Vector2(Vector2 original) {
        this(original.x, original.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.z;
    }

    public Vector2 add(Vector2 that) {
        return Vector2.add(this, that);
    }

    public Vector2 subtract(Vector2 that) {
        return Vector2.subtract(this, that);
    }

    public Vector2 scale(double scale) {
        return Vector2.scale(this, scale);
    }

    public double dot(Vector2 that) {
        return Vector2.dot(this, that);
    }

    public Vector3 toVector3() {
        return Vector2.toVector3(this);
    }

    public Vector3 toVector3(double y) {
        return Vector2.toVector3(this, y);
    }

    public Vector2 cross() {
        return new Vector2(this.z, -this.x);
    }

    public Vector2 ceil() {
        return new Vector2(Math.ceil(this.x), Math.ceil(this.z));
    }

    public Vector2 floor() {
        return new Vector2(Math.floor(this.x), Math.floor(this.z));
    }

    public Vector2 round() {
        return new Vector2(Math.round(this.x), Math.round(this.z));
    }

    public Vector2 abs() {
        return new Vector2(Math.abs(this.x), Math.abs(this.z));
    }

    public double distance(Vector2 a2) {
        return Vector2.distance(a2, this);
    }

    public Vector2 pow(double power) {
        return Vector2.pow(this, power);
    }

    public double lengthSquared() {
        return Vector2.lengthSquared(this);
    }

    public double length() {
        return Vector2.length(this);
    }

    public Vector2 normalize() {
        return Vector2.normalize(this);
    }

    public double[] toArray() {
        return Vector2.toArray(this);
    }

    @Override
    public int compareTo(Vector2 o) {
        return Vector2.compareTo(this, o);
    }

    public boolean equals(Object o) {
        return Vector2.equals(this, o);
    }

    public static double length(Vector2 a2) {
        return Math.sqrt(Vector2.lengthSquared(a2));
    }

    public static double lengthSquared(Vector2 a2) {
        return Vector2.dot(a2, a2);
    }

    public static Vector2 normalize(Vector2 a2) {
        return Vector2.scale(a2, 1.0 / a2.length());
    }

    public static Vector2 subtract(Vector2 a2, Vector2 b2) {
        return new Vector2(a2.getX() - b2.getX(), a2.getY() - b2.getY());
    }

    public static Vector2 add(Vector2 a2, Vector2 b2) {
        return new Vector2(a2.getX() + b2.getX(), a2.getY() + b2.getY());
    }

    public static Vector2 scale(Vector2 a2, double b2) {
        return new Vector2(a2.getX() * b2, a2.getY() * b2);
    }

    public static double dot(Vector2 a2, Vector2 b2) {
        return a2.getX() * b2.getX() + a2.getY() * b2.getY();
    }

    public static Vector3 toVector3(Vector2 o) {
        return new Vector3(o.x, 0.0, o.z);
    }

    public static Vector3 toVector3(Vector2 o, double y) {
        return new Vector3(o.x, y, o.z);
    }

    public static Vector2 ceil(Vector2 o) {
        return new Vector2(Math.ceil(o.x), Math.ceil(o.z));
    }

    public static Vector2 floor(Vector2 o) {
        return new Vector2(Math.floor(o.x), Math.floor(o.z));
    }

    public static Vector2 round(Vector2 o) {
        return new Vector2(Math.round(o.x), Math.round(o.z));
    }

    public static Vector2 abs(Vector2 o) {
        return new Vector2(Math.abs(o.x), Math.abs(o.z));
    }

    public static Vector2 min(Vector2 o1, Vector2 o2) {
        return new Vector2(Math.min(o1.x, o2.x), Math.min(o1.z, o2.z));
    }

    public static Vector2 max(Vector2 o1, Vector2 o2) {
        return new Vector2(Math.max(o1.x, o2.x), Math.max(o1.z, o2.z));
    }

    public static Vector2 rand() {
        return new Vector2(Math.random(), Math.random());
    }

    public static double[] toArray(Vector2 a2) {
        return new double[]{a2.getX(), a2.getY()};
    }

    public static int compareTo(Vector2 a2, Vector2 b2) {
        return (int)a2.lengthSquared() - (int)b2.lengthSquared();
    }

    public static double distance(Vector2 a2, Vector2 b2) {
        Vector2 tempVector = Vector2.pow(Vector2.subtract(a2, b2), 2.0);
        return Math.sqrt(tempVector.x + tempVector.z);
    }

    public static Vector2 pow(Vector2 o, double power) {
        return new Vector2(Math.pow(o.x, power), Math.pow(o.z, power));
    }

    public static boolean equals(Object a2, Object b2) {
        if (!(a2 instanceof Vector2) || !(b2 instanceof Vector2)) {
            return false;
        }
        if (a2 == b2) {
            return true;
        }
        return Vector2.compareTo((Vector2)a2, (Vector2)b2) == 0;
    }

    public String toString() {
        return "(" + this.x + ", " + this.z + ")";
    }

    public int hashCode() {
        return (int)(this.x % this.z);
    }
}

