/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.render.shapes;

import com.github.hexosse.wecuife.render.LineColour;
import com.github.hexosse.wecuife.render.LineInfo;
import com.github.hexosse.wecuife.render.points.PointCube;
import com.github.hexosse.wecuife.util.Vector3;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderEllipsoid {
    protected LineColour colour;
    protected PointCube centre;
    protected Vector3 radii;
    protected static final double twoPi = Math.PI * 2;
    protected double centreX;
    protected double centreY;
    protected double centreZ;

    public RenderEllipsoid(LineColour colour, PointCube centre, Vector3 radii) {
        this.colour = colour;
        this.centre = centre;
        this.radii = radii;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreY = centre.getPoint().getY() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    public void render(Vector3 cameraPos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.centreX - cameraPos.getX()), (double)(this.centreY - cameraPos.getY()), (double)(this.centreZ - cameraPos.getZ()));
        for (LineInfo tempColour : this.colour.getColours()) {
            tempColour.prepareRender();
            this.drawXZPlane(tempColour);
            this.drawYZPlane(tempColour);
            this.drawXYPlane(tempColour);
        }
        GlStateManager.func_179121_F();
    }

    protected void drawXZPlane(LineInfo colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int yRad = (int)Math.floor(this.radii.getY());
        for (int yBlock = -yRad; yBlock < yRad; ++yBlock) {
            vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            colour.prepareColour();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = this.radii.getX() * Math.cos(tempTheta) * Math.cos(Math.asin((double)yBlock / this.radii.getY()));
                double tempZ = this.radii.getZ() * Math.sin(tempTheta) * Math.cos(Math.asin((double)yBlock / this.radii.getY()));
                vertexbuffer.func_181662_b(tempX, (double)yBlock, tempZ).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        colour.prepareColour();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = this.radii.getX() * Math.cos(tempTheta);
            double tempZ = this.radii.getZ() * Math.sin(tempTheta);
            vertexbuffer.func_181662_b(tempX, 0.0, tempZ).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    protected void drawYZPlane(LineInfo colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int xRad = (int)Math.floor(this.radii.getX());
        for (int xBlock = -xRad; xBlock < xRad; ++xBlock) {
            vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            colour.prepareColour();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempY = this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((double)xBlock / this.radii.getX()));
                double tempZ = this.radii.getZ() * Math.sin(tempTheta) * Math.sin(Math.acos((double)xBlock / this.radii.getX()));
                vertexbuffer.func_181662_b((double)xBlock, tempY, tempZ).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        colour.prepareColour();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempY = this.radii.getY() * Math.cos(tempTheta);
            double tempZ = this.radii.getZ() * Math.sin(tempTheta);
            vertexbuffer.func_181662_b(0.0, tempY, tempZ).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    protected void drawXYPlane(LineInfo colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int zRad = (int)Math.floor(this.radii.getZ());
        for (int zBlock = -zRad; zBlock < zRad; ++zBlock) {
            vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            colour.prepareColour();
            for (int i = 0; i <= 40; ++i) {
                double tempTheta = (double)i * (Math.PI * 2) / 40.0;
                double tempX = this.radii.getX() * Math.sin(tempTheta) * Math.sin(Math.acos((double)zBlock / this.radii.getZ()));
                double tempY = this.radii.getY() * Math.cos(tempTheta) * Math.sin(Math.acos((double)zBlock / this.radii.getZ()));
                vertexbuffer.func_181662_b(tempX, tempY, (double)zBlock).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        colour.prepareColour();
        for (int i = 0; i <= 40; ++i) {
            double tempTheta = (double)i * (Math.PI * 2) / 40.0;
            double tempX = this.radii.getX() * Math.cos(tempTheta);
            double tempY = this.radii.getY() * Math.sin(tempTheta);
            vertexbuffer.func_181662_b(tempX, tempY, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

