/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.render.shapes;

import com.github.hexosse.wecuife.render.LineColour;
import com.github.hexosse.wecuife.render.LineInfo;
import com.github.hexosse.wecuife.render.points.PointCube;
import com.github.hexosse.wecuife.util.Vector3;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderCylinderGrid {
    protected LineColour colour;
    protected double radX = 0.0;
    protected double radZ = 0.0;
    protected int minY;
    protected int maxY;
    protected double centreX;
    protected double centreZ;

    public RenderCylinderGrid(LineColour colour, PointCube centre, double radX, double radZ, int minY, int maxY) {
        this.colour = colour;
        this.radX = radX;
        this.radZ = radZ;
        this.minY = minY;
        this.maxY = maxY;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    public void render(Vector3 cameraPos) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        double xPos = this.centreX - cameraPos.getX();
        double zPos = this.centreZ - cameraPos.getZ();
        for (LineInfo tempColour : this.colour.getColours()) {
            tempColour.prepareRender();
            int tmaxY = this.maxY + 1;
            int tminY = this.minY;
            int posRadiusX = (int)Math.ceil(this.radX);
            int negRadiusX = (int)(-Math.ceil(this.radX));
            int posRadiusZ = (int)Math.ceil(this.radZ);
            int negRadiusZ = (int)(-Math.ceil(this.radZ));
            for (double tempX = (double)negRadiusX; tempX <= (double)posRadiusX; tempX += 1.0) {
                double tempZ = this.radZ * Math.cos(Math.asin(tempX / this.radX));
                vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                tempColour.prepareColour();
                vertexbuffer.func_181662_b(xPos + tempX, (double)tmaxY - cameraPos.getY(), zPos + tempZ).func_181675_d();
                vertexbuffer.func_181662_b(xPos + tempX, (double)tmaxY - cameraPos.getY(), zPos - tempZ).func_181675_d();
                vertexbuffer.func_181662_b(xPos + tempX, (double)tminY - cameraPos.getY(), zPos - tempZ).func_181675_d();
                vertexbuffer.func_181662_b(xPos + tempX, (double)tminY - cameraPos.getY(), zPos + tempZ).func_181675_d();
                tessellator.func_78381_a();
            }
            for (double tempZ = (double)negRadiusZ; tempZ <= (double)posRadiusZ; tempZ += 1.0) {
                double tempX = this.radX * Math.sin(Math.acos(tempZ / this.radZ));
                vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                tempColour.prepareColour();
                vertexbuffer.func_181662_b(xPos + tempX, (double)tmaxY - cameraPos.getY(), zPos + tempZ).func_181675_d();
                vertexbuffer.func_181662_b(xPos - tempX, (double)tmaxY - cameraPos.getY(), zPos + tempZ).func_181675_d();
                vertexbuffer.func_181662_b(xPos - tempX, (double)tminY - cameraPos.getY(), zPos + tempZ).func_181675_d();
                vertexbuffer.func_181662_b(xPos + tempX, (double)tminY - cameraPos.getY(), zPos + tempZ).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }
}

