/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.render.shapes;

import com.github.hexosse.wecuife.render.LineColour;
import com.github.hexosse.wecuife.render.LineInfo;
import com.github.hexosse.wecuife.render.points.PointRectangle;
import com.github.hexosse.wecuife.util.Vector2;
import com.github.hexosse.wecuife.util.Vector3;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class Render2DGrid {
    protected LineColour colour;
    protected List<PointRectangle> points;
    protected int min;
    protected int max;

    public Render2DGrid(LineColour colour, List<PointRectangle> points, int min, int max) {
        this.colour = colour;
        this.points = points;
        this.min = min;
        this.max = max;
    }

    public void render(Vector3 cameraPos) {
        double off = 0.03;
        for (double height = (double)this.min; height <= (double)(this.max + 1); height += 1.0) {
            this.drawPoly(cameraPos, height + off);
        }
    }

    protected void drawPoly(Vector3 cameraPos, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        for (LineInfo tempColour : this.colour.getColours()) {
            tempColour.prepareRender();
            vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            tempColour.prepareColour();
            for (PointRectangle point : this.points) {
                if (point == null) continue;
                Vector2 pos = point.getPoint();
                double x = pos.getX() - cameraPos.getX();
                double z = pos.getY() - cameraPos.getZ();
                vertexbuffer.func_181662_b(x + 0.5, height - cameraPos.getY(), z + 0.5).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }
}

