/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.render.points;

import com.github.hexosse.wecuife.render.LineColour;
import com.github.hexosse.wecuife.render.shapes.Render3DBox;
import com.github.hexosse.wecuife.util.Vector3;

public class PointCube {
    private static final double OFF = (double)0.03f;
    private static final Vector3 MIN_VEC = new Vector3(0.03f, 0.03f, 0.03f);
    private static final Vector3 MAX_VEC = new Vector3(1.0299999993294477, 1.0299999993294477, 1.0299999993294477);
    protected Vector3 point;
    protected LineColour colour = LineColour.CUBOIDPOINT1;
    private Render3DBox box;

    public PointCube(double x, double y, double z) {
        this(new Vector3(x, y, z));
    }

    public PointCube(Vector3 point) {
        this.setPoint(point);
    }

    public void render(Vector3 cameraPos) {
        this.box.render(cameraPos);
    }

    public Vector3 getPoint() {
        return this.point;
    }

    public void setPoint(Vector3 point) {
        this.point = point;
        this.update();
    }

    public LineColour getColour() {
        return this.colour;
    }

    public void setColour(LineColour colour) {
        this.colour = colour;
        this.update();
    }

    private void update() {
        this.box = new Render3DBox(this.colour, this.point.subtract(MIN_VEC), this.point.add(MAX_VEC));
    }
}

