/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.event;

import com.github.hexosse.wecuife.event.CUIEventType;
import com.google.common.base.Joiner;

public abstract class CUIEvent {
    protected String[] args;

    public CUIEvent(String[] args) {
        this.args = args;
    }

    public abstract String raise();

    public abstract CUIEventType getEventType();

    public String getEventName() {
        return this.getEventType().getName();
    }

    public boolean isValid() {
        int min;
        int max = this.getEventType().getMaxParameters();
        return !(max == (min = this.getEventType().getMinParameters()) ? this.args.length != max : this.args.length > max || this.args.length < min);
    }

    public final void prepare() {
        if (this.args == null) {
            throw new IllegalStateException("Controller and parameters must both be set.");
        }
        if (!this.isValid()) {
            String message = String.format("Invalid number of parameters. %s event requires %s parameters but received %s [%s]", this.getEventName(), this.getRequiredParameterString(), this.args.length, Joiner.on((String)", ").join((Object[])this.args));
            throw new IllegalArgumentException(message);
        }
    }

    private String getRequiredParameterString() {
        if (this.getEventType().getMaxParameters() == this.getEventType().getMinParameters()) {
            return String.valueOf(this.getEventType().getMaxParameters());
        }
        return String.format("between %d and %d", this.getEventType().getMinParameters(), this.getEventType().getMaxParameters());
    }

    public int getInt(int index) {
        return (int)Float.parseFloat(this.args[index]);
    }

    public double getDouble(int index) {
        return Double.parseDouble(this.args[index]);
    }

    public String getString(int index) {
        return this.args[index];
    }
}

