/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.common.config;

import com.github.hexosse.wecuife.common.Colour;
import com.github.hexosse.wecuife.common.McColor;
import com.github.hexosse.wecuife.render.LineColour;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class CUIConfig
extends Configuration {
    public static final String VERSION = "1.0";
    public static final String CATEGORY_MOD = "WorldEditCuiFe";
    public static final String CATEGORY_COLORS = "colors";
    private boolean debugMode;
    private boolean enable;
    private Colour cuboidGridColor;
    private Colour cuboidEdgeColor;
    private Colour cuboidFirstPointColor;
    private Colour cuboidSecondPointColor;
    private Colour polyGridColor;
    private Colour polyEdgeColor;
    private Colour polyPointColor;
    private Colour ellipsoidGridColor;
    private Colour ellipsoidPointColor;
    private Colour cylinderGridColor;
    private Colour cylinderEdgeColor;
    private Colour cylinderPointColor;

    public CUIConfig() {
        super(new File(Minecraft.func_71410_x().field_71412_D.toString() + "/config/" + "worldeditcuife" + ".cfg"), VERSION);
        if (this.hasChanged()) {
            this.save();
        }
    }

    public void load() {
        super.load();
        this.reload();
        this.initialise();
    }

    public void save() {
        super.save();
        this.reload();
        this.initialise();
    }

    public Property get(String key) {
        if (key == "debugMode") {
            return this.get(CATEGORY_MOD, "debugMode", false);
        }
        if (key == "enable") {
            return this.get(CATEGORY_MOD, "enable", true).setLanguageKey("com.github.hexosse.wecuife.keys.toggle");
        }
        String[] colors = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        if (key == "cuboidFirstPointColor") {
            return this.get(CATEGORY_COLORS, "cuboidFirstPointColor", McColor.GREEN.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cuboidpoint1").setValidValues(colors);
        }
        if (key == "cuboidSecondPointColor") {
            return this.get(CATEGORY_COLORS, "cuboidSecondPointColor", McColor.DARK_BLUE.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cuboidpoint2").setValidValues(colors);
        }
        if (key == "cuboidEdgeColor") {
            return this.get(CATEGORY_COLORS, "cuboidEdgeColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cuboidgrid").setValidValues(colors);
        }
        if (key == "cuboidGridColor") {
            return this.get(CATEGORY_COLORS, "cuboidGridColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cuboidedge").setValidValues(colors);
        }
        if (key == "polyPointColor") {
            return this.get(CATEGORY_COLORS, "polyPointColor", McColor.AQUA.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.polypoint").setValidValues(colors);
        }
        if (key == "polyEdgeColor") {
            return this.get(CATEGORY_COLORS, "polyEdgeColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.polyedge").setValidValues(colors);
        }
        if (key == "polyGridColor") {
            return this.get(CATEGORY_COLORS, "polyGridColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.polygrid").setValidValues(colors);
        }
        if (key == "ellipsoidPointColor") {
            return this.get(CATEGORY_COLORS, "ellipsoidPointColor", McColor.DARK_GREEN.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.ellipsoidpoint").setValidValues(colors);
        }
        if (key == "ellipsoidGridColor") {
            return this.get(CATEGORY_COLORS, "ellipsoidGridColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.ellipsoidgrid").setValidValues(colors);
        }
        if (key == "cylinderPointColor") {
            return this.get(CATEGORY_COLORS, "cylinderPointColor", McColor.LIGHT_PURPLE.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cylinderpoint").setValidValues(colors);
        }
        if (key == "cylinderEdgeColor") {
            return this.get(CATEGORY_COLORS, "cylinderEdgeColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cylinderedge").setValidValues(colors);
        }
        if (key == "cylinderGridColor") {
            return this.get(CATEGORY_COLORS, "cylinderGridColor", McColor.DARK_RED.getCode(), "", Property.Type.COLOR).setLanguageKey("colour.cylindergrid").setValidValues(colors);
        }
        return null;
    }

    public void reload() {
        this.debugMode = this.get("debugMode").getBoolean();
        this.enable = this.get("enable").getBoolean();
        this.cuboidFirstPointColor = new Colour(McColor.get(this.get("cuboidFirstPointColor").getString()).getForeground() + "CC");
        this.cuboidSecondPointColor = new Colour(McColor.get(this.get("cuboidSecondPointColor").getString()).getForeground() + "CC");
        this.cuboidEdgeColor = new Colour(McColor.get(this.get("cuboidEdgeColor").getString()).getForeground() + "CC");
        this.cuboidGridColor = new Colour(McColor.get(this.get("cuboidGridColor").getString()).getForeground() + "CC");
        this.polyPointColor = new Colour(McColor.get(this.get("polyPointColor").getString()).getForeground() + "CC");
        this.polyEdgeColor = new Colour(McColor.get(this.get("polyEdgeColor").getString()).getForeground() + "CC");
        this.polyGridColor = new Colour(McColor.get(this.get("polyGridColor").getString()).getForeground() + "CC");
        this.ellipsoidPointColor = new Colour(McColor.get(this.get("ellipsoidPointColor").getString()).getForeground() + "CC");
        this.ellipsoidGridColor = new Colour(McColor.get(this.get("ellipsoidGridColor").getString()).getForeground() + "CC");
        this.cylinderPointColor = new Colour(McColor.get(this.get("cylinderPointColor").getString()).getForeground() + "CC");
        this.cylinderEdgeColor = new Colour(McColor.get(this.get("cylinderEdgeColor").getString()).getForeground() + "CC");
        this.cylinderGridColor = new Colour(McColor.get(this.get("cylinderGridColor").getString()).getForeground() + "CC");
        ArrayList<String> modPropOrder = new ArrayList<String>();
        modPropOrder.add("enabled");
        this.setCategoryPropertyOrder(CATEGORY_MOD, modPropOrder);
        ArrayList<String> colorsPropOrder = new ArrayList<String>();
        colorsPropOrder.add("cuboidFirstPointColor");
        colorsPropOrder.add("cuboidSecondPointColor");
        colorsPropOrder.add("cuboidEdgeColor");
        colorsPropOrder.add("cuboidGridColor");
        colorsPropOrder.add("polyPointColor");
        colorsPropOrder.add("polyEdgeColor");
        colorsPropOrder.add("polyGridColor");
        colorsPropOrder.add("ellipsoidPointColor");
        colorsPropOrder.add("ellipsoidGridColor");
        colorsPropOrder.add("cylinderPointColor");
        colorsPropOrder.add("cylinderEdgeColor");
        colorsPropOrder.add("cylinderGridColor");
        this.setCategoryPropertyOrder(CATEGORY_COLORS, colorsPropOrder);
    }

    public void initialise() {
        this.cuboidFirstPointColor = Colour.setDefault(this.cuboidFirstPointColor, McColor.get(this.get("cuboidFirstPointColor").getDefault()).getForeground());
        this.cuboidSecondPointColor = Colour.setDefault(this.cuboidSecondPointColor, McColor.get(this.get("cuboidSecondPointColor").getDefault()).getForeground());
        this.cuboidEdgeColor = Colour.setDefault(this.cuboidEdgeColor, McColor.get(this.get("cuboidEdgeColor").getDefault()).getForeground());
        this.cuboidGridColor = Colour.setDefault(this.cuboidGridColor, McColor.get(this.get("cuboidGridColor").getDefault()).getForeground());
        this.polyPointColor = Colour.setDefault(this.polyPointColor, McColor.get(this.get("polyPointColor").getDefault()).getForeground());
        this.polyEdgeColor = Colour.setDefault(this.polyEdgeColor, McColor.get(this.get("polyEdgeColor").getDefault()).getForeground());
        this.polyGridColor = Colour.setDefault(this.polyGridColor, McColor.get(this.get("polyGridColor").getDefault()).getForeground());
        this.ellipsoidPointColor = Colour.setDefault(this.ellipsoidPointColor, McColor.get(this.get("ellipsoidPointColor").getDefault()).getForeground());
        this.ellipsoidGridColor = Colour.setDefault(this.ellipsoidGridColor, McColor.get(this.get("ellipsoidGridColor").getDefault()).getForeground());
        this.cylinderPointColor = Colour.setDefault(this.cylinderPointColor, McColor.get(this.get("cylinderPointColor").getDefault()).getForeground());
        this.cylinderEdgeColor = Colour.setDefault(this.cylinderEdgeColor, McColor.get(this.get("cylinderEdgeColor").getDefault()).getForeground());
        this.cylinderGridColor = Colour.setDefault(this.cylinderGridColor, McColor.get(this.get("cylinderGridColor").getDefault()).getForeground());
        LineColour.CUBOIDPOINT1.setColour(this.cuboidFirstPointColor);
        LineColour.CUBOIDPOINT2.setColour(this.cuboidSecondPointColor);
        LineColour.CUBOIDBOX.setColour(this.cuboidEdgeColor);
        LineColour.CUBOIDGRID.setColour(this.cuboidGridColor);
        LineColour.POLYPOINT.setColour(this.polyPointColor);
        LineColour.POLYBOX.setColour(this.polyEdgeColor);
        LineColour.POLYGRID.setColour(this.polyGridColor);
        LineColour.ELLIPSOIDCENTRE.setColour(this.ellipsoidPointColor);
        LineColour.ELLIPSOIDGRID.setColour(this.ellipsoidGridColor);
        LineColour.CYLINDERCENTRE.setColour(this.cylinderPointColor);
        LineColour.CYLINDERBOX.setColour(this.cylinderEdgeColor);
        LineColour.CYLINDERGRID.setColour(this.cylinderGridColor);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.get("enable").set(enable);
        this.enable = this.get("enable").getBoolean();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }
}

