/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public abstract class RandomizedTemplateProcessor
implements ITemplateProcessor {
    protected final Random random;
    private final float integrity;

    public RandomizedTemplateProcessor(BlockPos pos, PlacementSettings settings) {
        this.integrity = settings.func_189948_f();
        this.random = settings.func_189947_a(pos);
    }

    protected boolean shouldPlaceBlock() {
        return this.integrity >= 1.0f || this.random.nextFloat() > this.integrity;
    }

    protected Block randomBlock(Block ... blocks) {
        return blocks[this.random.nextInt(blocks.length)];
    }

    protected static <T extends Comparable<T>> IBlockState translateState(IBlockState stateIn, Block blockOut, IProperty<T> property) {
        return blockOut.func_176223_P().func_177226_a(property, stateIn.func_177229_b(property));
    }

    protected static IBlockState translateState(IBlockState stateIn, Block blockOut, IProperty<?> ... properties) {
        IBlockState stateOut = blockOut.func_176223_P();
        for (IProperty<?> property : properties) {
            stateOut = RandomizedTemplateProcessor.copyValue(stateIn, stateOut, property);
        }
        return stateOut;
    }

    private static <T extends Comparable<T>> IBlockState copyValue(IBlockState from, IBlockState to, IProperty<T> property) {
        return to.func_177226_a(property, from.func_177229_b(property));
    }
}

