/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomes;

public class GenLayerTFStream
extends GenLayer {
    public GenLayerTFStream(long l, GenLayer genlayer) {
        super(l);
        this.field_75909_a = genlayer;
    }

    public int[] func_75904_a(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.field_75909_a.func_75904_a(nx, nz, nwidth, ndepth);
        int[] output = IntCache.func_76445_a((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int mid = input[dx + 1 + (dz + 1) * nwidth];
                int left = input[dx + 0 + (dz + 1) * nwidth];
                int down = input[dx + 1 + (dz + 0) * nwidth];
                int right = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.shouldStream(mid, left, down, right, up) ? Biome.func_185362_a((Biome)TFBiomes.stream) : -1;
            }
        }
        return output;
    }

    boolean shouldStream(int mid, int left, int down, int right, int up) {
        if (this.shouldStream(mid, left)) {
            return true;
        }
        if (this.shouldStream(mid, right)) {
            return true;
        }
        if (this.shouldStream(mid, down)) {
            return true;
        }
        return this.shouldStream(mid, up);
    }

    boolean shouldStream(int biome1, int biome2) {
        if (biome1 == biome2) {
            return false;
        }
        if (biome1 == -biome2) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.glacier) && biome2 == Biome.func_185362_a((Biome)TFBiomes.snowy_forest)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.snowy_forest) && biome2 == Biome.func_185362_a((Biome)TFBiomes.glacier)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.deepMushrooms) && biome2 == Biome.func_185362_a((Biome)TFBiomes.mushrooms)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.mushrooms) && biome2 == Biome.func_185362_a((Biome)TFBiomes.deepMushrooms)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.tfSwamp) && biome2 == Biome.func_185362_a((Biome)TFBiomes.fireSwamp)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.fireSwamp) && biome2 == Biome.func_185362_a((Biome)TFBiomes.tfSwamp)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.highlands) && biome2 == Biome.func_185362_a((Biome)TFBiomes.highlandsCenter)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.highlandsCenter) && biome2 == Biome.func_185362_a((Biome)TFBiomes.highlands)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.darkForest) && biome2 == Biome.func_185362_a((Biome)TFBiomes.darkForestCenter)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.darkForestCenter) && biome2 == Biome.func_185362_a((Biome)TFBiomes.darkForest)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.tfLake) || biome2 == Biome.func_185362_a((Biome)TFBiomes.tfLake)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.clearing) || biome2 == Biome.func_185362_a((Biome)TFBiomes.oakSavanna)) {
            return false;
        }
        if (biome1 == Biome.func_185362_a((Biome)TFBiomes.oakSavanna) || biome2 == Biome.func_185362_a((Biome)TFBiomes.clearing)) {
            return false;
        }
        return biome1 != Biome.func_185362_a((Biome)TFBiomes.thornlands) && biome2 != Biome.func_185362_a((Biome)TFBiomes.thornlands);
    }
}

