/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public class TFGenThorns
extends TFGenerator {
    private static final int MAX_SPREAD = 7;
    private static final int CHANCE_OF_BRANCH = 3;
    private static final int CHANCE_OF_LEAF = 3;
    private static final int CHANCE_LEAF_IS_ROSE = 50;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int nextLength = 2 + rand.nextInt(4);
        int maxLength = 2 + rand.nextInt(4) + rand.nextInt(4) + rand.nextInt(4);
        this.placeThorns(world, rand, pos, nextLength, EnumFacing.UP, maxLength, pos);
        return true;
    }

    private void placeThorns(World world, Random rand, BlockPos pos, int length, EnumFacing dir, int maxLength, BlockPos oPos) {
        EnumFacing nextDir;
        int middle;
        BlockPos dPos;
        boolean complete = false;
        for (int i = 0; i < length && Math.abs((dPos = pos.func_177967_a(dir, i)).func_177958_n() - oPos.func_177958_n()) < 7 && Math.abs(dPos.func_177952_p() - oPos.func_177952_p()) < 7 && this.canPlaceThorns(world, dPos); ++i) {
            this.func_175903_a(world, dPos, TFBlocks.thorns.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)dir.func_176740_k()));
            if (i != length - 1) continue;
            complete = true;
            if (rand.nextInt(3) != 0 || !world.func_175623_d(dPos.func_177972_a(dir))) continue;
            if (rand.nextInt(50) > 0) {
                this.func_175903_a(world, dPos.func_177972_a(dir), TFBlocks.leaves3.func_176223_P());
                continue;
            }
            this.func_175903_a(world, dPos.func_177972_a(dir), TFBlocks.thornRose.func_176223_P());
        }
        if (complete && maxLength > 1) {
            EnumFacing nextDir2 = EnumFacing.func_176741_a((Random)rand);
            BlockPos nextPos = pos.func_177967_a(dir, length - 1).func_177972_a(nextDir2);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir2, maxLength - 1, oPos);
        }
        if (complete && length > 3 && rand.nextInt(3) == 0) {
            middle = rand.nextInt(length);
            nextDir = EnumFacing.func_176741_a((Random)rand);
            BlockPos nextPos = pos.func_177967_a(dir, middle).func_177972_a(nextDir);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir, maxLength - 1, oPos);
        }
        if (complete && length > 3 && rand.nextInt(3) == 0) {
            middle = rand.nextInt(length);
            nextDir = EnumFacing.func_176741_a((Random)rand);
            BlockPos nextPos = pos.func_177967_a(dir, middle).func_177972_a(nextDir);
            if (world.func_175623_d(nextPos)) {
                this.func_175903_a(world, nextPos, TFBlocks.leaves3.func_176223_P());
            }
        }
    }

    private boolean canPlaceThorns(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

