/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockVine;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.TFTreasure;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlockProperties;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenHollowTree
extends TFGenerator {
    private static final int LEAF_DUNGEON_CHANCE = 8;
    protected IBlockState treeState = TFBlocks.log.func_176223_P();
    protected IBlockState branchState = this.treeState.func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
    protected IBlockState leafState = TFBlocks.leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    protected IBlockState rootState = TFBlocks.root.func_176223_P();

    public TFGenHollowTree() {
        this(false);
    }

    public TFGenHollowTree(boolean par1) {
        super(par1);
    }

    public static boolean canGrowInto(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151586_h || material == Material.field_151587_i || blockType instanceof IGrowable || blockType instanceof BlockDirt || blockType instanceof BlockLog || blockType instanceof BlockBush || blockType instanceof BlockVine;
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        if (TFGenHollowTree.canGrowInto(worldIn.func_180495_p(pos).func_177230_c())) {
            super.func_175903_a(worldIn, pos, state);
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        double fAngle;
        int i;
        int height = random.nextInt(64) + 32;
        int diameter = random.nextInt(4) + 1;
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height + diameter > TFWorld.MAXHEIGHT) {
            return false;
        }
        int crownRadius = diameter * 4 + 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz = -crownRadius; dz <= crownRadius; ++dz) {
                for (int dy = height - crownRadius; dy <= height + crownRadius; ++dy) {
                    Block whatsThere = world.func_180495_p(pos.func_177982_a(dx, dy, dz)).func_177230_c();
                    if (whatsThere == Blocks.field_150350_a || whatsThere == Blocks.field_150362_t) continue;
                    return false;
                }
            }
        }
        Block j1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (j1 != Blocks.field_150349_c && j1 != Blocks.field_150346_d) {
            return false;
        }
        this.buildTrunk(world, random, pos, diameter, height);
        int numFireflies = random.nextInt(3 * diameter) + 5;
        for (i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            fAngle = random.nextDouble();
            this.addFirefly(world, pos, diameter, fHeight, fAngle);
        }
        numFireflies = random.nextInt(3 * diameter) + 5;
        for (i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            fAngle = random.nextDouble();
            this.addCicada(world, pos, diameter, fHeight, fAngle);
        }
        this.buildFullCrown(world, random, pos, diameter, height);
        int numBranches = random.nextInt(3) + 3;
        for (int i2 = 0; i2 <= numBranches; ++i2) {
            int branchHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            double branchRotation = random.nextDouble();
            this.makeSmallBranch(world, random, pos, diameter, branchHeight, 4.0, branchRotation, 0.35, true);
        }
        this.buildBranchRing(world, random, pos, diameter, 3, 2, 6, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, random, pos, diameter, 1, 2, 8, 0, 0.9, 0.0, 3, 5, 3, false);
        return true;
    }

    protected void buildFullCrown(World world, Random random, BlockPos pos, int diameter, int height) {
        int crownRadius = diameter * 4 + 4;
        int bvar = diameter + 2;
        this.buildBranchRing(world, random, pos, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 2, true);
        this.buildBranchRing(world, random, pos, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, pos, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 2, true);
        this.buildBranchRing(world, random, pos, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected void buildWeakCrown(World world, Random random, BlockPos pos, int diameter, int height) {
        int crownRadius = 8;
        int bvar = 2;
        this.buildBranchRing(world, random, pos, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, pos, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, pos, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 1, true);
        this.buildBranchRing(world, random, pos, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected void buildBranchRing(World world, Random random, BlockPos pos, int diameter, int branchHeight, int heightVar, int length, int lengthVar, double tilt, double tiltVar, int minBranches, int maxBranches, int size, boolean leafy) {
        int numBranches = random.nextInt(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.nextDouble();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.nextInt(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch(world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                continue;
            }
            if (size == 3) {
                this.makeRoot(world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt);
                continue;
            }
            this.makeSmallBranch(world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
        }
    }

    protected void buildTrunk(World world, Random random, BlockPos pos, int diameter, int height) {
        int dy;
        int dz;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    BlockPos dPos = pos.func_177982_a(dx, dy, dz);
                    if (TFGenHollowTree.hasAirAround(world, dPos)) {
                        this.func_175903_a(world, dPos, dist > hollow ? this.treeState : this.branchState);
                        continue;
                    }
                    this.func_175903_a(world, dPos, this.rootState);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = 0; dy <= height; ++dy) {
                    int az;
                    BlockPos dPos = pos.func_177982_a(dx, dy, dz);
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        this.func_175903_a(world, dPos, this.treeState);
                    }
                    if (dist <= hollow) {
                        // empty if block
                    }
                    if (dist != hollow || dx != hollow) continue;
                    this.func_175903_a(world, dPos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
    }

    protected void makeMedBranch(World world, Random random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        BlockPos src = TFGenHollowTree.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeMedBranch(world, random, src, length, angle, tilt, leafy);
    }

    protected void makeMedBranch(World world, Random random, BlockPos src, double length, double angle, double tilt, boolean leafy) {
        BlockPos dest = TFGenHollowTree.translate(src, length, angle, tilt);
        TFGenHollowTree.drawBresehnam(this, world, src, dest, this.branchState);
        if (leafy) {
            TFGenHollowTree.drawLeafBlob(this, world, dest, 2, this.leafState);
        }
        int numShoots = random.nextInt(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.nextDouble() * 0.8 + 0.2;
            double tiltVar = random.nextDouble() * 0.75 + 0.15;
            BlockPos bsrc = TFGenHollowTree.translate(src, length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, random, bsrc, slength, angle + angleVar, tilt * tiltVar, leafy);
        }
    }

    protected void makeSmallBranch(World world, Random random, BlockPos src, double length, double angle, double tilt, boolean leafy) {
        BlockPos dest = TFGenHollowTree.translate(src, length, angle, tilt);
        TFGenHollowTree.drawBresehnam(this, world, src, dest, this.branchState);
        if (leafy) {
            byte leafRad = (byte)(random.nextInt(2) + 1);
            TFGenHollowTree.drawLeafBlob(this, world, dest, leafRad, this.leafState);
        }
    }

    protected void makeSmallBranch(World world, Random random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        BlockPos src = TFGenHollowTree.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeSmallBranch(world, random, src, length, angle, tilt, leafy);
    }

    protected void makeRoot(World world, Random random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt) {
        BlockPos src = TFGenHollowTree.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        BlockPos dest = TFGenHollowTree.translate(src, length, angle, tilt);
        BlockPos[] lineArray = TFGenHollowTree.getBresehnamArrayCoords(src, dest);
        boolean stillAboveGround = true;
        for (BlockPos coord : lineArray) {
            if (stillAboveGround && TFGenHollowTree.hasAirAround(world, coord)) {
                this.func_175903_a(world, coord, this.branchState);
                this.func_175903_a(world, coord.func_177977_b(), this.branchState);
                continue;
            }
            this.func_175903_a(world, coord, this.rootState);
            this.func_175903_a(world, coord.func_177977_b(), this.rootState);
            stillAboveGround = false;
        }
    }

    protected void makeLargeBranch(World world, Random random, BlockPos src, double length, double angle, double tilt, boolean leafy) {
        BlockPos dest = TFGenHollowTree.translate(src, length, angle, tilt);
        TFGenHollowTree.drawBresehnam(this, world, src, dest, this.branchState);
        int reinforcements = random.nextInt(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            TFGenHollowTree.drawBresehnam(this, world, src.func_177982_a(vx, vy, vz), dest, this.branchState);
        }
        if (leafy) {
            TFGenHollowTree.drawLeafBlob(this, world, dest.func_177984_a(), 3, this.leafState);
        }
        int numMedBranches = random.nextInt((int)(length / 6.0)) + random.nextInt(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.nextDouble() * 0.3 + 0.3;
            double angleVar = random.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = TFGenHollowTree.translate(src, length * outVar, angle, tilt);
            this.makeMedBranch(world, random, bsrc, length * 0.6, angle + angleVar, tilt, leafy);
        }
        int numSmallBranches = random.nextInt(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.nextDouble() * 0.25 + 0.25;
            double angleVar = random.nextDouble() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = TFGenHollowTree.translate(src, length * outVar, angle, tilt);
            this.makeSmallBranch(world, random, bsrc, Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy);
        }
        if (random.nextInt(8) == 0) {
            this.makeLeafDungeon(world, random, dest.func_177984_a());
        }
    }

    private void makeLeafDungeon(World world, Random random, BlockPos pos) {
        TFGenHollowTree.drawLeafBlob(this, world, pos, 4, this.leafState);
        TFGenHollowTree.drawBlob(this, world, pos, 3, this.branchState);
        TFGenHollowTree.drawBlob(this, world, pos, 2, Blocks.field_150350_a.func_176223_P());
        world.func_180501_a(pos.func_177984_a(), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner ms = (TileEntityMobSpawner)world.func_175625_s(pos.func_177984_a());
        if (ms != null) {
            ms.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityTFSwarmSpider.class));
        }
        this.makeLeafDungeonChest(world, random, pos);
    }

    private void makeLeafDungeonChest(World world, Random random, BlockPos pos) {
        pos = pos.func_177972_a(EnumFacing.field_176754_o[random.nextInt(4)]);
        TFTreasure.tree_cache.generateChest(world, pos.func_177977_b(), false);
    }

    protected void makeLargeBranch(World world, Random random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        BlockPos src = TFGenHollowTree.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeLargeBranch(world, random, src, length, angle, tilt, leafy);
    }

    protected void addFirefly(World world, BlockPos pos, int diameter, int fHeight, double fAngle) {
        BlockPos src = TFGenHollowTree.translate(pos.func_177981_b(fHeight), diameter + 1, fAngle, 0.5);
        EnumFacing facing = EnumFacing.EAST;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = EnumFacing.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = EnumFacing.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = EnumFacing.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = EnumFacing.WEST;
        }
        if (TFBlocks.firefly.func_176196_c(world, src)) {
            this.func_175903_a(world, src, TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)facing));
        }
    }

    protected void addCicada(World world, BlockPos pos, int diameter, int fHeight, double fAngle) {
        BlockPos src = TFGenHollowTree.translate(pos.func_177981_b(fHeight), diameter + 1, fAngle, 0.5);
        EnumFacing facing = EnumFacing.EAST;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = EnumFacing.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = EnumFacing.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = EnumFacing.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = EnumFacing.WEST;
        }
        if (TFBlocks.cicada.func_176196_c(world, src)) {
            this.func_175903_a(world, src, TFBlocks.cicada.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)facing));
        }
    }
}

