/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFTreasure;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.structures.hollowtree.StructureTFTreeComponent;

public class ComponentTFHollowTreeLeafDungeon
extends StructureTFTreeComponent {
    int radius;

    public ComponentTFHollowTreeLeafDungeon() {
    }

    protected ComponentTFHollowTreeLeafDungeon(int index, int x, int y, int z, int radius) {
        super(index);
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        this.radius = radius;
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("leafRadius", this.radius);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager templateManager) {
        super.func_143011_b(par1NBTTagCompound, templateManager);
        this.radius = par1NBTTagCompound.func_74762_e("leafRadius");
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        return this.addComponentParts(world, random, sbb, false);
    }

    @Override
    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb, boolean drawLeaves) {
        if (!drawLeaves) {
            this.drawHollowBlob(world, sbb, this.radius, this.radius, this.radius, 3, 2, TFBlocks.log.func_176223_P().func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE), false);
            this.placeTreasureAtCurrentPosition(world, random, this.radius + 2, this.radius - 1, this.radius, TFTreasure.tree_cache, sbb);
            this.setSpawner(world, this.radius, this.radius, this.radius, sbb, EntityList.func_191306_a(EntityTFSwarmSpider.class));
        } else {
            this.drawHollowBlob(world, sbb, this.radius, this.radius, this.radius, 4, 2, TFBlocks.leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), true);
        }
        return true;
    }

    private void drawHollowBlob(World world, StructureBoundingBox sbb, int sx, int sy, int sz, int blobRadius, int hollowRadius, IBlockState blockState, boolean isLeaves) {
        for (int dx = 0; dx <= blobRadius; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= blobRadius; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= blobRadius; dz = (int)((byte)(dz + 1))) {
                    byte dist = 0;
                    dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist <= hollowRadius || dist > blobRadius) continue;
                    if (isLeaves) {
                        this.placeLeafBlock(world, blockState, sx + dx, sy + dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockState, sx + dx, sy + dy, sz - dz, sbb);
                        this.placeLeafBlock(world, blockState, sx - dx, sy + dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockState, sx - dx, sy + dy, sz - dz, sbb);
                        this.placeLeafBlock(world, blockState, sx + dx, sy - dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockState, sx + dx, sy - dy, sz - dz, sbb);
                        this.placeLeafBlock(world, blockState, sx - dx, sy - dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockState, sx - dx, sy - dy, sz - dz, sbb);
                        continue;
                    }
                    this.func_175811_a(world, blockState, sx + dx, sy + dy, sz + dz, sbb);
                    this.func_175811_a(world, blockState, sx + dx, sy + dy, sz - dz, sbb);
                    this.func_175811_a(world, blockState, sx - dx, sy + dy, sz + dz, sbb);
                    this.func_175811_a(world, blockState, sx - dx, sy + dy, sz - dz, sbb);
                    this.func_175811_a(world, blockState, sx + dx, sy - dy, sz + dz, sbb);
                    this.func_175811_a(world, blockState, sx + dx, sy - dy, sz - dz, sbb);
                    this.func_175811_a(world, blockState, sx - dx, sy - dy, sz + dz, sbb);
                    this.func_175811_a(world, blockState, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }
}

