/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import twilightforest.block.BlockTFRoots;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.RootVariant;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFOreMeter
extends ItemTF {
    protected ItemTFOreMeter() {
        this.func_77637_a(TFItems.creativeTab);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        int useX = MathHelper.func_76128_c((double)player.field_70165_t);
        int useZ = MathHelper.func_76128_c((double)player.field_70161_v);
        if (!world.field_72995_K) {
            this.countOreInArea(player, world, useX, useZ, 3);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void countOreInArea(EntityPlayer player, World world, int useX, int useZ, int radius) {
        int chunkX = useX >> 4;
        int chunkZ = useZ >> 4;
        int countStone = 0;
        int countDirt = 0;
        int countGravel = 0;
        int countCoal = 0;
        int countIron = 0;
        int countGold = 0;
        int countDiamond = 0;
        int countLapis = 0;
        int countRedstone = 0;
        int countExposedDiamond = 0;
        int countRoots = 0;
        int countOreRoots = 0;
        int total = 0;
        ScanResult dummy = new ScanResult();
        for (int cx = chunkX - radius; cx <= chunkX + radius; ++cx) {
            for (int cz = chunkZ - radius; cz <= chunkZ + radius; ++cz) {
                Map<IBlockState, ScanResult> results = this.countBlocksInChunk(world, chunkX, chunkZ);
                countStone += results.entrySet().stream().filter(e -> ((IBlockState)e.getKey()).func_177230_c() == Blocks.field_150348_b).mapToInt(e -> ((ScanResult)e.getValue()).count).sum();
                countDirt += results.entrySet().stream().filter(e -> ((IBlockState)e.getKey()).func_177230_c() == Blocks.field_150346_d).mapToInt(e -> ((ScanResult)e.getValue()).count).sum();
                countGravel += results.getOrDefault((Object)Blocks.field_150351_n.func_176223_P(), (ScanResult)dummy).count;
                countCoal += results.getOrDefault((Object)Blocks.field_150365_q.func_176223_P(), (ScanResult)dummy).count;
                countIron += results.getOrDefault((Object)Blocks.field_150366_p.func_176223_P(), (ScanResult)dummy).count;
                countGold += results.getOrDefault((Object)Blocks.field_150352_o.func_176223_P(), (ScanResult)dummy).count;
                countDiamond += results.getOrDefault((Object)Blocks.field_150482_ag.func_176223_P(), (ScanResult)dummy).count;
                countLapis += results.getOrDefault((Object)Blocks.field_150369_x.func_176223_P(), (ScanResult)dummy).count;
                countRedstone += results.getOrDefault((Object)Blocks.field_150450_ax.func_176223_P(), (ScanResult)dummy).count + results.getOrDefault((Object)Blocks.field_150439_ay.func_176223_P(), (ScanResult)dummy).count;
                countExposedDiamond += results.getOrDefault((Object)Blocks.field_150482_ag.func_176223_P(), (ScanResult)dummy).exposedCount;
                countRoots += results.getOrDefault((Object)TFBlocks.root.func_176223_P().func_177226_a(BlockTFRoots.VARIANT, (Comparable)((Object)RootVariant.ROOT)), (ScanResult)dummy).count;
                countOreRoots += results.getOrDefault((Object)TFBlocks.root.func_176223_P().func_177226_a(BlockTFRoots.VARIANT, (Comparable)((Object)RootVariant.LIVEROOT)), (ScanResult)dummy).count;
            }
        }
        total = countStone + countDirt + countGravel + countCoal + countIron + countGold + countDiamond + countLapis + countRedstone + countRoots + countOreRoots;
        player.func_145747_a((ITextComponent)new TextComponentString("Ore Meter!"));
        player.func_145747_a((ITextComponent)new TextComponentString("Metering chunks in radius " + radius + " around chunk [" + chunkX + ", " + chunkZ + "]"));
        player.func_145747_a((ITextComponent)new TextComponentString("Coal - " + countCoal + " " + this.percent(countCoal, total)));
        player.func_145747_a((ITextComponent)new TextComponentString("Iron - " + countIron + " " + this.percent(countIron, total)));
        player.func_145747_a((ITextComponent)new TextComponentString("Gold - " + countGold + " " + this.percent(countGold, total)));
        player.func_145747_a((ITextComponent)new TextComponentString("Diamond - " + countDiamond + " " + this.percent(countDiamond, total) + ", exposed - " + countExposedDiamond));
        player.func_145747_a((ITextComponent)new TextComponentString("Lapis - " + countLapis + " " + this.percent(countLapis, total)));
        player.func_145747_a((ITextComponent)new TextComponentString("Redstone - " + countRedstone + " " + this.percent(countRedstone, total)));
        player.func_145747_a((ITextComponent)new TextComponentString("Roots - " + countRoots + " " + this.percent(countRoots, total)));
        player.func_145747_a((ITextComponent)new TextComponentString("Ore Roots - " + countOreRoots + " " + this.percent(countOreRoots, total)));
    }

    private float percent(int count, int total) {
        return (float)count / (float)total * 100.0f;
    }

    private Map<IBlockState, ScanResult> countBlocksInChunk(World world, int cx, int cz) {
        IdentityHashMap<IBlockState, ScanResult> ret = new IdentityHashMap<IBlockState, ScanResult>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = cx << 4; x < (cx << 4) + 16; ++x) {
            for (int z = cz << 4; z < (cz << 4) + 16; ++z) {
                block2: for (int y = 0; y < 256; ++y) {
                    IBlockState state = world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                    ScanResult res = ret.computeIfAbsent(state, s -> new ScanResult());
                    ++res.count;
                    for (EnumFacing e : EnumFacing.field_82609_l) {
                        if (!world.func_175623_d((BlockPos)pos.func_189536_c(e))) continue;
                        ++res.exposedCount;
                        continue block2;
                    }
                }
            }
        }
        return ret;
    }

    private static class ScanResult {
        int count;
        int exposedCount;

        private ScanResult() {
        }
    }
}

