/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.TFPacketHandler;
import twilightforest.biomes.TFBiomes;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;
import twilightforest.network.PacketMagicMapFeatures;
import twilightforest.network.PacketMapRewrap;

public class ItemTFMagicMap
extends ItemMap
implements ModelRegisterCallback {
    private static final String STR_ID = "map";
    private static final HashMap<Biome, MapColorBrightness> BIOME_COLORS = new HashMap();

    public static ItemStack setupNewMap(World world, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(TFItems.magicMap, 1, world.func_72841_b(STR_ID));
        String s = "map_" + itemstack.func_77960_j();
        TFMagicMapData mapdata = new TFMagicMapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        mapdata.func_176054_a(worldX, worldZ, mapdata.field_76197_d);
        mapdata.field_76200_c = world.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMagicMapData loadMapData(int mapId, World worldIn) {
        String s = "map_" + mapId;
        TFMagicMapData mapdata = (TFMagicMapData)worldIn.func_72943_a(TFMagicMapData.class, s);
        if (mapdata == null) {
            mapdata = new TFMagicMapData(s);
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public TFMagicMapData getMapData(ItemStack stack, World worldIn) {
        String s = "map_" + stack.func_77960_j();
        TFMagicMapData mapdata = (TFMagicMapData)worldIn.func_72943_a(TFMagicMapData.class, s);
        if (mapdata == null && !worldIn.field_72995_K) {
            stack.func_77964_b(worldIn.func_72841_b(STR_ID));
            s = "map_" + stack.func_77960_j();
            mapdata = new TFMagicMapData(s);
            mapdata.field_76197_d = (byte)3;
            mapdata.func_176054_a(worldIn.func_72912_H().func_76079_c(), worldIn.func_72912_H().func_76074_e(), mapdata.field_76197_d);
            mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
            mapdata.func_76185_a();
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public void func_77872_a(World world, Entity viewer, MapData data) {
        if (world.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerX = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            Biome[] biomes = world.func_72959_q().func_76937_a((Biome[])null, startX, startZ, 128 * biomesPerPixel, 128 * biomesPerPixel);
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    Biome biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    Biome overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    Biome downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    if (overBiome == TFBiomes.stream || downBiome == TFBiomes.stream) {
                        biome = TFBiomes.stream;
                    }
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(biome);
                    MapColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.field_76198_e[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.field_76290_q * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.field_76198_e[xPixel + zPixel * 128] = ourPixel;
                        data.func_176053_a(xPixel, zPixel);
                    }
                    if (!TFFeature.isInFeatureChunk(world, worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel)) continue;
                    byte mapX = (byte)((float)(worldX - centerX) / (float)blocksPerPixel * 2.0f);
                    byte mapZ = (byte)((float)(worldZ - centerZ) / (float)blocksPerPixel * 2.0f);
                    MapDecoration.Type marker = this.getMapDecoFor(TFFeature.getFeatureAt(worldX, worldZ, world));
                    data.field_76203_h.put("feature" + worldX + "," + worldZ, new MapDecoration(marker, mapX, mapZ, 8));
                }
            }
        }
    }

    private MapDecoration.Type getMapDecoFor(TFFeature featureAt) {
        if (featureAt == TFFeature.hill1 || featureAt == TFFeature.hill2 || featureAt == TFFeature.hill3) {
            return MapDecoration.Type.TARGET_POINT;
        }
        if (featureAt == TFFeature.labyrinth || featureAt == TFFeature.trollCave || featureAt == TFFeature.yetiCave || featureAt == TFFeature.tfStronghold) {
            return MapDecoration.Type.MONUMENT;
        }
        if (featureAt == TFFeature.nagaCourtyard) {
            return MapDecoration.Type.TARGET_X;
        }
        return MapDecoration.Type.MANSION;
    }

    private MapColorBrightness getMapColorPerBiome(Biome biome) {
        if (BIOME_COLORS.isEmpty()) {
            ItemTFMagicMap.setupBiomeColors();
        }
        if (BIOME_COLORS.containsKey(biome)) {
            return BIOME_COLORS.get(biome);
        }
        return new MapColorBrightness(biome.field_76752_A.func_185909_g());
    }

    private static void setupBiomeColors() {
        BIOME_COLORS.put(TFBiomes.twilightForest, new MapColorBrightness(MapColor.field_151669_i, 1));
        BIOME_COLORS.put(TFBiomes.denseTwilightForest, new MapColorBrightness(MapColor.field_151669_i, 0));
        BIOME_COLORS.put(TFBiomes.tfLake, new MapColorBrightness(MapColor.field_151662_n, 3));
        BIOME_COLORS.put(TFBiomes.stream, new MapColorBrightness(MapColor.field_151662_n, 1));
        BIOME_COLORS.put(TFBiomes.tfSwamp, new MapColorBrightness(MapColor.field_151648_G, 3));
        BIOME_COLORS.put(TFBiomes.fireSwamp, new MapColorBrightness(MapColor.field_151655_K, 1));
        BIOME_COLORS.put(TFBiomes.clearing, new MapColorBrightness(MapColor.field_151661_c, 2));
        BIOME_COLORS.put(TFBiomes.oakSavanna, new MapColorBrightness(MapColor.field_151661_c, 0));
        BIOME_COLORS.put(TFBiomes.highlands, new MapColorBrightness(MapColor.field_151664_l, 0));
        BIOME_COLORS.put(TFBiomes.thornlands, new MapColorBrightness(MapColor.field_151663_o, 3));
        BIOME_COLORS.put(TFBiomes.highlandsCenter, new MapColorBrightness(MapColor.field_151680_x, 2));
        BIOME_COLORS.put(TFBiomes.fireflyForest, new MapColorBrightness(MapColor.field_151653_I, 1));
        BIOME_COLORS.put(TFBiomes.darkForest, new MapColorBrightness(MapColor.field_151651_C, 3));
        BIOME_COLORS.put(TFBiomes.darkForestCenter, new MapColorBrightness(MapColor.field_151676_q, 3));
        BIOME_COLORS.put(TFBiomes.snowy_forest, new MapColorBrightness(MapColor.field_151666_j, 1));
        BIOME_COLORS.put(TFBiomes.glacier, new MapColorBrightness(MapColor.field_151657_g, 1));
        BIOME_COLORS.put(TFBiomes.mushrooms, new MapColorBrightness(MapColor.field_151676_q, 0));
        BIOME_COLORS.put(TFBiomes.deepMushrooms, new MapColorBrightness(MapColor.field_151671_v, 0));
        BIOME_COLORS.put(TFBiomes.enchantedForest, new MapColorBrightness(MapColor.field_151672_u, 2));
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.UNCOMMON;
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_73012_v.nextInt(4) == 0) {
            TFMagicMapData data = this.getMapData(stack, world);
            data.checkExistingFeatures(world);
            PacketMagicMapFeatures packet = new PacketMagicMapFeatures(stack.func_77952_i(), data.serializeFeatures());
            return TFPacketHandler.CHANNEL.getPacketFrom((IMessage)packet);
        }
        Packet p = super.func_150911_c(stack, world, player);
        if (p instanceof SPacketMaps) {
            return TFPacketHandler.CHANNEL.getPacketFrom((IMessage)new PacketMapRewrap(false, (SPacketMaps)p));
        }
        return p;
    }

    public String func_77653_i(ItemStack stack) {
        return "" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim() + " #" + stack.func_77952_i();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    private static class MapColorBrightness {
        public MapColor color;
        public int brightness;

        public MapColorBrightness(MapColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(MapColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

