/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import twilightforest.entity.EntityTFRedcap;

public class EntityAITFAvoidFrontalAttack
extends EntityAIBase {
    private final EntityLiving me;
    final float speed;
    private final boolean lefty;
    private EntityLivingBase entityTarget;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private double minDistance = 3.0;
    private double maxDistance = 6.0;

    public EntityAITFAvoidFrontalAttack(EntityTFRedcap entityTFRedcap, float moveSpeed) {
        this.me = entityTFRedcap;
        this.speed = moveSpeed;
        this.lefty = this.me.field_70170_p.field_73012_v.nextBoolean();
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase attackTarget = this.me.func_70638_az();
        if (attackTarget == null || (double)attackTarget.func_70032_d((Entity)this.me) > this.maxDistance || (double)attackTarget.func_70032_d((Entity)this.me) < this.minDistance || !this.isTargetLookingAtMe(attackTarget)) {
            return false;
        }
        this.entityTarget = attackTarget;
        Vec3d avoidPos = this.findCirclePoint((Entity)this.me, (Entity)this.entityTarget, 5.0, this.lefty ? 1.0 : -1.0);
        if (avoidPos == null) {
            return false;
        }
        this.xPosition = avoidPos.field_72450_a;
        this.yPosition = avoidPos.field_72448_b;
        this.zPosition = avoidPos.field_72449_c;
        return true;
    }

    public void func_75249_e() {
        this.me.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, (double)this.speed);
    }

    public boolean func_75253_b() {
        EntityLivingBase attackTarget = this.me.func_70638_az();
        if (attackTarget == null) {
            return false;
        }
        if (!this.entityTarget.func_70089_S()) {
            return false;
        }
        if (this.me.func_70661_as().func_75500_f()) {
            return false;
        }
        boolean shouldContinue = (double)attackTarget.func_70032_d((Entity)this.me) < this.maxDistance && (double)attackTarget.func_70032_d((Entity)this.me) > this.minDistance && this.isTargetLookingAtMe(attackTarget);
        return shouldContinue;
    }

    public void func_75246_d() {
        this.me.func_70671_ap().func_75651_a((Entity)this.entityTarget, 30.0f, 30.0f);
    }

    public void func_75251_c() {
        this.entityTarget = null;
        this.me.func_70661_as().func_75499_g();
    }

    protected Vec3d findCirclePoint(Entity circler, Entity toCircle, double radius, double rotation) {
        double vecx = circler.field_70165_t - toCircle.field_70165_t;
        double vecz = circler.field_70161_v - toCircle.field_70161_v;
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + rotation);
        double dx = (double)MathHelper.func_76134_b((float)rangle) * radius;
        double dz = (double)MathHelper.func_76126_a((float)rangle) * radius;
        return new Vec3d(toCircle.field_70165_t + dx, circler.func_174813_aQ().field_72338_b, toCircle.field_70161_v + dz);
    }

    public boolean isTargetLookingAtMe(EntityLivingBase attackTarget) {
        double dz = this.me.field_70161_v - attackTarget.field_70161_v;
        double dx = this.me.field_70165_t - attackTarget.field_70165_t;
        float angle = (float)(Math.atan2(dz, dx) * 180.0 / 3.1415927410125732) - 90.0f;
        float difference = MathHelper.func_76135_e((float)((attackTarget.field_70177_z - angle) % 360.0f));
        return difference < 60.0f || difference > 300.0f;
    }
}

