/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.particle.TFParticleType;

public class EntityTFIceExploder
extends EntityMob {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("twilightforest", "entities/ice_exploder");
    private static final float EXPLOSION_RADIUS = 1.0f;

    public EntityTFIceExploder(World par1World) {
        super(par1World);
        this.func_70105_a(0.8f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public void func_70636_d() {
        super.func_70636_d();
        for (int i = 0; i < 3; ++i) {
            float px = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
            float py = this.func_70047_e() + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
            float pz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.field_70170_p, TFParticleType.SNOW_GUARDIAN, this.field_70142_S + (double)px, this.field_70137_T + (double)py, this.field_70136_U + (double)pz, 0.0, 0.0, 0.0);
        }
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.ICE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ() {
        return TFSounds.ICE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.ICE_DEATH;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76364_f() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.func_76364_f()).func_71029_a((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 60) {
            boolean mobGriefing = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, mobGriefing);
            if (mobGriefing) {
                this.transformBlocks();
            }
            this.field_70725_aQ = 19;
            super.func_70609_aI();
            this.field_70725_aQ = 60;
        }
    }

    private void transformBlocks() {
        int range = 4;
        BlockPos pos = new BlockPos((Entity)this);
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    float randRange;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (!(distance < (double)(randRange = (float)range + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 2.0f))) continue;
                    this.transformBlock(pos.func_177982_a(dx, dy, dz));
                }
            }
        }
    }

    private void transformBlock(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_149638_a((Entity)this) < 8.0f && state.func_185887_b(this.field_70170_p, pos) >= 0.0f) {
            int blockColor = state.func_185909_g().field_76291_p;
            if (this.shouldTransformGlass(state, pos)) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)this.getClosestDyeColor(blockColor)));
            } else if (this.shouldTransformClay(state, pos)) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)this.getClosestDyeColor(blockColor)));
            }
        }
    }

    private boolean shouldTransformClay(IBlockState state, BlockPos pos) {
        return state.func_177230_c().isNormalCube(state, (IBlockAccess)this.field_70170_p, pos);
    }

    private boolean shouldTransformGlass(IBlockState state, BlockPos pos) {
        return state.func_177230_c() != Blocks.field_150350_a && this.isBlockNormalBounds(state, pos) && (!state.func_185904_a().func_76218_k() || state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, pos) || state.func_177230_c() == Blocks.field_150432_aD || state.func_177230_c() == TFBlocks.auroraBlock);
    }

    private boolean isBlockNormalBounds(IBlockState state, BlockPos pos) {
        return Block.field_185505_j.equals((Object)state.func_185900_c((IBlockAccess)this.field_70170_p, pos));
    }

    private EnumDyeColor getClosestDyeColor(int blockColor) {
        int red = blockColor >> 16 & 0xFF;
        int green = blockColor >> 8 & 0xFF;
        int blue = blockColor & 0xFF;
        EnumDyeColor bestColor = EnumDyeColor.WHITE;
        int bestDifference = 1024;
        for (EnumDyeColor color : EnumDyeColor.values()) {
            int iColor = color.func_176768_e().field_76291_p;
            int iRed = iColor >> 16 & 0xFF;
            int iGreen = iColor >> 8 & 0xFF;
            int iBlue = iColor & 0xFF;
            int difference = Math.abs(red - iRed) + Math.abs(green - iGreen) + Math.abs(blue - iBlue);
            if (difference >= bestDifference) continue;
            bestColor = color;
            bestDifference = difference;
        }
        return bestColor;
    }

    public int func_70641_bl() {
        return 8;
    }
}

