/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.TFPacketHandler;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.TFBlocks;
import twilightforest.network.PacketAnnihilateBlock;
import twilightforest.util.WorldUtil;

public class EntityTFCubeOfAnnihilation
extends EntityThrowable {
    private boolean hasHitObstacle = false;

    public EntityTFCubeOfAnnihilation(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70178_ae = true;
    }

    public EntityTFCubeOfAnnihilation(World world, EntityLivingBase thrower) {
        super(world, thrower);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70178_ae = true;
        this.func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 1.5f, 1.0f);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (mop.field_72308_g != null && mop.field_72308_g instanceof EntityLivingBase && mop.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.func_85052_h())), 10.0f)) {
            this.field_70173_aa += 60;
        }
        if (mop.func_178782_a() != null && !this.field_70170_p.func_175623_d(mop.func_178782_a())) {
            this.affectBlocksInAABB(this.func_174813_aQ().func_72314_b((double)0.2f, (double)0.2f, (double)0.2f));
        }
    }

    private void affectBlocksInAABB(AxisAlignedBB box) {
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
            if (this.canAnnihilate(pos, state)) {
                this.field_70170_p.func_175698_g(pos);
                this.func_184185_a(SoundEvents.field_187541_bC, 0.125f, this.field_70146_Z.nextFloat() * 0.25f + 0.75f);
                this.sendAnnihilateBlockPacket(this.field_70170_p, pos);
                continue;
            }
            this.hasHitObstacle = true;
        }
    }

    private boolean canAnnihilate(BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == TFBlocks.deadrock || block == TFBlocks.castleBlock || block == TFBlocks.castleMagic && state.func_177229_b(BlockTFCastleMagic.COLOR) != EnumDyeColor.PURPLE || block == TFBlocks.forceField || block == TFBlocks.thorns) {
            return true;
        }
        return block.func_149638_a((Entity)this) < 8.0f && state.func_185887_b(this.field_70170_p, pos) >= 0.0f;
    }

    private void sendAnnihilateBlockPacket(World world, BlockPos pos) {
        PacketAnnihilateBlock message = new PacketAnnihilateBlock(pos);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)message, targetPoint);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_85052_h() == null) {
                this.func_70106_y();
                return;
            }
            Vec3d destPoint = new Vec3d(this.func_85052_h().field_70165_t, this.func_85052_h().field_70163_u + (double)this.func_85052_h().func_70047_e(), this.func_85052_h().field_70161_v);
            if (this.isReturning()) {
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                if (list.contains(this.func_85052_h())) {
                    this.func_70106_y();
                }
            } else {
                destPoint = destPoint.func_178787_e(this.func_85052_h().func_70040_Z().func_186678_a(16.0));
            }
            Vec3d velocity = new Vec3d(this.field_70165_t - destPoint.field_72450_a, this.field_70163_u + (double)(this.field_70131_O / 2.0f) - destPoint.field_72448_b, this.field_70161_v - destPoint.field_72449_c);
            this.field_70159_w -= velocity.field_72450_a;
            this.field_70181_x -= velocity.field_72448_b;
            this.field_70179_y -= velocity.field_72449_c;
            float currentSpeed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            float maxSpeed = 0.5f;
            if (currentSpeed > maxSpeed) {
                this.field_70159_w /= (double)(currentSpeed / maxSpeed);
                this.field_70181_x /= (double)(currentSpeed / maxSpeed);
                this.field_70179_y /= (double)(currentSpeed / maxSpeed);
            } else {
                float slow = 0.5f;
                this.field_70159_w *= (double)slow;
                this.field_70181_x *= (double)slow;
                this.field_70179_y *= (double)slow;
            }
            this.affectBlocksInAABB(this.func_174813_aQ().func_72314_b((double)0.2f, (double)0.2f, (double)0.2f));
        }
    }

    private boolean isReturning() {
        if (this.hasHitObstacle || this.func_85052_h() == null || !(this.func_85052_h() instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)this.func_85052_h();
        return !player.func_184587_cr();
    }
}

