/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import twilightforest.entity.EntityTFGoblinChain;
import twilightforest.util.WorldUtil;

public class EntityTFChainBlock
extends EntityThrowable
implements IEntityMultiPart {
    private static final int MAX_SMASH = 12;
    private static final int MAX_CHAIN = 16;
    private boolean isReturning = false;
    private int blocksSmashed = 0;
    private double velX;
    private double velY;
    private double velZ;
    private boolean isAttached;
    private EntityLivingBase attachedTo;
    public EntityTFGoblinChain chain1;
    public EntityTFGoblinChain chain2;
    public EntityTFGoblinChain chain3;
    public EntityTFGoblinChain chain4;
    public EntityTFGoblinChain chain5;
    private Entity[] partsArray;

    public EntityTFChainBlock(World par1World) {
        super(par1World);
        this.func_70105_a(0.6f, 0.6f);
        Entity[] entityArray = new Entity[5];
        this.chain1 = new EntityTFGoblinChain(this);
        entityArray[0] = this.chain1;
        this.chain2 = new EntityTFGoblinChain(this);
        entityArray[1] = this.chain2;
        this.chain3 = new EntityTFGoblinChain(this);
        entityArray[2] = this.chain3;
        this.chain4 = new EntityTFGoblinChain(this);
        entityArray[3] = this.chain4;
        this.chain5 = new EntityTFGoblinChain(this);
        entityArray[4] = this.chain5;
        this.partsArray = entityArray;
    }

    public EntityTFChainBlock(World world, EntityLivingBase thrower) {
        super(world, thrower);
        this.func_70105_a(0.6f, 0.6f);
        this.isReturning = false;
        this.func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 1.5f, 1.0f);
    }

    public void func_70186_c(double x, double y, double z, float speed, float accuracy) {
        super.func_70186_c(x, y, z, speed, accuracy);
        this.velX = this.field_70159_w;
        this.velY = this.field_70181_x;
        this.velZ = this.field_70179_y;
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (mop.field_72308_g != null && mop.field_72308_g instanceof EntityLivingBase && mop.field_72308_g != this.func_85052_h() && mop.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.func_85052_h())), 10.0f)) {
            this.field_70173_aa += 60;
        }
        if (mop.func_178782_a() != null && !this.field_70170_p.func_175623_d(mop.func_178782_a())) {
            if (!this.isReturning) {
                this.func_184185_a(SoundEvents.field_187689_f, 0.125f, this.field_70146_Z.nextFloat());
            }
            if (this.blocksSmashed < 12) {
                if (this.field_70170_p.func_180495_p(mop.func_178782_a()).func_185887_b(this.field_70170_p, mop.func_178782_a()) > 0.3f) {
                    double bounce = 0.6;
                    this.velX *= bounce;
                    this.velY *= bounce;
                    this.velZ *= bounce;
                    switch (mop.field_178784_b) {
                        case DOWN: {
                            if (!(this.velY > 0.0)) break;
                            this.velY *= -bounce;
                            break;
                        }
                        case UP: {
                            if (!(this.velY < 0.0)) break;
                            this.velY *= -bounce;
                            break;
                        }
                        case NORTH: {
                            if (!(this.velZ > 0.0)) break;
                            this.velZ *= -bounce;
                            break;
                        }
                        case SOUTH: {
                            if (!(this.velZ < 0.0)) break;
                            this.velZ *= -bounce;
                            break;
                        }
                        case WEST: {
                            if (!(this.velX > 0.0)) break;
                            this.velX *= -bounce;
                            break;
                        }
                        case EAST: {
                            if (!(this.velX < 0.0)) break;
                            this.velX *= -bounce;
                        }
                    }
                }
                this.affectBlocksInAABB(this.func_174813_aQ());
            }
            this.isReturning = true;
            if (this.blocksSmashed > 12 && this.field_70173_aa < 60) {
                this.field_70173_aa += 60;
            }
        }
    }

    private void affectBlocksInAABB(AxisAlignedBB box) {
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            EntityPlayer player;
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150350_a || !(block.func_149638_a((Entity)this) < 7.0f) || !(state.func_185887_b(this.field_70170_p, pos) >= 0.0f)) continue;
            if (this.func_85052_h() instanceof EntityPlayer && ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)(player = (EntityPlayer)this.func_85052_h()), (IBlockAccess)this.field_70170_p, (BlockPos)pos)) {
                block.func_180657_a(this.field_70170_p, player, pos, state, this.field_70170_p.func_175625_s(pos), player.func_184614_ca());
            }
            this.field_70170_p.func_175655_b(pos, false);
            ++this.blocksSmashed;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.chain1.func_70071_h_();
            this.chain2.func_70071_h_();
            this.chain3.func_70071_h_();
            this.chain4.func_70071_h_();
            this.chain5.func_70071_h_();
            if (!this.isAttached) {
                for (EntityPlayer nearby : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(-this.field_70159_w, -this.field_70181_x, -this.field_70179_y).func_72314_b(2.0, 2.0, 2.0))) {
                    this.attachedTo = nearby;
                }
                this.isAttached = true;
            }
            if (this.attachedTo != null) {
                Vec3d handVec = this.attachedTo.func_70040_Z().func_178785_b(-0.4f);
                double sx = this.attachedTo.field_70165_t + handVec.field_72450_a;
                double sy = this.attachedTo.field_70163_u + handVec.field_72448_b - (double)0.4f + (double)this.attachedTo.func_70047_e();
                double sz = this.attachedTo.field_70161_v + handVec.field_72449_c;
                double ox = sx - this.field_70165_t;
                double oy = sy - this.field_70163_u - 0.25;
                double oz = sz - this.field_70161_v;
                this.chain1.func_70107_b(sx - ox * 0.05, sy - oy * 0.05, sz - oz * 0.05);
                this.chain2.func_70107_b(sx - ox * 0.25, sy - oy * 0.25, sz - oz * 0.25);
                this.chain3.func_70107_b(sx - ox * 0.45, sy - oy * 0.45, sz - oz * 0.45);
                this.chain4.func_70107_b(sx - ox * 0.65, sy - oy * 0.65, sz - oz * 0.65);
                this.chain5.func_70107_b(sx - ox * 0.85, sy - oy * 0.85, sz - oz * 0.85);
            }
        } else if (this.func_85052_h() == null) {
            this.func_70106_y();
        } else {
            double distToPlayer = this.func_70011_f(this.func_85052_h().field_70165_t, this.func_85052_h().field_70163_u + (double)this.func_85052_h().func_70047_e(), this.func_85052_h().field_70161_v);
            if (!this.isReturning && distToPlayer > 16.0) {
                this.isReturning = true;
            }
            if (this.isReturning) {
                if (distToPlayer < 2.0) {
                    this.func_70106_y();
                }
                EntityLivingBase returnTo = this.func_85052_h();
                Vec3d back = new Vec3d(returnTo.field_70165_t, returnTo.field_70163_u + (double)returnTo.func_70047_e(), returnTo.field_70161_v).func_178788_d(this.func_174791_d()).func_72432_b();
                float age = Math.min((float)this.field_70173_aa * 0.03f, 1.0f);
                this.field_70159_w = this.velX * (1.0 - (double)age) + back.field_72450_a * 2.0 * (double)age;
                this.field_70181_x = this.velY * (1.0 - (double)age) + back.field_72448_b * 2.0 * (double)age - (double)this.func_70185_h();
                this.field_70179_y = this.velZ * (1.0 - (double)age) + back.field_72449_c * 2.0 * (double)age;
            }
        }
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource p_70965_2_, float p_70965_3_) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partsArray;
    }
}

