/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.BlockTFTowerTranslucent;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.TowerDeviceVariant;
import twilightforest.block.enums.TowerTranslucentVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFCReactorActive;
import twilightforest.tileentity.TileEntityTFGhastTrapActive;
import twilightforest.tileentity.TileEntityTFGhastTrapInactive;
import twilightforest.tileentity.TileEntityTFReverter;
import twilightforest.tileentity.TileEntityTFTowerBuilder;

public class BlockTFTowerDevice
extends Block
implements ModelRegisterCallback {
    public static final PropertyEnum<TowerDeviceVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", TowerDeviceVariant.class);

    public BlockTFTowerDevice() {
        super(Material.field_151575_d);
        this.func_149711_c(10.0f);
        this.func_149752_b(35.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.values()[meta]));
    }

    public int func_149738_a(World world) {
        return 15;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.REAPPEARING_INACTIVE.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.VANISH_INACTIVE.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.VANISH_LOCKED.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.VANISH_UNLOCKED.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.BUILDER_INACTIVE.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.ANTIBUILDER.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.GHASTTRAP_INACTIVE.ordinal()));
        par3List.add((Object)new ItemStack(par1, 1, TowerDeviceVariant.REACTOR_INACTIVE.ordinal()));
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_INACTIVE) {
            if (BlockTFTowerDevice.areNearbyLockBlocks(par1World, pos)) {
                par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, pos, TowerDeviceVariant.VANISH_ACTIVE);
            }
            return true;
        }
        if (variant == TowerDeviceVariant.REAPPEARING_INACTIVE) {
            if (BlockTFTowerDevice.areNearbyLockBlocks(par1World, pos)) {
                par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, pos, TowerDeviceVariant.REAPPEARING_ACTIVE);
            }
            return true;
        }
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)world.func_180495_p(pos).func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_INACTIVE) {
            return 6000.0f;
        }
        if (variant == TowerDeviceVariant.VANISH_LOCKED) {
            return 6000000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        switch (variant) {
            case REAPPEARING_ACTIVE: 
            case VANISH_INACTIVE: 
            case VANISH_ACTIVE: 
            case VANISH_LOCKED: 
            case VANISH_UNLOCKED: {
                return -1.0f;
            }
        }
        return super.func_176195_g(state, world, pos);
    }

    public static boolean areNearbyLockBlocks(World world, BlockPos pos) {
        boolean locked = false;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    IBlockState state = world.func_180495_p(pos.func_177982_a(dx, dy, dz));
                    if (state.func_177230_c() != TFBlocks.towerDevice || state.func_177229_b(VARIANT) != TowerDeviceVariant.VANISH_LOCKED) continue;
                    locked = true;
                }
            }
        }
        return locked;
    }

    public static void unlockBlock(World par1World, BlockPos pos) {
        IBlockState thereState = par1World.func_180495_p(pos);
        if (thereState.func_177230_c() == TFBlocks.towerDevice || thereState.func_177229_b(VARIANT) == TowerDeviceVariant.VANISH_LOCKED) {
            BlockTFTowerDevice.changeToBlockMeta(par1World, pos, thereState.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_UNLOCKED)));
            par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    private static void changeToBlockMeta(World par1World, BlockPos pos, IBlockState state) {
        Block thereBlockID = par1World.func_180495_p(pos).func_177230_c();
        if (thereBlockID == TFBlocks.towerDevice || thereBlockID == TFBlocks.towerTranslucent) {
            par1World.func_180501_a(pos, state, 3);
            par1World.func_175704_b(pos, pos);
            par1World.func_175722_b(pos, thereBlockID, false);
        }
    }

    public void func_176213_c(World par1World, BlockPos pos, IBlockState state) {
        if (!par1World.field_72995_K && state.func_177229_b(VARIANT) == TowerDeviceVariant.BUILDER_INACTIVE && par1World.func_175687_A(pos) > 0) {
            BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World par1World, BlockPos pos, Block myBlockID, BlockPos fromPos) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (!par1World.field_72995_K) {
            if (variant == TowerDeviceVariant.VANISH_INACTIVE && par1World.func_175687_A(pos) > 0 && !BlockTFTowerDevice.areNearbyLockBlocks(par1World, pos)) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, pos, TowerDeviceVariant.VANISH_ACTIVE);
            }
            if (variant == TowerDeviceVariant.REAPPEARING_INACTIVE && par1World.func_175687_A(pos) > 0 && !BlockTFTowerDevice.areNearbyLockBlocks(par1World, pos)) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, pos, TowerDeviceVariant.REAPPEARING_ACTIVE);
            }
            if (variant == TowerDeviceVariant.BUILDER_INACTIVE && par1World.func_175687_A(pos) > 0) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
                par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
                par1World.func_175684_a(pos, (Block)this, 4);
            }
            if (variant == TowerDeviceVariant.BUILDER_ACTIVE && par1World.func_175687_A(pos) == 0) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
                par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.6f);
                par1World.func_175684_a(pos, (Block)this, 4);
            }
            if (variant == TowerDeviceVariant.BUILDER_TIMEOUT && par1World.func_175687_A(pos) == 0) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
            }
            if (variant == TowerDeviceVariant.GHASTTRAP_INACTIVE && this.isInactiveTrapCharged(par1World, pos) && par1World.func_175687_A(pos) > 0) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.GHASTTRAP_ACTIVE)));
                par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
                par1World.func_175684_a(pos, (Block)this, 4);
            }
            if (variant == TowerDeviceVariant.REACTOR_INACTIVE && this.isReactorReady(par1World, pos)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REACTOR_ACTIVE)));
            }
        }
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.field_72995_K) {
            TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
            if (variant == TowerDeviceVariant.VANISH_ACTIVE || variant == TowerDeviceVariant.REAPPEARING_ACTIVE) {
                if (variant == TowerDeviceVariant.VANISH_ACTIVE) {
                    par1World.func_175698_g(pos);
                } else {
                    par1World.func_175656_a(pos, TFBlocks.towerTranslucent.func_176223_P().func_177226_a(BlockTFTowerTranslucent.VARIANT, (Comparable)((Object)TowerTranslucentVariant.REAPPEARING_INACTIVE)));
                    par1World.func_175684_a(pos, TFBlocks.towerTranslucent, 80);
                }
                par1World.func_175722_b(pos, (Block)this, false);
                par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.3f, 0.5f);
                for (EnumFacing e : EnumFacing.field_82609_l) {
                    BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, pos.func_177972_a(e));
                }
            }
            if (variant == TowerDeviceVariant.BUILDER_ACTIVE && par1World.func_175687_A(pos) > 0) {
                this.letsBuild(par1World, pos);
            }
            if (variant == TowerDeviceVariant.BUILDER_INACTIVE || variant == TowerDeviceVariant.BUILDER_TIMEOUT) {
                for (EnumFacing e : EnumFacing.field_82609_l) {
                    BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, pos.func_177972_a(e));
                }
            }
        }
    }

    private void letsBuild(World par1World, BlockPos pos) {
        TileEntityTFTowerBuilder tileEntity = (TileEntityTFTowerBuilder)par1World.func_175625_s(pos);
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    private boolean isInactiveTrapCharged(World par1World, BlockPos pos) {
        TileEntityTFGhastTrapInactive tileEntity = (TileEntityTFGhastTrapInactive)par1World.func_175625_s(pos);
        return tileEntity != null && tileEntity.isCharged();
    }

    private boolean isReactorReady(World world, BlockPos pos) {
        return Arrays.stream(EnumFacing.field_82609_l).allMatch(e -> world.func_180495_p(pos.func_177972_a(e)).func_177230_c() == Blocks.field_150451_bX);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_ACTIVE || variant == TowerDeviceVariant.REAPPEARING_ACTIVE || variant == TowerDeviceVariant.BUILDER_ACTIVE) {
            this.sparkle(par1World, pos);
        }
    }

    public void sparkle(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void checkAndActivateVanishBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block thereID = state.func_177230_c();
        if (!(thereID != TFBlocks.towerDevice || state.func_177229_b(VARIANT) != TowerDeviceVariant.VANISH_INACTIVE && state.func_177229_b(VARIANT) != TowerDeviceVariant.VANISH_UNLOCKED || BlockTFTowerDevice.areNearbyLockBlocks(world, pos))) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.VANISH_ACTIVE);
        } else if (thereID == TFBlocks.towerDevice && state.func_177229_b(VARIANT) == TowerDeviceVariant.REAPPEARING_INACTIVE && !BlockTFTowerDevice.areNearbyLockBlocks(world, pos)) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.REAPPEARING_ACTIVE);
        } else if (thereID == TFBlocks.towerTranslucent && state.func_177229_b(BlockTFTowerTranslucent.VARIANT) == TowerTranslucentVariant.BUILT_INACTIVE) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerTranslucentVariant.BUILT_ACTIVE);
        }
    }

    public static void changeToActiveVanishBlock(World world, BlockPos pos, TowerDeviceVariant variant) {
        BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TFBlocks.towerDevice.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant)));
    }

    public static void changeToActiveVanishBlock(World world, BlockPos pos, TowerTranslucentVariant variant) {
        BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TFBlocks.towerTranslucent.func_176223_P().func_177226_a(BlockTFTowerTranslucent.VARIANT, (Comparable)((Object)variant)));
    }

    private static void changeToActiveVanishBlock(World par1World, BlockPos pos, IBlockState state) {
        BlockTFTowerDevice.changeToBlockMeta(par1World, pos, state);
        par1World.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.3f, 0.6f);
        par1World.func_175684_a(pos, state.func_177230_c(), BlockTFTowerDevice.getTickRateFor(state, par1World.field_73012_v));
    }

    private static int getTickRateFor(IBlockState state, Random rand) {
        if (state.func_177230_c() == TFBlocks.towerDevice && (state.func_177229_b(VARIANT) == TowerDeviceVariant.VANISH_ACTIVE || state.func_177229_b(VARIANT) == TowerDeviceVariant.REAPPEARING_ACTIVE)) {
            return 2 + rand.nextInt(5);
        }
        if (state.func_177230_c() == TFBlocks.towerTranslucent && state.func_177229_b(BlockTFTowerTranslucent.VARIANT) == TowerTranslucentVariant.BUILT_ACTIVE) {
            return 10;
        }
        return 15;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos) != state) {
            return world.func_180495_p(pos).getLightValue(world, pos);
        }
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_ACTIVE: 
            case VANISH_ACTIVE: 
            case BUILDER_ACTIVE: {
                return 4;
            }
            case ANTIBUILDER: {
                return 10;
            }
            case GHASTTRAP_ACTIVE: 
            case REACTOR_ACTIVE: {
                return 15;
            }
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        return variant == TowerDeviceVariant.BUILDER_ACTIVE || variant == TowerDeviceVariant.ANTIBUILDER || variant == TowerDeviceVariant.REACTOR_ACTIVE || variant == TowerDeviceVariant.GHASTTRAP_INACTIVE || variant == TowerDeviceVariant.GHASTTRAP_ACTIVE;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE) {
            return new TileEntityTFTowerBuilder();
        }
        if (variant == TowerDeviceVariant.ANTIBUILDER) {
            return new TileEntityTFReverter();
        }
        if (variant == TowerDeviceVariant.GHASTTRAP_INACTIVE) {
            return new TileEntityTFGhastTrapInactive();
        }
        if (variant == TowerDeviceVariant.GHASTTRAP_ACTIVE) {
            return new TileEntityTFGhastTrapActive();
        }
        if (variant == TowerDeviceVariant.REACTOR_ACTIVE) {
            return new TileEntityTFCReactorActive();
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random par2Random, int par3) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case ANTIBUILDER: {
                return null;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE));
                break;
            }
            case BUILDER_ACTIVE: 
            case BUILDER_TIMEOUT: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE));
                break;
            }
            case VANISH_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_INACTIVE));
                break;
            }
            case GHASTTRAP_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.GHASTTRAP_INACTIVE));
                break;
            }
            case REACTOR_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REACTOR_INACTIVE));
            }
        }
        return this.func_176201_c(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelUtils.registerToStateSingleVariant(this, VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

