/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.util.numbers.ConstantProvider;
import cofh.lib.util.numbers.INumberProvider;
import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenGaussian
extends FeatureBase {
    final WorldGenerator worldGen;
    final INumberProvider count;
    final INumberProvider rolls;
    final INumberProvider meanY;
    final INumberProvider maxVar;

    public FeatureGenGaussian(String name, WorldGenerator worldGen, int count, int smoothness, int meanY, int maxVar, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        this(name, worldGen, new ConstantProvider(count), new ConstantProvider(smoothness), new ConstantProvider(meanY), new ConstantProvider(maxVar), biomeRes, regen, dimRes);
    }

    public FeatureGenGaussian(String name, WorldGenerator worldGen, INumberProvider count, INumberProvider smoothness, INumberProvider meanY, INumberProvider maxVar, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.rolls = smoothness;
        this.meanY = meanY;
        this.maxVar = maxVar;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, pos);
        int meanY = this.meanY.intValue(world, random, pos);
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int z;
            int x = blockX + random.nextInt(16);
            int y = meanY;
            int maxVar = this.maxVar.intValue(world, random, pos);
            if (maxVar > 1) {
                int rolls = this.rolls.intValue(world, random, pos);
                for (int v = 0; v < rolls; ++v) {
                    y += random.nextInt(maxVar);
                }
                y = Math.round((float)y - (float)maxVar * ((float)rolls * 0.5f));
            }
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

