/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.numbers;

import cofh.lib.util.numbers.ConstantProvider;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UniformRandomProvider
extends ConstantProvider {
    protected Number max;

    public UniformRandomProvider(Number min, Number max) {
        super(min);
        boolean doubleBad;
        this.max = max;
        boolean longBad = min.longValue() >= max.longValue();
        boolean bl = doubleBad = min.doubleValue() >= max.doubleValue();
        if (longBad && doubleBad) {
            throw new IllegalArgumentException("min >= max");
        }
    }

    @Override
    public long longValue(World world, Random rand, BlockPos pos) {
        return UniformRandomProvider.getRandomLong(this.max.longValue() - this.min.longValue(), rand) + this.min.longValue();
    }

    @Override
    public double doubleValue(World world, Random rand, BlockPos pos) {
        return UniformRandomProvider.getRandomDouble(this.max.doubleValue() - this.min.doubleValue(), rand) + this.min.doubleValue();
    }

    public static long getRandomLong(long val, Random rand) {
        long r;
        if (val == 0L) {
            return 0L;
        }
        int low = (int)(val & Integer.MAX_VALUE);
        int mid = (int)(val >>> 31 & Integer.MAX_VALUE);
        int high = (int)(val >>> 62 & Integer.MAX_VALUE);
        boolean mh = (mid | high) > 0;
        long l = r = mh ? (long)(rand.nextInt() & Integer.MAX_VALUE) : (long)rand.nextInt(low);
        if (mh) {
            r |= (long)((high > 0 ? rand.nextInt() & Integer.MAX_VALUE : rand.nextInt(mid)) << 31);
        }
        if (high > 0) {
            r |= (long)(rand.nextInt(high) << 62);
        }
        return r;
    }

    public static double getRandomDouble(double val, Random rand) {
        return rand.nextDouble() * val;
    }
}

