/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItem {
    public Item item;
    public int metadata;

    public static ComparableItem fromItemStack(ItemStack stack) {
        return new ComparableItem(stack);
    }

    protected ComparableItem() {
        this.item = null;
        this.metadata = 0;
    }

    public ComparableItem(Item item, int metadata) {
        this.item = item;
        this.metadata = metadata;
    }

    public ComparableItem(ItemStack stack) {
        if (stack != null) {
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
        } else {
            this.item = null;
            this.metadata = 0;
        }
    }

    public ComparableItem(ComparableItem stack) {
        this.item = stack.item;
        this.metadata = stack.metadata;
    }

    public ComparableItem set(ItemStack stack) {
        if (stack != null) {
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
        } else {
            this.item = null;
            this.metadata = 0;
        }
        return this;
    }

    protected final int getId() {
        return Item.func_150891_b((Item)this.item);
    }

    public boolean isEqual(ComparableItem other) {
        if (other == null) {
            return false;
        }
        if (this.metadata == other.metadata) {
            if (this.item == other.item) {
                return true;
            }
            if (this.item != null && other.item != null) {
                return this.item.delegate.get() == other.item.delegate.get();
            }
        }
        return false;
    }

    public ComparableItem clone() {
        return new ComparableItem(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComparableItem)) {
            return false;
        }
        return this.isEqual((ComparableItem)o);
    }

    public int hashCode() {
        return this.metadata & 0xFFFF | this.getId() << 16;
    }

    public String toString() {
        String b = this.getClass().getName() + '@' + System.identityHashCode(this) + '{' + "m:" + this.metadata + ", i:" + (this.item == null ? null : this.item.getClass().getName()) + '@' + System.identityHashCode(this.item) + ", v:" + this.getId() + '}';
        return b;
    }
}

