/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.asm.ASMCore;
import cofh.core.init.CoreProps;
import cofh.core.util.CoreUtils;
import cofh.core.world.WorldHandler;
import cofh.core.world.decoration.BoulderParser;
import cofh.core.world.decoration.ClusterParser;
import cofh.core.world.decoration.DungeonParser;
import cofh.core.world.decoration.GeodeParser;
import cofh.core.world.decoration.LakeParser;
import cofh.core.world.decoration.LargeVeinParser;
import cofh.core.world.decoration.PlateParser;
import cofh.core.world.decoration.SmallTreeParser;
import cofh.core.world.decoration.SpikeParser;
import cofh.core.world.decoration.StalagmiteParser;
import cofh.core.world.feature.CaveParser;
import cofh.core.world.feature.DecorationParser;
import cofh.core.world.feature.FractalParser;
import cofh.core.world.feature.GaussianParser;
import cofh.core.world.feature.SurfaceParser;
import cofh.core.world.feature.UnderfluidParser;
import cofh.core.world.feature.UniformParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.WeightedRandomItemStack;
import cofh.lib.util.WeightedRandomNBTTag;
import cofh.lib.util.WeightedRandomWorldGenerator;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.numbers.ConstantProvider;
import cofh.lib.util.numbers.INumberProvider;
import cofh.lib.util.numbers.SkellamRandomProvider;
import cofh.lib.util.numbers.UniformRandomProvider;
import cofh.lib.world.IFeatureGenerator;
import cofh.lib.world.IFeatureParser;
import cofh.lib.world.IGeneratorParser;
import cofh.lib.world.WorldGenMulti;
import cofh.lib.world.biome.BiomeInfo;
import cofh.lib.world.biome.BiomeInfoRarity;
import cofh.lib.world.biome.BiomeInfoSet;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigIncluderClasspath;
import com.typesafe.config.ConfigIncluderFile;
import com.typesafe.config.ConfigIncluderURL;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatureParser {
    private static File worldGenFolder;
    private static Path worldGenPathBase;
    private static File vanillaGen;
    private static final String WORLD_GEN_VANILLA = "assets/cofh/world/vanilla.json";
    private static HashMap<String, IFeatureParser> templateHandlers;
    private static HashMap<String, IGeneratorParser> generatorHandlers;
    private static Logger log;
    public static ArrayList<IFeatureGenerator> parsedFeatures;

    private FeatureParser() {
    }

    public static boolean registerTemplate(String template, IFeatureParser handler) {
        if (!templateHandlers.containsKey(template)) {
            templateHandlers.put(template, handler);
            return true;
        }
        log.error("Attempted to register duplicate template '%s'!", new Object[]{template});
        return false;
    }

    public static boolean registerGenerator(String generator, IGeneratorParser handler) {
        if (!generatorHandlers.containsKey(generator)) {
            generatorHandlers.put(generator, handler);
            return true;
        }
        log.error("Attempted to register duplicate generator '%s'!", new Object[]{generator});
        return false;
    }

    public static void initialize() {
        log.info("Registering default Templates...");
        FeatureParser.registerTemplate("gaussian", new GaussianParser());
        FeatureParser.registerTemplate("uniform", new UniformParser());
        FeatureParser.registerTemplate("surface", new SurfaceParser());
        FeatureParser.registerTemplate("fractal", new FractalParser());
        FeatureParser.registerTemplate("decoration", new DecorationParser());
        FeatureParser.registerTemplate("underwater", new UnderfluidParser(true));
        FeatureParser.registerTemplate("underfluid", new UnderfluidParser(false));
        FeatureParser.registerTemplate("cave", new CaveParser());
        log.info("Registering default generators...");
        FeatureParser.registerGenerator(null, new ClusterParser(false));
        FeatureParser.registerGenerator("", new ClusterParser(false));
        FeatureParser.registerGenerator("cluster", new ClusterParser(false));
        FeatureParser.registerGenerator("sparse-cluster", new ClusterParser(true));
        FeatureParser.registerGenerator("large-vein", new LargeVeinParser());
        FeatureParser.registerGenerator("decoration", new DecorationParser());
        FeatureParser.registerGenerator("lake", new LakeParser());
        FeatureParser.registerGenerator("plate", new PlateParser());
        FeatureParser.registerGenerator("geode", new GeodeParser());
        FeatureParser.registerGenerator("spike", new SpikeParser());
        FeatureParser.registerGenerator("boulder", new BoulderParser());
        FeatureParser.registerGenerator("dungeon", new DungeonParser());
        FeatureParser.registerGenerator("stalagmite", new StalagmiteParser(false));
        FeatureParser.registerGenerator("stalactite", new StalagmiteParser(true));
        FeatureParser.registerGenerator("small-tree", new SmallTreeParser());
        log.info("Verifying or creating base world generation directory...");
        worldGenFolder = new File(CoreProps.configDir, "/cofh/world/");
        worldGenPathBase = Paths.get(CoreProps.configDir.getPath(), new String[0]);
        if (!worldGenFolder.exists()) {
            try {
                if (!worldGenFolder.mkdir()) {
                    throw new Error("Could not make directory (unspecified error).");
                }
                log.info("Created world generation directory.");
            }
            catch (Throwable t) {
                log.fatal("Could not create world generation directory.", t);
                return;
            }
        }
        vanillaGen = new File(worldGenFolder, "vanilla.json");
        try {
            if (vanillaGen.createNewFile()) {
                CoreUtils.copyFileUsingStream(WORLD_GEN_VANILLA, vanillaGen);
                log.info("Created vanilla generation json.");
            } else if (!vanillaGen.exists()) {
                throw new Error("Unable to create vanilla generation json (unspecified error).");
            }
        }
        catch (Throwable t) {
            WorldHandler.genReplaceVanilla = false;
            log.error("Could not create vanilla generation json.", t);
        }
        log.info("Complete.");
    }

    private static void addFiles(ArrayList<File> list, File folder) {
        File o;
        AtomicInteger dirs = new AtomicInteger(0);
        File[] fList = folder.listFiles((file, name) -> {
            if (name == null) {
                return false;
            }
            if (new File(file, name).isDirectory()) {
                dirs.incrementAndGet();
                return true;
            }
            return name.toLowerCase(Locale.US).endsWith(".json");
        });
        Comparable<File> comparable = o = folder == worldGenFolder ? folder : worldGenPathBase.relativize(Paths.get(folder.getPath(), new String[0]));
        if (fList == null || fList.length <= 0) {
            log.debug("There are no World Generation files present in %s.", new Object[]{o});
            return;
        }
        int d = dirs.get();
        log.info("Found %d World Generation files and %d folders present in %s.", new Object[]{fList.length - d, d, o});
        list.addAll(Arrays.asList(fList));
    }

    public static void parseGenerationFiles() {
        File genFile;
        ArrayList<File> worldGenList = new ArrayList<File>(5);
        int i = 0;
        if (WorldHandler.genReplaceVanilla) {
            worldGenList.add(vanillaGen);
            ++i;
        }
        FeatureParser.addFiles(worldGenList, worldGenFolder);
        int e = worldGenList.size();
        while (i < e) {
            genFile = worldGenList.get(i);
            if (genFile.equals(vanillaGen)) {
                worldGenList.remove(i);
                break;
            }
            ++i;
        }
        for (i = 0; i < worldGenList.size(); ++i) {
            File genFile2 = worldGenList.get(i);
            if (!genFile2.isDirectory()) continue;
            worldGenList.remove(i--);
            FeatureParser.addFiles(worldGenList, genFile2);
        }
        e = worldGenList.size();
        for (i = 0; i < e; ++i) {
            Config genList;
            genFile = worldGenList.get(i);
            String file = worldGenPathBase.relativize(Paths.get(genFile.getPath(), new String[0])).toString();
            try {
                genList = ConfigFactory.parseFile((File)genFile, (ConfigParseOptions)Includer.options).resolve(Includer.resolveOptions);
            }
            catch (Throwable t) {
                log.error(String.format("Critical error reading from a world generation file: \"%s\" > Please be sure the file is correct!", genFile), t);
                continue;
            }
            if (genList.hasPath("dependencies") && !FeatureParser.processDependencies(genList.getValue("dependencies"))) {
                log.info("Unmet dependencies to load %s", new Object[]{file});
                continue;
            }
            if (!genList.hasPath("populate")) continue;
            log.info("Reading world generation info from: %s:", new Object[]{file});
            Config genData = genList.getConfig("populate");
            for (Map.Entry genEntry : genData.root().entrySet()) {
                String key = (String)genEntry.getKey();
                try {
                    if (((ConfigValue)genEntry.getValue()).valueType() != ConfigValueType.OBJECT) {
                        log.error("Error parsing generation entry: '%s' > This must be an object and is not.", new Object[]{key});
                        continue;
                    }
                    switch (FeatureParser.parseGenerationEntry(key, genData.getConfig(key))) {
                        case SUCCESS: {
                            log.debug("Generation entry successfully parsed: '%s'", new Object[]{key});
                            break;
                        }
                        case FAIL: {
                            log.error("Error parsing generation entry: '%s' > Please check the parameters.", new Object[]{key});
                            break;
                        }
                        case PASS: {
                            log.error("Error parsing generation entry: '%s' > It is a duplicate.", new Object[]{key});
                        }
                    }
                }
                catch (ConfigException ex) {
                    String line = "";
                    if (ex.origin() != null) {
                        line = String.format(" on line %d", ex.origin().lineNumber());
                    }
                    log.error(String.format("Error parsing entry '%s'%s: %s", key, line, ex.getMessage()));
                }
                catch (Throwable t) {
                    log.fatal(String.format("There was a severe error parsing '%s'!", key), t);
                }
            }
            log.info("Finished reading %s", new Object[]{file});
        }
    }

    private static boolean processDependencies(ConfigValue value) {
        if (value.valueType() == ConfigValueType.LIST) {
            ConfigList list = (ConfigList)value;
            boolean r = true;
            int e = list.size();
            for (int i = 0; i < e; ++i) {
                r &= FeatureParser.processDependency((ConfigValue)list.get(i));
            }
            return r;
        }
        return FeatureParser.processDependency(value);
    }

    private static boolean processDependency(ConfigValue value) {
        ModContainer con;
        String id;
        ArtifactVersion vers = null;
        boolean retComp = true;
        switch (value.valueType()) {
            case STRING: {
                id = (String)value.unwrapped();
                if (id.contains("@")) {
                    vers = VersionParser.parseVersionReference((String)id);
                    id = vers.getLabel();
                }
                con = (ModContainer)Loader.instance().getIndexedModList().get(id);
                break;
            }
            case OBJECT: {
                Config data = ((ConfigObject)value).toConfig();
                id = data.getString("id");
                con = (ModContainer)Loader.instance().getIndexedModList().get(id);
                if (data.hasPath("version")) {
                    vers = new DefaultArtifactVersion(id, data.getString("version"));
                }
                if (!data.hasPath("exclude")) break;
                retComp = !data.getBoolean("exclude");
                break;
            }
            default: {
                log.fatal("Invalid dependency at line %d!", new Object[]{value.origin().lineNumber()});
                return false;
            }
        }
        if (con == null && (con = ASMCore.getLoadedAPIs().get(id)) == null) {
            log.debug("Dependency '%s' is not loaded.", new Object[]{id});
            return false == retComp;
        }
        LoaderState.ModState state = Loader.instance().getModState(con);
        if (state == LoaderState.ModState.DISABLED || state == LoaderState.ModState.ERRORED) {
            log.debug("Dependency '%s' is disabled or crashed.", new Object[]{id});
            return false == retComp;
        }
        if (vers != null) {
            if (retComp != vers.containsVersion(con.getProcessedVersion())) {
                log.debug("Dependency '%s' has an incompatible version.", new Object[]{id});
                return false;
            }
            return true;
        }
        return true == retComp;
    }

    private static EnumActionResult parseGenerationEntry(String featureName, Config genObject) {
        if (genObject.hasPath("enabled") && !genObject.getBoolean("enabled")) {
            log.info('\"' + featureName + "\" is disabled.");
            return EnumActionResult.SUCCESS;
        }
        String templateName = FeatureParser.parseTemplate(genObject);
        IFeatureParser template = templateHandlers.get(templateName);
        if (template != null) {
            IFeatureGenerator feature = template.parseFeature(featureName, genObject, log);
            if (feature != null) {
                parsedFeatures.add(feature);
                return WorldHandler.addFeature(feature) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            log.warn("Template '" + templateName + "' failed to parse its entry!");
        } else {
            log.warn("Unknown template + '" + templateName + "'.");
        }
        return EnumActionResult.FAIL;
    }

    private static String parseTemplate(Config genObject) {
        return genObject.getString("distribution");
    }

    public static WorldGenerator parseGenerator(String def, Config genObject, List<WeightedRandomBlock> defaultMaterial) {
        if (!genObject.hasPath("generator")) {
            return null;
        }
        ConfigValue genData = genObject.root().get((Object)"generator");
        if (genData.valueType() == ConfigValueType.LIST) {
            List list = genObject.getConfigList("generator");
            ArrayList<WeightedRandomWorldGenerator> gens = new ArrayList<WeightedRandomWorldGenerator>(list.size());
            for (Config genElement : list) {
                WorldGenerator gen = FeatureParser.parseGeneratorData(def, genElement, defaultMaterial);
                int weight = genElement.hasPath("weight") ? genElement.getInt("weight") : 100;
                gens.add(new WeightedRandomWorldGenerator(gen, weight));
            }
            return new WorldGenMulti(gens);
        }
        if (genData.valueType() == ConfigValueType.OBJECT) {
            return FeatureParser.parseGeneratorData(def, genObject.getConfig("generator"), defaultMaterial);
        }
        log.error("Invalid data type for field 'generator'. > It must be an object or list.");
        return null;
    }

    private static WorldGenerator parseGeneratorData(String def, Config genObject, List<WeightedRandomBlock> defaultMaterial) {
        IGeneratorParser parser;
        String name = def;
        if (genObject.hasPath("type") && !generatorHandlers.containsKey(name = genObject.getString("type"))) {
            log.warn("Unknown generator '%s'! using '%s'", new Object[]{name, def});
            name = def;
        }
        ArrayList<WeightedRandomBlock> resList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(genObject.getValue("block"), resList, true)) {
            return null;
        }
        List<WeightedRandomBlock> matList = defaultMaterial;
        matList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(genObject.root().get((Object)"material"), matList, false)) {
            log.warn("Invalid material list! Using default list.");
            matList = defaultMaterial;
        }
        if ((parser = generatorHandlers.get(name)) == null) {
            throw new IllegalStateException("Generator '" + name + "' is not registered!");
        }
        return parser.parseGenerator(name, genObject, log, resList, matList);
    }

    public static BiomeInfoSet parseBiomeRestrictions(Config genObject) {
        BiomeInfoSet set;
        ConfigValue data = genObject.getValue("value");
        if (data.valueType() == ConfigValueType.LIST) {
            ConfigList restrictionList = (ConfigList)data;
            set = new BiomeInfoSet(restrictionList.size());
            int e = restrictionList.size();
            for (int i = 0; i < e; ++i) {
                BiomeInfo info = FeatureParser.parseBiomeData((ConfigValue)restrictionList.get(i));
                if (info == null) continue;
                set.add(info);
            }
        } else {
            set = new BiomeInfoSet(1);
            BiomeInfo info = FeatureParser.parseBiomeData(data);
            if (info != null) {
                set.add(info);
            }
        }
        return set;
    }

    private static BiomeInfo parseBiomeData(ConfigValue element) {
        BiomeInfo info = null;
        switch (element.valueType()) {
            case NULL: {
                log.info("Null biome entry. Ignoring.");
                break;
            }
            case OBJECT: {
                int t;
                Object data;
                int rarity;
                Config obj = ((ConfigObject)element).toConfig();
                String type = obj.getString("type");
                boolean wl = !obj.hasPath("whitelist") || obj.getBoolean("whitelist");
                ConfigValue value = obj.root().get((Object)"entry");
                List array = value.valueType() == ConfigValueType.LIST ? obj.getStringList("entry") : null;
                String entry = array != null ? null : (String)value.unwrapped();
                int n = rarity = obj.hasPath("rarity") ? obj.getInt("rarity") : -1;
                if (type.equalsIgnoreCase("name")) {
                    if (array != null) {
                        List names = array;
                        if (rarity > 0) {
                            info = new BiomeInfoRarity(names, 4, true, rarity);
                            break;
                        }
                        info = new BiomeInfo(names, 4, true);
                        break;
                    }
                    if (rarity > 0) {
                        info = new BiomeInfoRarity(entry, rarity);
                        break;
                    }
                    info = new BiomeInfo(entry);
                    break;
                }
                if (type.equalsIgnoreCase("dictionary")) {
                    if (array != null) {
                        ArrayList<BiomeDictionary.Type> tags = new ArrayList<BiomeDictionary.Type>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            tags.add(BiomeDictionary.Type.getType((String)((String)array.get(k)), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                        }
                        data = tags.toArray(new BiomeDictionary.Type[tags.size()]);
                        t = 6;
                    } else {
                        data = BiomeDictionary.Type.getType((String)entry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        t = 2;
                    }
                } else if (type.equalsIgnoreCase("id")) {
                    if (array != null) {
                        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            ids.add(new ResourceLocation((String)array.get(k)));
                        }
                        data = ids;
                        t = 8;
                    } else {
                        data = new ResourceLocation(entry);
                        t = 7;
                    }
                } else if (type.equalsIgnoreCase("temperature")) {
                    if (array != null) {
                        ArrayList<Biome.TempCategory> temps = new ArrayList<Biome.TempCategory>(array.size());
                        int j = array.size();
                        for (int k = 0; k < j; ++k) {
                            temps.add(Biome.TempCategory.valueOf((String)((String)array.get(k))));
                        }
                        data = EnumSet.copyOf(temps);
                        t = 5;
                    } else {
                        data = Biome.TempCategory.valueOf((String)entry);
                        t = 1;
                    }
                } else {
                    log.warn("Biome entry of unknown type");
                    break;
                }
                if (data == null) break;
                if (rarity > 0) {
                    info = new BiomeInfoRarity(data, t, wl, rarity);
                    break;
                }
                info = new BiomeInfo(data, t, wl);
                break;
            }
            case STRING: {
                info = new BiomeInfo((String)element.unwrapped());
                break;
            }
            default: {
                log.error("Unknown biome type in at line %d", new Object[]{element.origin().lineNumber()});
            }
        }
        return info;
    }

    public static Block parseBlockName(String blockRaw) {
        return (Block)Block.field_149771_c.getObjectBypass((Object)new ResourceLocation(blockRaw));
    }

    public static WeightedRandomBlock parseBlockEntry(ConfigValue genElement, boolean clamp) {
        int min = clamp ? 0 : -1;
        switch (genElement.valueType()) {
            case NULL: {
                log.warn("Null Block entry!");
                return null;
            }
            case OBJECT: {
                int weight;
                Config blockElement = ((ConfigObject)genElement).toConfig();
                if (!blockElement.hasPath("name")) {
                    log.error("Block entry needs a name!");
                    return null;
                }
                String blockName = blockElement.getString("name");
                Block block = FeatureParser.parseBlockName(blockName);
                if (block == null) {
                    log.error("Invalid block entry!");
                    return null;
                }
                int n = weight = blockElement.hasPath("weight") ? MathHelper.clamp(blockElement.getInt("weight"), 1, 1000000) : 100;
                if (blockElement.hasPath("properties")) {
                    BlockStateContainer blockstatecontainer = block.func_176194_O();
                    IBlockState state = block.func_176223_P();
                    for (Map.Entry propEntry : blockElement.getObject("properties").entrySet()) {
                        IProperty prop = blockstatecontainer.func_185920_a((String)propEntry.getKey());
                        if (prop == null) {
                            log.warn("Block '%s' does not have property '%s'.", new Object[]{blockName, propEntry.getKey()});
                        }
                        if (((ConfigValue)propEntry.getValue()).valueType() != ConfigValueType.STRING) {
                            log.error("Property '%s' is not a string. All block properties must be strings.", new Object[]{propEntry.getKey()});
                            prop = null;
                        }
                        if (prop == null) continue;
                        state = FeatureParser.setValue(state, prop, (String)((ConfigValue)propEntry.getValue()).unwrapped());
                    }
                    return new WeightedRandomBlock(state, weight);
                }
                int metadata = blockElement.hasPath("metadata") ? MathHelper.clamp(blockElement.getInt("metadata"), min, 15) : min;
                return new WeightedRandomBlock(block, metadata, weight);
            }
            case STRING: {
                Block block = FeatureParser.parseBlockName((String)genElement.unwrapped());
                if (block == null) {
                    log.error("Invalid block entry!");
                    return null;
                }
                return new WeightedRandomBlock(block, min);
            }
        }
        return null;
    }

    private static <T extends Comparable<T>> IBlockState setValue(IBlockState state, IProperty<T> prop, String val) {
        return state.func_177226_a(prop, (Comparable)prop.func_185929_b(val).get());
    }

    public static boolean parseResList(ConfigValue genElement, List<WeightedRandomBlock> resList, boolean clamp) {
        if (genElement == null) {
            return false;
        }
        if (genElement.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)genElement;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                WeightedRandomBlock entry = FeatureParser.parseBlockEntry((ConfigValue)blockList.get(i), clamp);
                if (entry == null) {
                    return false;
                }
                resList.add(entry);
            }
        } else {
            if (genElement.valueType() == ConfigValueType.NULL) {
                return true;
            }
            WeightedRandomBlock entry = FeatureParser.parseBlockEntry(genElement, clamp);
            if (entry == null) {
                return false;
            }
            resList.add(entry);
        }
        return true;
    }

    public static WeightedRandomNBTTag parseEntityEntry(ConfigValue genElement) {
        switch (genElement.valueType()) {
            case NULL: {
                log.warn("Null entity entry!");
                return null;
            }
            case OBJECT: {
                NBTTagCompound data;
                Config genObject = ((ConfigObject)genElement).toConfig();
                if (genObject.hasPath("spawner-tag")) {
                    try {
                        data = JsonToNBT.func_180713_a((String)genObject.getString("spawner-tag"));
                    }
                    catch (NBTException e) {
                        log.error(String.format("Invalid entity entry at line %d!", genElement.origin().lineNumber()), (Throwable)e);
                        return null;
                    }
                } else {
                    if (!genObject.hasPath("entity")) {
                        log.error("Invalid entity entry at line %d!", new Object[]{genElement.origin().lineNumber()});
                        return null;
                    }
                    data = new NBTTagCompound();
                    String type = genObject.getString("entity");
                    data.func_74778_a("EntityId", type);
                }
                int weight = genObject.hasPath("weight") ? genObject.getInt("weight") : 100;
                return new WeightedRandomNBTTag(weight, (NBTBase)data);
            }
            case STRING: {
                String type = (String)genElement.unwrapped();
                if (type == null) {
                    log.error("Invalid entity entry!");
                    return null;
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("EntityId", type);
                return new WeightedRandomNBTTag(100, (NBTBase)tag);
            }
        }
        log.warn("Invalid entity entry type at line %d", new Object[]{genElement.origin().lineNumber()});
        return null;
    }

    public static boolean parseEntityList(ConfigValue genElement, List<WeightedRandomNBTTag> list) {
        if (genElement.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)genElement;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                WeightedRandomNBTTag entry = FeatureParser.parseEntityEntry((ConfigValue)blockList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            WeightedRandomNBTTag entry = FeatureParser.parseEntityEntry(genElement);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static DungeonHooks.DungeonMob parseWeightedStringEntry(ConfigValue genElement) {
        int weight = 100;
        String type = null;
        switch (genElement.valueType()) {
            case LIST: {
                log.warn("Lists are not supported for string values at line %d.", new Object[]{genElement.origin().lineNumber()});
                return null;
            }
            case NULL: {
                log.warn("Null string entry at line %d", new Object[]{genElement.origin().lineNumber()});
                return null;
            }
            case OBJECT: {
                Config genObject = ((ConfigObject)genElement).toConfig();
                if (genObject.hasPath("type")) {
                    type = genObject.getString("name");
                } else {
                    log.warn("Value missing 'type' field at line %d", new Object[]{genElement.origin().lineNumber()});
                }
                if (!genObject.hasPath("weight")) break;
                weight = genObject.getInt("weight");
                break;
            }
            case STRING: 
            case BOOLEAN: 
            case NUMBER: {
                type = String.valueOf(genElement.unwrapped());
            }
        }
        return new DungeonHooks.DungeonMob(weight, new ResourceLocation(type));
    }

    public static boolean parseWeightedStringList(ConfigValue genElement, List<DungeonHooks.DungeonMob> list) {
        if (genElement.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)genElement;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                DungeonHooks.DungeonMob entry = FeatureParser.parseWeightedStringEntry((ConfigValue)blockList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            DungeonHooks.DungeonMob entry = FeatureParser.parseWeightedStringEntry(genElement);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static WeightedRandomItemStack parseWeightedRandomItem(ConfigValue genElement) {
        ItemStack stack;
        if (genElement.valueType() == ConfigValueType.NULL) {
            return null;
        }
        int metadata = 0;
        int stackSize = 1;
        int chance = 100;
        if (genElement.valueType() != ConfigValueType.OBJECT) {
            stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(String.valueOf(genElement.unwrapped()))), 1, metadata);
        } else {
            Config item = ((ConfigObject)genElement).toConfig();
            if (item.hasPath("metadata")) {
                metadata = item.getInt("metadata");
            }
            if (item.hasPath("count")) {
                stackSize = item.getInt("count");
            } else if (item.hasPath("stack-size")) {
                stackSize = item.getInt("stack-size");
            } else if (item.hasPath("amount")) {
                stackSize = item.getInt("amount");
            }
            if (stackSize <= 0) {
                stackSize = 1;
            }
            if (item.hasPath("weight")) {
                chance = item.getInt("weight");
            }
            if (item.hasPath("ore-name")) {
                String oreName = item.getString("ore-name");
                if (!ItemHelper.oreNameExists(oreName)) {
                    log.error("Invalid ore name for item at line %d!", new Object[]{genElement.origin().lineNumber()});
                    return null;
                }
                ItemStack oreStack = (ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0);
                stack = ItemHelper.cloneStack(oreStack, stackSize);
            } else {
                if (!item.hasPath("name")) {
                    log.error("Item entry missing valid name or ore name at line %d!", new Object[]{genElement.origin().lineNumber()});
                    return null;
                }
                stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.getString("name"))), stackSize, metadata);
            }
            if (item.hasPath("nbt")) {
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)item.getString("nbt"));
                    stack.func_77982_d(nbtbase);
                }
                catch (NBTException t) {
                    log.error("Item has invalid NBT data.", (Throwable)t);
                }
            }
        }
        return new WeightedRandomItemStack(stack, chance);
    }

    public static boolean parseWeightedItemList(ConfigValue genElement, List<WeightedRandomItemStack> res) {
        if (genElement.valueType() != ConfigValueType.LIST) {
            WeightedRandomItemStack entry = FeatureParser.parseWeightedRandomItem(genElement);
            if (entry == null) {
                return false;
            }
            res.add(entry);
        } else {
            ConfigList list = (ConfigList)genElement;
            int e = list.size();
            for (int i = 0; i < e; ++i) {
                WeightedRandomItemStack entry = FeatureParser.parseWeightedRandomItem((ConfigValue)list.get(i));
                if (entry == null) {
                    return false;
                }
                res.add(entry);
            }
        }
        return true;
    }

    public static INumberProvider parseNumberValue(ConfigValue genElement) {
        return FeatureParser.parseNumberValue(genElement, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static INumberProvider parseNumberValue(ConfigValue genElement, long min, long max) {
        switch (genElement.valueType()) {
            case NUMBER: {
                return new ConstantProvider(FeatureParser.boundCheck((Number)genElement.unwrapped(), min, max));
            }
            case OBJECT: {
                ConfigObject genData = (ConfigObject)genElement;
                Config genProp = genData.toConfig();
                switch (genData.size()) {
                    case 1: {
                        if (genData.containsKey((Object)"value")) {
                            return new ConstantProvider(FeatureParser.boundCheck(genProp.getNumber("value"), min, max));
                        }
                        if (!genData.containsKey((Object)"variance")) break;
                        return new SkellamRandomProvider(FeatureParser.boundCheck(genProp.getNumber("variance"), min, max));
                    }
                    case 2: {
                        if (!genData.containsKey((Object)"min") || !genData.containsKey((Object)"max")) break;
                        return new UniformRandomProvider(FeatureParser.boundCheck(genProp.getNumber("min"), min, max), FeatureParser.boundCheck(genProp.getNumber("max"), min, max));
                    }
                    default: {
                        throw new Error(String.format("Too many properties on object at line %s", genElement.origin().lineNumber()));
                    }
                    case 0: 
                }
                throw new Error(String.format("Unknown properties on object at line %s", genElement.origin().lineNumber()));
            }
        }
        throw new Error(String.format("Unsupported data type at line %s", genElement.origin().lineNumber()));
    }

    private static Number boundCheck(Number value, long min, long max) {
        if (value.longValue() >= min) {
            if (value.longValue() <= max) {
                return value;
            }
            return new Long(max);
        }
        return new Long(min);
    }

    static {
        templateHandlers = new HashMap();
        generatorHandlers = new HashMap();
        log = LogManager.getFormatterLogger((String)"CoFHWorld");
        parsedFeatures = new ArrayList();
    }

    private static class Includer
    implements ConfigIncluder,
    ConfigIncluderClasspath,
    ConfigIncluderFile,
    ConfigIncluderURL {
        public static Includer includer = new Includer();
        public static ConfigParseOptions options = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setIncluder((ConfigIncluder)includer);
        public static ConfigResolveOptions resolveOptions = ConfigResolveOptions.noSystem();

        private Includer() {
        }

        public ConfigIncluder withFallback(ConfigIncluder fallback) {
            return this;
        }

        public ConfigObject include(ConfigIncludeContext context, String what) {
            return this.includeFile(context, new File(what));
        }

        public ConfigObject includeFile(ConfigIncludeContext context, File file) {
            try {
                if (!FilenameUtils.directoryContains((String)worldGenFolder.getCanonicalPath(), (String)file.getCanonicalPath())) {
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
            return ConfigFactory.parseFileAnySyntax((File)file, (ConfigParseOptions)context.parseOptions()).root();
        }

        public ConfigObject includeResources(ConfigIncludeContext context, String what) {
            throw new IllegalArgumentException("Cannot include resources");
        }

        public ConfigObject includeURL(ConfigIncludeContext context, URL what) {
            throw new IllegalArgumentException("Cannot include URLs");
        }
    }
}

