/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.core.item.IFOVUpdateItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEventHandler
implements IResourceManagerReloadListener {
    public static final RenderEventHandler instance = new RenderEventHandler();
    private final TextureAtlasSprite[] blockDamageIcons = new TextureAtlasSprite[10];

    @SubscribeEvent
    public void handleFOVUpdateEvent(FOVUpdateEvent event) {
        ItemStack stack = event.getEntity().func_184607_cu();
        if (stack != null && stack.func_77973_b() instanceof IFOVUpdateItem) {
            event.setNewfov(event.getFov() - ((IFOVUpdateItem)stack.func_77973_b()).getFOVMod(stack, event.getEntity()));
        }
    }

    public void drawBlockDamageTexture(Tessellator tessellatorIn, VertexBuffer vertexBuffer, Entity entityIn, float partialTicks, World world, List<BlockPos> blocks) {
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        int progress = (int)(Minecraft.func_71410_x().field_71442_b.field_78770_f * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        renderEngine.func_110577_a(TextureMap.field_110575_b);
        this.preRenderDamagedBlocks();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        vertexBuffer.func_178969_c(-d0, -d1, -d2);
        vertexBuffer.func_78914_f();
        for (BlockPos blockpos : blocks) {
            IBlockState state;
            TileEntity tile = world.func_175625_s(blockpos);
            boolean hasBreak = tile != null && tile.canRenderBreaking();
            if (hasBreak || (state = world.func_180495_p(blockpos)).func_185904_a() == Material.field_151579_a) continue;
            Minecraft.func_71410_x().func_175602_ab().func_175020_a(state, blockpos, this.blockDamageIcons[progress], (IBlockAccess)world);
        }
        tessellatorIn.func_78381_a();
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
        this.postRenderDamagedBlocks();
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        for (int i = 0; i < this.blockDamageIcons.length; ++i) {
            this.blockDamageIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }
}

