/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.proxy;

import cofh.CoFHCore;
import cofh.core.block.IFogOverlay;
import cofh.core.gui.client.GuiFriendList;
import cofh.core.init.CoreProps;
import cofh.core.init.CoreTextures;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.key.KeyHandlerCore;
import cofh.core.proxy.Proxy;
import cofh.core.render.CustomEffectRenderer;
import cofh.core.render.FontRendererCore;
import cofh.core.render.RenderEventHandler;
import cofh.core.render.ShaderHelper;
import cofh.core.util.RegistrySocial;
import cofh.lib.util.RayTracer;
import cofh.lib.util.helpers.RenderHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    private static final ResourceLocation UNDERWATER_GRAYSCALE = new ResourceLocation("cofh:textures/misc/underwater_grayscale.png");
    public static FontRendererCore fontRenderer;
    public static final KeyBinding KEYBINDING_MULTIMODE;
    public static final KeyBinding KEYBINDING_AUGMENTS;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        Minecraft.field_71444_a = null;
        ShaderHelper.initShaders();
        if (CoreProps.disableParticles) {
            CoFHCore.LOG.info("Replacing EffectRenderer - Particles have been disabled.");
            Minecraft.func_71410_x().field_71452_i = new CustomEffectRenderer();
        }
        MinecraftForge.EVENT_BUS.register((Object)RenderEventHandler.instance);
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        super.initialize(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        fontRenderer = new FontRendererCore(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78264_a(Minecraft.func_71410_x().func_135016_M().func_135042_a());
            fontRenderer.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)fontRenderer);
        fontRenderer.initSpecialCharacters();
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
        CoreTextures.registerIcons(event);
    }

    @Override
    public void registerKeyBinds() {
        super.registerKeyBinds();
        KeyHandlerCore.addClientKeyBind(KeyBindingItemMultiMode.instance);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBINDING_MULTIMODE);
    }

    @Override
    public int getKeyBind(String key) {
        if (key.equalsIgnoreCase("cofh.multimode")) {
            return KEYBINDING_MULTIMODE.func_151463_i();
        }
        if (key.equalsIgnoreCase("cofh.augment")) {
            // empty if block
        }
        return -1;
    }

    @Override
    public void addIndexedChatMessage(ITextComponent chat, int index) {
        if (chat == null) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146242_c(index);
        } else {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a(chat, index);
        }
    }

    @SubscribeEvent
    public void handleFluidBlockOverlayEvent(RenderBlockOverlayEvent event) {
        Vec3d playerEyePos;
        EntityPlayer player;
        IBlockState state;
        Block block;
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER && (block = (state = player.field_70170_p.func_180495_p(new BlockPos(playerEyePos = RayTracer.getCorrectedHeadVec(player = event.getPlayer())))).func_177230_c()) instanceof IFogOverlay) {
            RenderHelper.bindTexture(UNDERWATER_GRAYSCALE);
            float brightness = player.func_70013_c(event.getRenderPartialTicks());
            Vec3d color = ((IFogOverlay)block).getFog(state, (Entity)player, 0.0f, 0.0f, 0.0f).func_186678_a((double)brightness);
            GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float yaw = -player.field_70177_z / 64.0f;
            float pitch = player.field_70125_A / 64.0f;
            Tessellator t = Tessellator.func_178181_a();
            VertexBuffer buffer = t.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + yaw), (double)(4.0f + pitch)).func_181675_d();
            buffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + yaw), (double)(4.0f + pitch)).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + yaw), (double)(0.0f + pitch)).func_181675_d();
            buffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + yaw), (double)(0.0f + pitch)).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.setCanceled(true);
        }
    }

    @Override
    public boolean isOp(String playerName) {
        return true;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public IThreadListener getClientListener() {
        return Minecraft.func_71410_x();
    }

    @Override
    public IThreadListener getServerListener() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    @Override
    public EntityPlayer findPlayer(String playerName) {
        for (EntityPlayer player : FMLClientHandler.instance().getClient().field_71441_e.field_73010_i) {
            if (!player.func_70005_c_().toLowerCase(Locale.US).equals(playerName.toLowerCase(Locale.US))) continue;
            return player;
        }
        return null;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public List<EntityPlayer> getPlayerList() {
        return new LinkedList<EntityPlayer>();
    }

    @Override
    public void updateFriendListGui() {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            ((GuiFriendList)Minecraft.func_71410_x().field_71462_r).taFriendList.textLines = RegistrySocial.clientPlayerFriends;
        }
    }

    @Override
    public float getSoundVolume(int category) {
        if (category > SoundCategory.values().length) {
            return 0.0f;
        }
        return FMLClientHandler.instance().getClient().field_71474_y.func_186711_a(SoundCategory.values()[category]);
    }

    static {
        KEYBINDING_MULTIMODE = new KeyBinding("key.cofh.multimode", 47, "key.cofh.category");
        KEYBINDING_AUGMENTS = null;
    }
}

