/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import cofh.api.item.IInventoryContainerItem;
import cofh.core.enchantment.EnchantmentHolding;
import cofh.core.enchantment.EnchantmentMultishot;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class CoreEnchantments {
    public static Enchantment holding;
    public static Enchantment multishot;
    public static Enchantment vorpal;
    public static final EnumEnchantmentType ENCHANTMENT_TYPE_STORAGE;

    private CoreEnchantments() {
    }

    public static void preInit() {
        holding = new EnchantmentHolding("cofhcore:holding");
        multishot = new EnchantmentMultishot("cofhcore:multishot");
        GameRegistry.register((IForgeRegistryEntry)holding);
        GameRegistry.register((IForgeRegistryEntry)multishot);
    }

    public static void addEnchantment(ItemStack stack, Enchantment ench, int level) {
        CoreEnchantments.addEnchantment(stack.func_77978_p(), Enchantment.func_185258_b((Enchantment)ench), level);
    }

    public static void addEnchantment(NBTTagCompound nbt, Enchantment ench, int level) {
        CoreEnchantments.addEnchantment(nbt, Enchantment.func_185258_b((Enchantment)ench), level);
    }

    public static void addEnchantment(ItemStack stack, int id, int level) {
        CoreEnchantments.addEnchantment(stack.func_77978_p(), id, level);
    }

    public static void addEnchantment(NBTTagCompound nbt, int id, int level) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagList list = CoreEnchantments.getEnchantmentTagList(nbt);
        boolean found = false;
        for (int i = 0; i < list.func_74745_c() && !found; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74765_d("id") != id) continue;
            tag.func_74777_a("id", (short)id);
            tag.func_74777_a("lvl", (short)level);
            found = true;
        }
        if (!found) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("id", (short)id);
            tag.func_74777_a("lvl", (short)level);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ench", (NBTBase)list);
    }

    private static NBTTagList getEnchantmentTagList(NBTTagCompound nbt) {
        return nbt.func_150295_c("ench", 10);
    }

    static {
        ENCHANTMENT_TYPE_STORAGE = EnumHelper.addEnchantmentType((String)"COFH:STORAGE", item -> item instanceof IInventoryContainerItem);
    }
}

