/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemFertilizer;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TransposerManager {
    private static Map<List<Integer>, TransposerRecipe> recipeMapFill = new THashMap();
    private static Map<ComparableItemStackTransposer, TransposerRecipe> recipeMapExtract = new THashMap();
    private static Set<ComparableItemStackTransposer> validationSet = new THashSet();
    public static final int DEFAULT_ENERGY = 400;

    public static TransposerRecipe getFillRecipe(ItemStack input, FluidStack fluid) {
        return input.func_190926_b() || fluid == null ? null : recipeMapFill.get(Arrays.asList(new ComparableItemStackTransposer(input).hashCode(), fluid.getFluid().getName().hashCode()));
    }

    public static TransposerRecipe getExtractRecipe(ItemStack input) {
        return input.func_190926_b() ? null : recipeMapExtract.get((Object)new ComparableItemStackTransposer(input));
    }

    public static boolean fillRecipeExists(ItemStack input, FluidStack fluid) {
        return TransposerManager.getFillRecipe(input, fluid) != null;
    }

    public static boolean extractRecipeExists(ItemStack input, FluidStack fluid) {
        return TransposerManager.getExtractRecipe(input) != null;
    }

    public static TransposerRecipe[] getFillRecipeList() {
        return recipeMapFill.values().toArray(new TransposerRecipe[recipeMapFill.size()]);
    }

    public static TransposerRecipe[] getExtractRecipeList() {
        return recipeMapExtract.values().toArray(new TransposerRecipe[recipeMapExtract.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains((Object)new ComparableItemStackTransposer(input));
    }

    public static void initialize() {
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150322_A), new ItemStack(Blocks.field_150377_bs), new FluidStack(TFFluids.fluidEnder, 250), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151130_bT), new FluidStack(FluidRegistry.LAVA, 250), false);
        TransposerManager.addExtractRecipe(2400, new ItemStack((Block)Blocks.field_150434_aF), ItemStack.field_190927_a, new FluidStack(FluidRegistry.WATER, 500), 0, false);
        TransposerManager.addExtractRecipe(2400, new ItemStack((Block)Blocks.field_150436_aH), new ItemStack(Items.field_151102_aT, 2), new FluidStack(FluidRegistry.WATER, 250), 0, false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151065_br), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151126_ay), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz, (int)1), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addFillRecipe(4000, new ItemStack((Block)Blocks.field_150354_m), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addFillRecipe(4000, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150360_v, 1, 0), new ItemStack(Blocks.field_150360_v, 1, 1), new FluidStack(FluidRegistry.WATER, 1000), true);
        TransposerManager.addFillRecipe(2000, ItemHelper.cloneStack((ItemStack)ItemFertilizer.fertilizerBasic), ItemHelper.cloneStack((ItemStack)ItemFertilizer.fertilizerRich), new FluidStack(TFFluids.fluidSap, 500), false);
        TransposerManager.loadRecipes();
    }

    public static void loadRecipes() {
        TransposerManager.addFillRecipe(2000, ItemHelper.getOre((String)"oreCinnabar"), ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalCinnabar, (int)1), new FluidStack(TFFluids.fluidCryotheum, 200), false);
    }

    public static void refresh() {
        ComparableItemStackTransposer input;
        TransposerRecipe tempRecipe;
        THashMap tempFill = new THashMap(recipeMapFill.size());
        THashMap tempExtract = new THashMap(recipeMapExtract.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<Integer>, TransposerRecipe> entry : recipeMapFill.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackTransposer(tempRecipe.input);
            FluidStack fluid = tempRecipe.fluid.copy();
            tempFill.put(Arrays.asList(input.hashCode(), fluid.getFluid().getName().hashCode()), tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<Object, TransposerRecipe> entry : recipeMapExtract.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackTransposer(tempRecipe.input);
            tempExtract.put(input, tempRecipe);
            tempSet.add(input);
        }
        recipeMapFill.clear();
        recipeMapExtract.clear();
        recipeMapFill = tempFill;
        recipeMapExtract = tempExtract;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static TransposerRecipe addFillRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null || fluid.amount <= 0 || energy <= 0) {
            return null;
        }
        if (TransposerManager.fillRecipeExists(input, fluid)) {
            return null;
        }
        TransposerRecipe recipeFill = new TransposerRecipe(input, output, fluid, energy, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStackTransposer(input).hashCode(), fluid.getFluid().getName().hashCode()), recipeFill);
        validationSet.add(new ComparableItemStackTransposer(input));
        if (reversible) {
            TransposerManager.addExtractRecipe(energy, output, input, fluid, 100, false);
        }
        return recipeFill;
    }

    public static TransposerRecipe addExtractRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input.func_190926_b() || fluid == null || fluid.amount <= 0 || energy <= 0) {
            return null;
        }
        if (TransposerManager.extractRecipeExists(input, fluid)) {
            return null;
        }
        if (output == null && reversible || output.func_190926_b() && chance != 0) {
            return null;
        }
        TransposerRecipe recipeExtraction = new TransposerRecipe(input, output, fluid, energy, chance);
        recipeMapExtract.put(new ComparableItemStackTransposer(input), recipeExtraction);
        validationSet.add(new ComparableItemStackTransposer(input));
        if (reversible) {
            TransposerManager.addFillRecipe(energy, output, input, fluid, false);
        }
        return recipeExtraction;
    }

    public static TransposerRecipe removeFillRecipe(ItemStack input, FluidStack fluid) {
        return recipeMapFill.remove(Arrays.asList(new ComparableItemStackTransposer(input).hashCode(), fluid.getFluid().getName().hashCode()));
    }

    public static TransposerRecipe removeExtractRecipe(ItemStack input) {
        return recipeMapExtract.remove((Object)new ComparableItemStackTransposer(input));
    }

    public static class ComparableItemStackTransposer
    extends ComparableItemStack {
        public static final String CROP = "crop";
        public static final String SEED = "seed";
        public static final String GEM = "gem";
        public static final String ORE = "ore";
        public static final String DUST = "dust";
        public static final String INGOT = "ingot";
        public static final String NUGGET = "nugget";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(CROP) || oreName.startsWith(SEED) || oreName.startsWith(GEM) || oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(INGOT) || oreName.startsWith(NUGGET);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                int i = 0;
                int e = ids.size();
                while (i < e) {
                    int id;
                    if ((id = ((Integer)ids.get(i++)).intValue()) == -1 || !ComparableItemStackTransposer.safeOreType(ItemHelper.oreProxy.getOreName(id))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackTransposer(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackTransposer.getOreID(stack);
        }

        public ComparableItemStackTransposer set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackTransposer.getOreID(stack);
            return this;
        }
    }

    public static class TransposerRecipe {
        final ItemStack input;
        final ItemStack output;
        final FluidStack fluid;
        final int energy;
        final int chance;

        public TransposerRecipe(ItemStack input, ItemStack output, FluidStack fluid, int energy, int chance) {
            this.input = input;
            this.output = output;
            this.fluid = fluid;
            this.energy = energy;
            this.chance = chance;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

