/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.fuels.enervation;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.inventory.ComparableItemStackNBT;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoEnervation;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.fuels.BaseFuelCategory;
import cofh.thermalexpansion.plugins.jei.fuels.enervation.EnervationFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.EnervationManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class EnervationFuelCategory
extends BaseFuelCategory<EnervationFuelWrapper> {
    public static boolean enable = true;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new EnervationFuelCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(EnervationFuelCategory.getRecipes(guiHelper), "thermalexpansion.enervation");
        registry.addRecipeClickArea(GuiDynamoEnervation.class, 115, 35, 16, 16, new String[]{"thermalexpansion.enervation"});
        registry.addRecipeCatalyst((Object)BlockDynamo.dynamoEnervation, new String[]{"thermalexpansion.enervation"});
    }

    public static List<EnervationFuelWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<EnervationFuelWrapper> recipes = new ArrayList<EnervationFuelWrapper>();
        for (ComparableItemStack fuel : EnervationManager.getFuels()) {
            ItemStack fuelStack = fuel.toItemStack();
            recipes.add(new EnervationFuelWrapper(guiHelper, fuelStack, EnervationManager.getFuelEnergy(fuelStack)));
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IEnergyContainerItem)) continue;
            try {
                HashSet<ComparableItemStackNBT> processedStacks = new HashSet<ComparableItemStackNBT>();
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(item, item.func_77640_w(), list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int energy;
                    IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)item;
                    ItemStack fuel = (ItemStack)iterator.next();
                    int maxEnergyStored = energyContainerItem.getMaxEnergyStored(fuel);
                    if (maxEnergyStored == 0) continue;
                    energyContainerItem.receiveEnergy(fuel, Integer.MAX_VALUE, false);
                    if (!processedStacks.add(new ComparableItemStackNBT(fuel)) || (energy = EnervationManager.getFuelEnergy(fuel)) <= 0) continue;
                    recipes.add(new EnervationFuelWrapper(guiHelper, fuel, energy, maxEnergyStored));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recipes;
    }

    public EnervationFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiDynamoEnervation.TEXTURE, 26, 11, 70, 62, 0, 0, 16, 78);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(6);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.dynamo.enervation.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.enervation";
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnervationFuelWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 33, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
    }
}

