/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.refinery;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiRefinery;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.refinery.RefineryRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeCategory
extends BaseRecipeCategory<RefineryRecipeWrapper> {
    public static boolean enable = true;
    IDrawableStatic drop;
    IDrawableStatic slot;
    IDrawableStatic tank;
    IDrawableStatic tankOverlayInput;
    IDrawableStatic tankOverlayOutput;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new RefineryRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(RefineryRecipeCategory.getRecipes(guiHelper), "thermalexpansion.refinery");
        registry.addRecipeClickArea(GuiRefinery.class, 76, 34, 24, 16, new String[]{"thermalexpansion.refinery"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineRefinery, new String[]{"thermalexpansion.refinery"});
    }

    public static List<RefineryRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<RefineryRecipeWrapper> recipes = new ArrayList<RefineryRecipeWrapper>();
        for (RefineryManager.RefineryRecipe recipe : RefineryManager.getRecipeList()) {
            recipes.add(new RefineryRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public RefineryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiRefinery.TEXTURE, 38, 11, 24, 62, 0, 0, 16, 124);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.drop = Drawables.getDrawables(guiHelper).getProgress(2);
        this.slot = Drawables.getDrawables(guiHelper).getSlot(1);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlayInput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
        this.tankOverlayOutput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.refinery.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.refinery";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.drop.draw(minecraft, 46, 23);
        this.slot.draw(minecraft, 77, 19);
        this.tank.draw(minecraft, 116, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RefineryRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        List outputItems = ingredients.getOutputs(ItemStack.class);
        List outputFluids = ingredients.getOutputs(FluidStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.init(0, true, 22, 8, 16, 30, 1000, false, (IDrawable)this.tankOverlayInput);
        guiItemStacks.init(0, false, 81, 23);
        guiFluidStacks.init(1, false, 117, 1, 16, 60, 1000, false, (IDrawable)this.tankOverlayOutput);
        guiFluidStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(0, (List)outputItems.get(0));
        guiFluidStacks.set(1, (List)outputFluids.get(0));
    }
}

