/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.plugins.MagicBeesPlugin;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ForestryPlugin {
    public static final String MOD_ID = "forestry";
    public static final String MOD_NAME = "Forestry";

    private ForestryPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Forestry is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ItemStack woodPile = ForestryPlugin.getBlockStack("wood_pile", 1);
            ItemStack beeswax = ForestryPlugin.getItem("beeswax");
            ItemStack refractoryWax = ForestryPlugin.getItem("refractory_wax");
            ItemStack combHoney = ForestryPlugin.getItem("bee_combs", 1, 0);
            ItemStack combCocoa = ForestryPlugin.getItem("bee_combs", 1, 1);
            ItemStack combSimmering = ForestryPlugin.getItem("bee_combs", 1, 2);
            ItemStack combStringy = ForestryPlugin.getItem("bee_combs", 1, 3);
            ItemStack combFrozen = ForestryPlugin.getItem("bee_combs", 1, 4);
            ItemStack combDripping = ForestryPlugin.getItem("bee_combs", 1, 5);
            ItemStack combSilky = ForestryPlugin.getItem("bee_combs", 1, 6);
            ItemStack combParched = ForestryPlugin.getItem("bee_combs", 1, 7);
            ItemStack combMysterious = ForestryPlugin.getItem("bee_combs", 1, 8);
            ItemStack combIrradiated = ForestryPlugin.getItem("bee_combs", 1, 9);
            ItemStack combPowdery = ForestryPlugin.getItem("bee_combs", 1, 10);
            ItemStack combReddened = ForestryPlugin.getItem("bee_combs", 1, 11);
            ItemStack combDarkened = ForestryPlugin.getItem("bee_combs", 1, 12);
            ItemStack combOmega = ForestryPlugin.getItem("bee_combs", 1, 13);
            ItemStack combWheat = ForestryPlugin.getItem("bee_combs", 1, 14);
            ItemStack combMossy = ForestryPlugin.getItem("bee_combs", 1, 15);
            ItemStack combMellow = ForestryPlugin.getItem("bee_combs", 1, 16);
            ItemStack propolis = ForestryPlugin.getItem("propolis", 1, 0);
            ItemStack propolisSilky = ForestryPlugin.getItem("propolis", 1, 1);
            ItemStack propolisPulsating = ForestryPlugin.getItem("propolis", 1, 2);
            ItemStack propolisSticky = ForestryPlugin.getItem("propolis", 1, 3);
            ItemStack pollenCrystalline = ForestryPlugin.getItem("pollen", 1, 1);
            ItemStack silkWisp = ForestryPlugin.getItem("crafting_material", 1, 2);
            ItemStack honeydew = ForestryPlugin.getItem("honeydew");
            ItemStack honeyDrop = ForestryPlugin.getItem("honey_drop", 1, 0);
            ItemStack honeyDropCharged = ForestryPlugin.getItem("honey_drop", 1, 1);
            ItemStack honeyDropOmega = ForestryPlugin.getItem("honey_drop", 1, 2);
            ItemStack mulch = ForestryPlugin.getItem("mulch");
            ItemStack phosphor = ForestryPlugin.getItem("phosphor");
            Fluid biomass = FluidRegistry.getFluid((String)"biomass");
            Fluid ethanol = FluidRegistry.getFluid((String)"bio.ethanol");
            Fluid honey = FluidRegistry.getFluid((String)"for.honey");
            Fluid juice = FluidRegistry.getFluid((String)"juice");
            Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
            FurnaceManager.addRecipePyrolysis(8000, woodPile, new ItemStack(Items.field_151044_h, 6, 1), 400);
            if (biomass != null && ethanol != null) {
                RefineryManager.addRecipe(3000, new FluidStack(biomass, 100), new FluidStack(ethanol, 30), ItemStack.field_190927_a);
            }
            int energy = 4800;
            if (honey != null) {
                TransposerManager.addExtractRecipe(energy, honeydew, ItemStack.field_190927_a, new FluidStack(honey, 100), 0, false);
                TransposerManager.addExtractRecipe(energy, honeyDrop, propolis, new FluidStack(honey, 100), 5, false);
            }
            energy = 2400;
            if (juice != null) {
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151034_e, (int)1), mulch, new FluidStack(juice, 200), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropDate"), (int)1), mulch, new FluidStack(juice, 50), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropLemon"), (int)1), mulch, new FluidStack(juice, 400), 10, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPapaya"), (int)1), mulch, new FluidStack(juice, 600), 10, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPlum"), (int)1), mulch, new FluidStack(juice, 100), 60, false);
            }
            if (seed_oil != null) {
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151014_N, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151080_bb, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151081_bc, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropCherry"), (int)1), mulch, new FluidStack(seed_oil, 50), 5, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropChestnut"), (int)1), mulch, new FluidStack(seed_oil, 220), 2, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropWalnut"), (int)1), mulch, new FluidStack(seed_oil, 180), 5, false);
            }
            energy = 4000;
            CentrifugeManager.addRecipe(energy, combHoney, Arrays.asList(beeswax, honeyDrop), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combCocoa, Arrays.asList(beeswax, new ItemStack(Items.field_151100_aR, 1, 3)), Arrays.asList(100, 50), null);
            CentrifugeManager.addRecipe(energy, combSimmering, Arrays.asList(refractoryWax, ItemHelper.cloneStack((ItemStack)phosphor, (int)2)), Arrays.asList(100, 70), null);
            CentrifugeManager.addRecipe(energy, combStringy, Arrays.asList(propolis, honeyDrop), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combFrozen, Arrays.asList(beeswax, honeyDrop, new ItemStack(Items.field_151126_ay), pollenCrystalline), Arrays.asList(80, 70, 40, 20), null);
            CentrifugeManager.addRecipe(energy, combDripping, Arrays.asList(honeydew, honeyDrop), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combSilky, Arrays.asList(honeyDrop, propolisSilky), Arrays.asList(100, 80), null);
            CentrifugeManager.addRecipe(energy, combParched, Arrays.asList(beeswax, honeyDrop), Arrays.asList(100, 90), null);
            CentrifugeManager.addRecipe(energy, combMysterious, Arrays.asList(propolisPulsating, honeyDrop), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combPowdery, Arrays.asList(new ItemStack(Items.field_151016_H, 1), beeswax, honeyDrop), Arrays.asList(90, 20, 20), null);
            CentrifugeManager.addRecipe(energy, combWheat, Arrays.asList(new ItemStack(Items.field_151015_O, 1), beeswax, honeyDrop), Arrays.asList(80, 20, 20), null);
            CentrifugeManager.addRecipe(energy, combMossy, Arrays.asList(beeswax, honeyDrop), Arrays.asList(100, 90), null);
            CentrifugeManager.addRecipe(energy, combMellow, Arrays.asList(honeydew, new ItemStack(Items.field_151128_bU, 1), beeswax), Arrays.asList(60, 30, 20), null);
            CentrifugeManager.addRecipe(energy, propolisSilky, Arrays.asList(silkWisp, propolis), Arrays.asList(60, 10), null);
            ThermalExpansion.LOG.info("Thermal Expansion: Forestry Plugin Enabled.");
            MagicBeesPlugin.initialize();
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Forestry Plugin encountered an error:", t);
        }
    }

    public static void postInit() {
        try {
            ForestryPlugin.addSeedOilRecipes();
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Forestry Plugin encountered an error:", t);
        }
    }

    public static void addSeedOilRecipes() {
        String[] oreNameList;
        Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
        if (seed_oil == null) {
            return;
        }
        for (String name : oreNameList = OreDictionary.getOreNames()) {
            NonNullList seed;
            if (!name.startsWith("seed") || (seed = OreDictionary.getOres((String)name, (boolean)false)).isEmpty()) continue;
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)((ItemStack)seed.get(0)), (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry:" + name));
        return block != null ? new ItemStack(block, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return ForestryPlugin.getBlockStack(name, amount, 0);
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:" + name));
        return item != null ? new ItemStack(item, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getItem(String name) {
        return ForestryPlugin.getItem(name, 1, 0);
    }
}

