/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.core.ISecurable;
import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RegistrySocial;
import cofh.core.util.core.IInitializer;
import cofh.core.util.crafting.RecipeSecure;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalfoundation.item.ItemSecurity;
import com.mojang.authlib.GameProfile;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSatchel
extends ItemMulti
implements IInitializer,
IMultiModeItem,
IInventoryContainerItem,
IEnchantableItem {
    public static boolean enableSecurity = true;
    private static TIntObjectHashMap<SatchelEntry> satchelMap = new TIntObjectHashMap();
    public static final int CREATIVE = 32000;
    public static boolean enable = true;
    public static ItemStack satchelBasic;
    public static ItemStack satchelHardened;
    public static ItemStack satchelReinforced;
    public static ItemStack satchelSignalum;
    public static ItemStack satchelResonant;
    public static ItemStack satchelCreative;

    public static ItemStack setDefaultInventoryTag(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74757_a("Accessible", true);
        return container;
    }

    public static boolean needsTag(ItemStack container) {
        return container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Accessible");
    }

    public ItemSatchel() {
        super("thermalexpansion");
        this.func_77625_d(1);
        this.func_77655_b("satchel");
        this.func_77637_a(ThermalExpansion.tabItems);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)stack, tooltip);
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.storage.satchel"));
        ItemHelper.addInventoryInformation((ItemStack)stack, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            int metadata = (Integer)iterator.next();
            list.add((Object)ItemSatchel.setDefaultInventoryTag(new ItemStack(item, 1, metadata)));
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return ((SatchelEntry)ItemSatchel.satchelMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable;
    }

    public int func_77619_b() {
        return 10;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (ItemSatchel.needsTag(stack)) {
            ItemSatchel.setDefaultInventoryTag(stack);
        }
        if (ServerHelper.isServerWorld((World)world)) {
            if (SecurityHelper.isSecure((ItemStack)stack) && SecurityHelper.isDefaultUUID((UUID)SecurityHelper.getOwner((ItemStack)stack).getId())) {
                SecurityHelper.setOwner((ItemStack)stack, (GameProfile)player.func_146103_bH());
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.item.success", new Object[0]));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (ItemSatchel.canPlayerAccess(stack, player)) {
                player.openGui((Object)ThermalExpansion.instance, 1, world, 0, 0, 0);
            } else if (SecurityHelper.isSecure((ItemStack)stack)) {
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.warning", new Object[]{SecurityHelper.getOwnerName((ItemStack)stack)}));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public static boolean canPlayerAccess(ItemStack stack, EntityPlayer player) {
        if (!SecurityHelper.isSecure((ItemStack)stack)) {
            return true;
        }
        String name = player.func_70005_c_();
        ISecurable.AccessMode access = SecurityHelper.getAccess((ItemStack)stack);
        if (access.isPublic() || CoreProps.enableOpSecureAccess && CoreUtils.isOp((String)name)) {
            return true;
        }
        GameProfile profile = SecurityHelper.getOwner((ItemStack)stack);
        UUID ownerID = profile.getId();
        if (SecurityHelper.isDefaultUUID((UUID)ownerID)) {
            return true;
        }
        UUID otherID = SecurityHelper.getID((EntityPlayer)player);
        return ownerID.equals(otherID) || access.isFriendsOnly() && RegistrySocial.playerHasAccess((String)name, (GameProfile)profile);
    }

    public static boolean hasHoldingEnchant(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack) > 0;
    }

    public static boolean isCreative(ItemStack stack) {
        return ItemHelper.getItemDamage((ItemStack)stack) == 32000;
    }

    public static int getLevel(ItemStack stack) {
        if (ItemSatchel.isCreative(stack) || !satchelMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((SatchelEntry)ItemSatchel.satchelMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
    }

    public static int getStorageIndex(ItemStack stack) {
        if (ItemSatchel.isCreative(stack) || !satchelMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int level = ((SatchelEntry)ItemSatchel.satchelMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return Math.min(1 + level + enchant, CoreProps.STORAGE_SIZE.length - 1);
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 3;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalexpansion.satchel.a." + this.getMode(stack), new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("access=%s,type=%s", SecurityHelper.getAccess((ItemStack)stack).toString().toLowerCase(Locale.US), ((SatchelEntry)ItemSatchel.satchelMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int i = 0; i < ISecurable.AccessMode.values().length; ++i) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("access=%s,type=%s", ISecurable.AccessMode.values()[i].toString().toLowerCase(Locale.US), ((ItemMulti.ItemEntry)entry.getValue()).name))});
            }
        }
    }

    public int getSizeInventory(ItemStack container) {
        return CoreProps.STORAGE_SIZE[ItemSatchel.getStorageIndex(container)];
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return satchelMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack)) && ((SatchelEntry)ItemSatchel.satchelMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable && enchantment == CoreEnchantments.holding;
    }

    public boolean preInit() {
        ItemSatchel.config();
        satchelBasic = this.addSatchelItem(0, "standard0", 0, EnumRarity.COMMON);
        satchelHardened = this.addSatchelItem(1, "standard1", 1, EnumRarity.COMMON);
        satchelReinforced = this.addSatchelItem(2, "standard2", 2, EnumRarity.UNCOMMON);
        satchelSignalum = this.addSatchelItem(3, "standard3", 3, EnumRarity.UNCOMMON);
        satchelResonant = this.addSatchelItem(4, "standard4", 4, EnumRarity.RARE);
        satchelCreative = this.addSatchelItem(32000, "creative", 0, EnumRarity.EPIC, false);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)satchelBasic, (Object[])new Object[]{" Y ", "IXI", "Y Y", Character.valueOf('I'), "ingotTin", Character.valueOf('X'), "blockWool", Character.valueOf('Y'), Items.field_151116_aA}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)satchelBasic, (Object[])new Object[]{" Y ", "IXI", "Y Y", Character.valueOf('I'), "ingotTin", Character.valueOf('X'), "blockWool", Character.valueOf('Y'), "blockRockwool"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(satchelHardened, new Object[]{" Y ", "IXI", "Y Y", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), satchelBasic, Character.valueOf('Y'), "nuggetTin"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(satchelReinforced, new Object[]{" Y ", "IXI", "Y Y", Character.valueOf('I'), "ingotElectrum", Character.valueOf('X'), satchelHardened, Character.valueOf('Y'), "nuggetInvar"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(satchelSignalum, new Object[]{" Y ", "IXI", "Y Y", Character.valueOf('I'), "ingotSignalum", Character.valueOf('X'), satchelReinforced, Character.valueOf('Y'), "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(satchelResonant, new Object[]{" Y ", "IXI", "Y Y", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), satchelSignalum, Character.valueOf('Y'), "nuggetSignalum"}));
        ItemHelper.addRecipe((IRecipe)new RecipeSecure(satchelBasic, new Object[]{" L ", "SXS", " S ", Character.valueOf('L'), ItemSecurity.lock, Character.valueOf('S'), "nuggetSignalum", Character.valueOf('X'), satchelBasic}));
        ItemHelper.addRecipe((IRecipe)new RecipeSecure(satchelHardened, new Object[]{" L ", "SXS", " S ", Character.valueOf('L'), ItemSecurity.lock, Character.valueOf('S'), "nuggetSignalum", Character.valueOf('X'), satchelHardened}));
        ItemHelper.addRecipe((IRecipe)new RecipeSecure(satchelReinforced, new Object[]{" L ", "SXS", " S ", Character.valueOf('L'), ItemSecurity.lock, Character.valueOf('S'), "nuggetSignalum", Character.valueOf('X'), satchelReinforced}));
        ItemHelper.addRecipe((IRecipe)new RecipeSecure(satchelSignalum, new Object[]{" L ", "SXS", " S ", Character.valueOf('L'), ItemSecurity.lock, Character.valueOf('S'), "nuggetSignalum", Character.valueOf('X'), satchelSignalum}));
        ItemHelper.addRecipe((IRecipe)new RecipeSecure(satchelResonant, new Object[]{" L ", "SXS", " S ", Character.valueOf('L'), ItemSecurity.lock, Character.valueOf('S'), "nuggetSignalum", Character.valueOf('X'), satchelResonant}));
        ItemHelper.addRecipe((IRecipe)new RecipeSecure(satchelCreative, new Object[]{" L ", "SXS", " S ", Character.valueOf('L'), ItemSecurity.lock, Character.valueOf('S'), "nuggetSignalum", Character.valueOf('X'), satchelCreative}));
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private static void config() {
        String category = "Item.Satchel";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    private void addSatchelEntry(int metadata, String name, int level, boolean enchantable) {
        satchelMap.put(metadata, (Object)new SatchelEntry(name, level, enchantable));
    }

    private ItemStack addSatchelItem(int metadata, String name, int level, EnumRarity rarity, boolean enchantable) {
        this.addSatchelEntry(metadata, name, level, enchantable);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addSatchelItem(int metadata, String name, int level, EnumRarity rarity) {
        this.addSatchelEntry(metadata, name, level, true);
        return this.addItem(metadata, name, rarity);
    }

    public class SatchelEntry {
        public final String name;
        public final int level;
        public final boolean enchantable;

        SatchelEntry(String name, int level, boolean enchantable) {
            this.name = name;
            this.level = level;
            this.enchantable = enchantable;
        }
    }
}

