/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.tileentity.ITileInfo;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentableSecure;
import cofh.thermalexpansion.block.storage.BlockTank;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTank
extends TileAugmentableSecure
implements ITickable,
ITileInfo {
    public static final int CAPACITY_BASE = 20000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final int RENDER_LEVELS = 100;
    private static boolean enableSecurity = true;
    private int compareTracker;
    private int lastDisplayLevel;
    public byte enchantHolding;
    boolean renderFlag = true;
    boolean cached = false;
    boolean[] adjacentTanks = new boolean[2];
    private FluidTankCore tank = new FluidTankCore(TileTank.getCapacity(0, 0));

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTank.class, (String)"thermalexpansion:storage_tank");
        TileTank.config();
    }

    public static void config() {
        String comment = "Enable this to allow for Tanks to be securable.";
        enableSecurity = ThermalExpansion.CONFIG.get("Security", "Tank.Securable", true, comment);
        String category = "Storage.Tank";
        BlockTank.enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        int capacity = 20000;
        comment = "Adjust this value to change the amount of Fluid (in mB) stored by a Basic Tank. This base value will scale with block level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    public String getTileName() {
        return "tile.thermalexpansion.storage.tank.name";
    }

    public int getType() {
        return 0;
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        this.sendTilePacket(Side.CLIENT);
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        this.enableAutoOutput = !this.enableAutoOutput;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getLightValue() {
        return this.tank.getFluid() == null ? 0 : this.tank.getFluid().getFluid().getLuminosity();
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers(true);
    }

    public void onNeighborTileChange(BlockPos pos) {
        super.onNeighborTileChange(pos);
        this.updateAdjacentHandlers(true);
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.transferFluid();
        if (this.timeCheck()) {
            int curScale = this.getScaledFluidStored(15);
            if (curScale != this.compareTracker) {
                this.compareTracker = curScale;
                this.callNeighborTileChange();
            }
            if (!this.cached) {
                this.updateLighting();
                this.updateAdjacentHandlers(false);
                this.sendTilePacket(Side.CLIENT);
            }
        }
        if (this.renderFlag && this.timeCheckEighth()) {
            this.updateRender();
        }
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.tank.setCapacity(TileTank.getCapacity(level, this.enchantHolding));
            if (this.isCreative && this.getTankFluidAmount() > 0) {
                this.tank.getFluid().amount = this.tank.getCapacity();
            }
            return true;
        }
        return false;
    }

    @Override
    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public static int getCapacity(int level, int enchant) {
        return CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * enchant / 2;
    }

    public int getScaledFluidStored(int scale) {
        return this.tank.getFluid() == null ? 0 : this.tank.getFluid().amount * scale / this.tank.getCapacity();
    }

    protected void transferFluid() {
        if (!this.enableAutoOutput || this.tank.getFluidAmount() <= 0) {
            return;
        }
        int toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.DOWN, (FluidStack)new FluidStack(this.tank.getFluid(), Math.min(this.getFluidTransfer(this.level), this.tank.getFluidAmount())), (boolean)true);
        if (toDrain > 0) {
            this.renderFlag = !this.isCreative;
            this.tank.drain(toDrain, !this.isCreative);
        }
    }

    protected void updateAdjacentHandlers(boolean packet) {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        boolean curAutoOutput = this.enableAutoOutput;
        this.adjacentTanks[0] = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)EnumFacing.DOWN) instanceof TileTank;
        this.enableAutoOutput |= this.adjacentTanks[0];
        this.adjacentTanks[1] = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)EnumFacing.UP) instanceof TileTank;
        if (packet && curAutoOutput != this.enableAutoOutput) {
            this.sendTilePacket(Side.CLIENT);
        }
        this.cached = true;
    }

    public int getTankCapacity() {
        return this.tank.getCapacity();
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void updateRender() {
        this.renderFlag = false;
        boolean sendUpdate = false;
        int curDisplayLevel = 0;
        int curLight = this.getLightValue();
        if (this.tank.getFluidAmount() > 0) {
            curDisplayLevel = (int)((float)this.tank.getFluidAmount() / (float)TileTank.getCapacity(this.level, this.enchantHolding) * 99.0f);
            if (curDisplayLevel == 0) {
                curDisplayLevel = 1;
            }
            if (this.lastDisplayLevel == 0) {
                this.lastDisplayLevel = curDisplayLevel;
                sendUpdate = true;
            }
        } else if (this.lastDisplayLevel != 0) {
            this.lastDisplayLevel = 0;
            sendUpdate = true;
        }
        if (curDisplayLevel != this.lastDisplayLevel) {
            this.lastDisplayLevel = curDisplayLevel;
            sendUpdate = true;
        }
        if (curLight != this.getLightValue()) {
            this.updateLighting();
            sendUpdate = true;
        }
        if (sendUpdate) {
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74771_c("EncHolding");
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("EncHolding", this.enchantHolding);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte(this.enchantHolding);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.enchantHolding = payload.getByte();
        this.tank.setFluid(payload.getFluidStack());
        this.callBlockUpdate();
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        if (this.tank.getFluid() != null) {
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.getFluidName((FluidStack)this.tank.getFluid())));
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.amount") + ": " + this.tank.getFluidAmount() + "/" + this.tank.getCapacity() + " mB"));
        } else {
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty")));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileTank.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (TileTank.this.isCreative) {
                        if (resource == null || from == EnumFacing.DOWN && !TileTank.this.adjacentTanks[0] && TileTank.this.enableAutoOutput) {
                            return 0;
                        }
                        if (resource.isFluidEqual(TileTank.this.tank.getFluid())) {
                            return 0;
                        }
                        TileTank.this.tank.setFluid(new FluidStack(resource.getFluid(), TileTank.getCapacity(TileTank.this.level, TileTank.this.enchantHolding)));
                        TileTank.this.sendTilePacket(Side.CLIENT);
                        TileTank.this.updateRender();
                        return 0;
                    }
                    if (resource == null || from == EnumFacing.DOWN && !TileTank.this.adjacentTanks[0] && TileTank.this.enableAutoOutput) {
                        return 0;
                    }
                    TileTank.this.renderFlag = true;
                    int amount = TileTank.this.tank.fill(resource, doFill);
                    if (TileTank.this.adjacentTanks[1] && from != EnumFacing.UP && amount != resource.amount) {
                        FluidStack remaining = resource.copy();
                        remaining.amount -= amount;
                        return amount + FluidHelper.insertFluidIntoAdjacentFluidHandler((World)TileTank.this.field_145850_b, (BlockPos)TileTank.this.field_174879_c, (EnumFacing)EnumFacing.UP, (FluidStack)remaining, (boolean)doFill);
                    }
                    return amount;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileTank.this.isCreative) {
                        if (!FluidHelper.isFluidEqual((FluidStack)resource, (FluidStack)TileTank.this.tank.getFluid())) {
                            return null;
                        }
                        return resource.copy();
                    }
                    TileTank.this.renderFlag = true;
                    return TileTank.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileTank.this.isCreative) {
                        if (TileTank.this.tank.getFluid() == null) {
                            return null;
                        }
                        return new FluidStack(TileTank.this.tank.getFluid(), maxDrain);
                    }
                    TileTank.this.renderFlag = true;
                    return TileTank.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

