/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCrucible;
import cofh.thermalexpansion.gui.container.machine.ContainerCrucible;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCrucible
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CRUCIBLE.getMetadata();
    public static int basePower = 50;
    private int inputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(10000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);

    public static void initialize() {
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE] = new TileTEBase.SideConfig();
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].numConfig = 5;
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCrucible.SLOT_CONFIGS[TileCrucible.TYPE] = new TileTEBase.SlotConfig();
        TileCrucible.SLOT_CONFIGS[TileCrucible.TYPE].allowInsertionSlot = new boolean[]{true, false};
        TileCrucible.SLOT_CONFIGS[TileCrucible.TYPE].allowExtractionSlot = new boolean[]{false, false};
        TileCrucible.VALID_AUGMENTS[TileCrucible.TYPE] = new HashSet();
        TileCrucible.LIGHT_VALUES[TileCrucible.TYPE] = 14;
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"thermalexpansion:machine_crucible");
        TileCrucible.config();
    }

    public static void config() {
        String category = "Machine.Crucible";
        BlockMachine.enable[TileCrucible.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileCrucible.ENERGY_CONFIGS[TileCrucible.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileCrucible() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.transferOutputFluid();
        super.func_73660_a();
    }

    @Override
    public int getLightValue() {
        return this.isActive ? this.renderFluid.getFluid().getLuminosity(this.renderFluid) : 0;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        CrucibleManager.CrucibleRecipe recipe = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        FluidStack output = recipe.getOutput();
        return this.tank.fill(output, false) == output.amount;
    }

    @Override
    protected boolean hasValidInput() {
        CrucibleManager.CrucibleRecipe recipe = CrucibleManager.getRecipe(this.inventory[0]);
        return recipe != null && recipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = CrucibleManager.getRecipe(this.inventory[0]).getEnergy() * this.energyMod / 100;
        String prevID = this.renderFluid.getFluid().getName();
        this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput().copy();
        this.renderFluid.amount = 0;
        if (!prevID.equals(this.renderFluid.getFluid().getName())) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        CrucibleManager.CrucibleRecipe recipe = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        this.tank.fill(recipe.getOutput(), true);
        this.inventory[0].func_190918_g(1);
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.enableAutoOutput || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrucible(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrucible(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid().copy();
        } else if (CrucibleManager.getRecipe(this.inventory[0]) != null) {
            this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput().copy();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    protected void handleFluidPacket(PacketCoFHBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || CrucibleManager.recipeExists(stack);
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public SoundEvent getSoundEvent() {
        return TESounds.MACHINE_CRUCIBLE;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCrucible.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && !TileCrucible.this.allowExtraction(((TileCrucible)TileCrucible.this).sideConfig.sideTypes[TileCrucible.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    if (resource == null || !resource.isFluidEqual(TileCrucible.this.tank.getFluid())) {
                        return null;
                    }
                    return TileCrucible.this.tank.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && !TileCrucible.this.allowExtraction(((TileCrucible)TileCrucible.this).sideConfig.sideTypes[TileCrucible.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileCrucible.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

