/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.core.render.ShaderHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportBase;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.RenderPlayerAlt;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerDeadmau5Head;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class RenderPlayerRiding
extends RenderPlayerAlt {
    static EntityTransport transport;

    public RenderPlayerRiding(RenderManager renderManager) {
        super(renderManager);
        ArrayList<LayerRenderer> layersToRemove = new ArrayList<LayerRenderer>();
        for (LayerRenderer layer : this.field_177097_h) {
            if (layer instanceof LayerBipedArmor || layer instanceof LayerDeadmau5Head || layer instanceof LayerCustomHead) continue;
            layersToRemove.add(layer);
        }
        this.field_177097_h.removeAll(layersToRemove);
    }

    protected void func_77043_a(AbstractClientPlayer entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        float pitch;
        if (transport == null) {
            return;
        }
        entityLiving.field_70758_at = 0.0f;
        entityLiving.field_70759_as = 0.0f;
        entityLiving.field_70127_C = -90.0f;
        entityLiving.field_70125_A = -90.0f;
        byte d = RenderPlayerRiding.transport.direction;
        byte od = RenderPlayerRiding.transport.oldDirection;
        float stepTime = ((float)RenderPlayerRiding.transport.progress + (float)(RenderPlayerRiding.transport.pause > 0 ? (byte)0 : RenderPlayerRiding.transport.step) * ShaderHelper.midGameTick) / 100.0f;
        float yaw = 0.0f;
        switch (d) {
            case 0: {
                pitch = 180.0f;
                break;
            }
            case 1: {
                pitch = 0.0f;
                break;
            }
            case 2: {
                yaw = 0.0f;
                pitch = 270.0f;
                break;
            }
            case 3: {
                yaw = 180.0f;
                pitch = 270.0f;
                break;
            }
            case 4: {
                yaw = 90.0f;
                pitch = 270.0f;
                break;
            }
            case 5: {
                yaw = 270.0f;
                pitch = 270.0f;
                break;
            }
            default: {
                return;
            }
        }
        double scale = 0.85;
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        if (d != od && d != (od ^ 1)) {
            float prevPitch;
            float prevYaw = 0.0f;
            switch (od) {
                case 0: {
                    prevPitch = 180.0f;
                    break;
                }
                case 1: {
                    prevPitch = 0.0f;
                    break;
                }
                case 2: {
                    prevYaw = 0.0f;
                    prevPitch = 270.0f;
                    break;
                }
                case 3: {
                    prevYaw = 180.0f;
                    prevPitch = 270.0f;
                    break;
                }
                case 4: {
                    prevYaw = 90.0f;
                    prevPitch = 270.0f;
                    break;
                }
                case 5: {
                    prevYaw = 270.0f;
                    prevPitch = 270.0f;
                    break;
                }
                default: {
                    return;
                }
            }
            if (d < 2) {
                yaw = prevYaw;
            } else if (od < 2) {
                prevYaw = yaw;
            }
            float v = MathHelper.clamp((float)((stepTime - 0.25f) / 0.75f), (float)0.0f, (float)1.0f);
            if (Math.abs(prevYaw - yaw) > Math.abs(prevYaw - yaw - 360.0f)) {
                yaw += 360.0f;
            }
            if (Math.abs(prevYaw - yaw) > Math.abs(prevYaw - yaw + 360.0f)) {
                yaw -= 360.0f;
            }
            yaw = yaw * v + prevYaw * (1.0f - v);
            pitch = pitch * v + prevPitch * (1.0f - v);
        }
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        if (od != d) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
        } else if (stepTime < 0.5f && RenderPlayerRiding.transport.pos != null) {
            TileEntity tile = RenderPlayerRiding.transport.field_70170_p.func_175625_s(RenderPlayerRiding.transport.pos.func_177972_a(EnumFacing.field_82609_l[d].func_176734_d()));
            if (tile instanceof IDuctHolder) {
                DuctUnitTransportBase base = ((IDuctHolder)tile).getDuct(DuctToken.TRANSPORT);
                if (base != null && base.getRenderConnectionType(d ^ 1).renderDuct()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(-0.3f * (1.0f - stepTime * 2.0f)), (float)0.0f);
                }
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)(-0.3f * (1.0f - stepTime * 2.0f)), (float)0.0f);
            }
        }
    }

    protected boolean canRenderName(AbstractClientPlayer entity) {
        return transport != null && (transport.func_184188_bt().isEmpty() || transport.func_184188_bt().get(0) != Minecraft.func_71410_x().field_71439_g);
    }
}

