/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.util.helpers;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.InventoryCraftingFalse;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalfoundation.item.ItemDiagram;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SchematicHelper {
    private SchematicHelper() {
    }

    public static void addInformation(ItemStack stack, List<String> list) {
        if (!stack.func_77942_o()) {
            list.add(StringHelper.getInfoText((String)"info.cofh.blank"));
            return;
        }
        list.add(StringHelper.getDeactivationText((String)"info.thermalfoundation.diagram.erase"));
        boolean hasOre = false;
        THashMap aMap = new THashMap();
        for (int i = 0; i < 9; ++i) {
            String curName;
            if (!stack.func_77978_p().func_74764_b("Name" + i)) continue;
            if (stack.func_77978_p().func_74764_b("Ore" + i)) {
                hasOre = true;
                if (!StringHelper.isShiftKeyDown()) continue;
                curName = stack.func_77978_p().func_74779_i("Ore" + i);
                if (aMap.containsKey((Object)curName)) {
                    aMap.put((Object)curName, (Object)((Integer)aMap.get((Object)curName) + 1));
                    continue;
                }
                aMap.put((Object)curName, (Object)1);
                continue;
            }
            curName = stack.func_77978_p().func_74779_i("Name" + i);
            if (aMap.containsKey((Object)curName)) {
                aMap.put((Object)curName, (Object)((Integer)aMap.get((Object)curName) + 1));
                continue;
            }
            aMap.put((Object)curName, (Object)1);
        }
        for (Map.Entry entry : aMap.entrySet()) {
            list.add("\u00a77" + entry.getValue() + "x " + (String)entry.getKey());
        }
        if (hasOre && StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
    }

    public static String getDisplayName(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Output")) {
            return ": " + stack.func_77978_p().func_74779_i("Output");
        }
        return "";
    }

    public static boolean isSchematic(ItemStack stack) {
        return ItemHelper.itemsEqualWithMetadata((ItemStack)stack, (ItemStack)ItemDiagram.schematic);
    }

    private static void copyInventory(IInventory src, IInventory dest) {
        for (int i = 0; i < src.func_70302_i_() && i < dest.func_70302_i_(); ++i) {
            dest.func_70299_a(i, ItemHelper.cloneStack((ItemStack)src.func_70301_a(i)));
        }
    }

    public static NBTTagCompound getNBTForSchematic(InventoryCrafting craftSlots, World world, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        IRecipe recipe = null;
        InventoryCraftingFalse workingSet = new InventoryCraftingFalse(3, 3);
        SchematicHelper.copyInventory((IInventory)craftSlots, (IInventory)workingSet);
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : recipes) {
            if (!irecipe.func_77569_a((InventoryCrafting)workingSet, world)) continue;
            if (ItemHelper.itemsIdentical((ItemStack)output, (ItemStack)irecipe.func_77572_b((InventoryCrafting)workingSet))) {
                recipe = irecipe;
                break;
            }
            SchematicHelper.copyInventory((IInventory)craftSlots, (IInventory)workingSet);
        }
        if (recipe == null) {
            return SchematicHelper.getNBTForSchematic((IInventory)craftSlots, output);
        }
        for (int i = 0; i < 9 && i < craftSlots.func_70302_i_(); ++i) {
            if (craftSlots.func_70301_a(i).func_190926_b()) {
                nbt.func_82580_o("Slot" + i);
                nbt.func_82580_o("Name" + i);
                nbt.func_82580_o("Ore" + i);
                continue;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            craftSlots.func_70301_a(i).func_77955_b(itemTag);
            nbt.func_74782_a("Slot" + i, (NBTBase)itemTag);
            nbt.func_74778_a("Name" + i, craftSlots.func_70301_a(i).func_82833_r());
            ArrayList oreNames = OreDictionaryArbiter.getAllOreNames((ItemStack)craftSlots.func_70301_a(i));
            if (oreNames == null) continue;
            String validName = "";
            int validSize = 0;
            block2: for (String oreName : oreNames) {
                if (oreName.equals("Unknown")) continue;
                SchematicHelper.copyInventory((IInventory)craftSlots, (IInventory)workingSet);
                int size = 0;
                for (ItemStack stack : OreDictionaryArbiter.getOres((String)oreName)) {
                    NBTTagCompound tag = stack.func_77978_p();
                    int damage = Math.max(0, stack.func_77952_i());
                    if (damage == Short.MAX_VALUE) {
                        damage = 0;
                    }
                    stack = new ItemStack(stack.func_77973_b(), 1, damage);
                    if (tag != null) {
                        stack.func_77982_d(tag.func_74737_b());
                    }
                    workingSet.func_70299_a(i, stack);
                    if (!recipe.func_77569_a((InventoryCrafting)workingSet, world)) continue block2;
                    ++size;
                }
                if (size <= validSize) continue;
                validName = oreName;
                validSize = size;
            }
            if (validSize <= true) continue;
            nbt.func_74778_a("Ore" + i, validName);
        }
        nbt.func_74778_a("Output", output.func_190916_E() + "x " + output.func_82833_r());
        return nbt;
    }

    public static NBTTagCompound getNBTForSchematic(IInventory craftSlots, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < 9 && i < craftSlots.func_70302_i_(); ++i) {
            if (craftSlots.func_70301_a(i).func_190926_b()) {
                nbt.func_82580_o("Slot" + i);
                nbt.func_82580_o("Name" + i);
                nbt.func_82580_o("Ore" + i);
                continue;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            craftSlots.func_70301_a(i).func_77955_b(itemTag);
            nbt.func_74782_a("Slot" + i, (NBTBase)itemTag);
            nbt.func_74778_a("Name" + i, craftSlots.func_70301_a(i).func_82833_r());
            ArrayList oreNames = OreDictionaryArbiter.getAllOreNames((ItemStack)craftSlots.func_70301_a(i));
            if (oreNames == null) continue;
            for (String oreName : oreNames) {
                if (oreName.startsWith("list") || oreName.equals("Unknown") || ItemHelper.isBlacklist((ItemStack)output)) continue;
                nbt.func_74778_a("Ore" + i, oreName);
            }
        }
        nbt.func_74778_a("Output", output.func_190916_E() + "x " + output.func_82833_r());
        return nbt;
    }

    public static ItemStack writeNBTToSchematic(ItemStack stack, NBTTagCompound nbt) {
        ItemStack returnStack = stack.func_77946_l();
        returnStack.func_77982_d(nbt);
        return returnStack;
    }

    public static ItemStack getOutput(ItemStack stack, World world) {
        InventoryCraftingFalse tempCraft = new InventoryCraftingFalse(3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCraft.func_70299_a(i, SchematicHelper.getSchematicSlot(stack, i));
        }
        return ItemHelper.getCraftingResult((InventoryCrafting)tempCraft, (World)world);
    }

    public static ItemStack getSchematicSlot(ItemStack stack, int slot) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Slot" + slot)) {
            return new ItemStack(stack.func_77978_p().func_74775_l("Slot" + slot));
        }
        return ItemStack.field_190927_a;
    }

    public static String getSchematicOreSlot(ItemStack stack, int slot) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Ore" + slot)) {
            return stack.func_77978_p().func_74779_i("Ore" + slot);
        }
        return null;
    }
}

