/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.util;

import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFProps;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class TFCraftingManager {
    public static void loadRecipes() {
        String[] oreNameList;
        for (String oreName : oreNameList = OreDictionary.getOreNames()) {
            if (oreName.length() <= 3 || !oreName.startsWith("ore")) continue;
            String dustName = "dust" + StringHelper.titleCase((String)oreName.substring(3, oreName.length()));
            String ingotName = "ingot" + StringHelper.titleCase((String)oreName.substring(3, oreName.length()));
            NonNullList registeredOre = OreDictionary.getOres((String)oreName, (boolean)false);
            NonNullList registeredDust = OreDictionary.getOres((String)dustName, (boolean)false);
            NonNullList registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
            if (registeredOre.isEmpty()) continue;
            if (TFProps.enablePetrotheumCrafting && !registeredDust.isEmpty()) {
                GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), (Object[])new Object[]{oreName, "dustPetrotheum"}));
                if (!registeredIngot.isEmpty()) {
                    GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)1), (Object[])new Object[]{ingotName, "dustPetrotheum"}));
                }
            }
            if (TFProps.enablePyrotheumCrafting && !registeredIngot.isEmpty()) {
                GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1), (Object[])new Object[]{oreName, "dustPyrotheum"}));
                if (!registeredDust.isEmpty()) {
                    GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1), (Object[])new Object[]{dustName, "dustPyrotheum"}));
                }
            }
            if (!TFProps.enablePetrotheumCrafting || !TFProps.enablePyrotheumCrafting || registeredDust.isEmpty() || registeredIngot.isEmpty()) continue;
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)2), (Object[])new Object[]{oreName, "dustPetrotheum", "dustPyrotheum"}));
        }
    }
}

