/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.BlockOre;
import cofh.thermalfoundation.block.BlockStorage;
import cofh.thermalfoundation.init.TFBlocks;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockFluidMana
extends BlockFluidInteractive {
    public static final int LEVELS = 6;
    public static final Material materialFluidMana = new MaterialLiquid(MapColor.field_151678_z);
    private static boolean effect = true;
    private static boolean enableSourceFall = true;

    public BlockFluidMana(Fluid fluid) {
        super(fluid, materialFluidMana, "thermalfoundation", "mana");
        this.setQuantaPerBlock(6);
        this.setTickRate(10);
        this.func_149711_c(2000.0f);
        this.func_149713_g(2);
        this.setParticleColor(0.2f, 0.0f, 0.4f);
    }

    public static void config() {
        String category = "Fluid.Mana";
        String comment = "If TRUE, Fluid Mana will do...things.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
        comment = "If TRUE, Fluid Mana Source blocks will gradually fall downwards.";
        enableSourceFall = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Fall", category, enableSourceFall, comment);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!effect) {
            return;
        }
        if (world.func_82737_E() % 4L == 0L) {
            if (MathHelper.RANDOM.nextInt(100) != 0) {
                return;
            }
            BlockPos randPos = pos.func_177982_a(8 + world.field_73012_v.nextInt(17), world.field_73012_v.nextInt(8), 8 + world.field_73012_v.nextInt(17));
            if (!world.func_180495_p(randPos).func_185904_a().func_76220_a()) {
                if (entity instanceof EntityLivingBase) {
                    CoreUtils.teleportEntityTo((Entity)entity, (BlockPos)randPos);
                } else {
                    entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return effect ? 15 : 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidMana.getLuminosity();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (effect) {
            this.checkForInteraction(world, pos);
        }
        if (state.func_177230_c().func_176201_c(state) == 0) {
            BlockPos offsetPos = pos.func_177982_a(0, this.densityDir, 0);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            int bMeta = offsetState.func_177230_c().func_176201_c(offsetState);
            if (offsetState.func_177230_c() == this && bMeta != 0) {
                world.func_180501_a(offsetPos, this.func_176223_P(), 3);
                world.func_175698_g(pos);
                return;
            }
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected void checkForInteraction(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.interactWithBlock(world, pos.func_177972_a(facing));
            this.interactWithBlock(world, pos.func_177972_a(facing).func_177982_a(facing.func_82601_c(), 0, facing.func_82599_e()));
        }
        this.interactWithBlock(world, pos.func_177982_a(-1, 0, -1));
        this.interactWithBlock(world, pos.func_177982_a(-1, 0, 1));
        this.interactWithBlock(world, pos.func_177982_a(1, 0, -1));
        this.interactWithBlock(world, pos.func_177982_a(1, 0, 1));
    }

    protected void interactWithBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block == this) {
            return;
        }
        int bMeta = block.func_176201_c(state);
        if (this.hasInteraction(state)) {
            IBlockState result = this.getInteraction(state);
            world.func_180501_a(pos, result, 3);
            this.triggerInteractionEffects(world, pos);
        } else if (world.isSideSolid(pos, EnumFacing.UP) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
            if (MathHelper.RANDOM.nextInt(2) == 0) {
                world.func_180501_a(pos.func_177972_a(EnumFacing.UP), Blocks.field_150431_aC.func_176223_P(), 3);
            } else {
                world.func_180501_a(pos.func_177972_a(EnumFacing.UP), Blocks.field_150480_ab.func_176223_P(), 3);
            }
        }
    }

    protected void triggerInteractionEffects(World world, BlockPos pos) {
        if (MathHelper.RANDOM.nextInt(10) == 0) {
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        for (int i = 0; i < 8; ++i) {
            world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + Math.random() * 1.1, (double)pos.func_177956_o() + 1.3, (double)pos.func_177952_p() + Math.random() * 1.1, 0.0, -0.5, 0.0, new int[0]);
        }
    }

    public boolean preInit() {
        this.setRegistryName("fluid_mana");
        GameRegistry.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        BlockFluidMana.config();
        return true;
    }

    public boolean initialize() {
        this.addInteraction(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT), Blocks.field_150349_c.func_176223_P(), false);
        this.addInteraction(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), false);
        this.addInteraction(Blocks.field_150359_w, (Block)Blocks.field_150354_m);
        this.addInteraction(Blocks.field_150450_ax.func_176223_P(), Blocks.field_150439_ay.func_176223_P(), true);
        this.addInteraction(Blocks.field_150369_x.func_176223_P(), Blocks.field_150368_y.func_176223_P(), true);
        this.addInteraction(Blocks.field_150458_ak.func_176223_P(), Blocks.field_150391_bh.func_176223_P(), true);
        int i = 8;
        while (i-- > 0) {
            this.addInteraction(Blocks.field_150334_T.func_176203_a(i), Blocks.field_150334_T.func_176203_a(i + 8), false);
        }
        this.addInteraction(TFBlocks.blockOre.func_176223_P().func_177226_a(BlockOre.VARIANT, (Comparable)((Object)BlockOre.Type.SILVER)), TFBlocks.blockOre.func_176223_P().func_177226_a(BlockOre.VARIANT, (Comparable)((Object)BlockOre.Type.MITHRIL)));
        this.addInteraction(TFBlocks.blockOre.func_176223_P().func_177226_a(BlockOre.VARIANT, (Comparable)((Object)BlockOre.Type.LEAD)), Blocks.field_150352_o.func_176223_P());
        this.addInteraction(TFBlocks.blockStorage.func_176223_P().func_177226_a(BlockStorage.VARIANT, (Comparable)((Object)BlockStorage.Type.SILVER)), TFBlocks.blockStorage.func_176223_P().func_177226_a(BlockStorage.VARIANT, (Comparable)((Object)BlockStorage.Type.MITHRIL)));
        this.addInteraction(TFBlocks.blockStorage.func_176223_P().func_177226_a(BlockStorage.VARIANT, (Comparable)((Object)BlockStorage.Type.LEAD)), Blocks.field_150340_R.func_176223_P());
        return true;
    }
}

