/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.entity.monster;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.entity.monster.EntityElemental;
import cofh.thermalfoundation.entity.projectile.EntityBasalzBolt;
import cofh.thermalfoundation.init.TFSounds;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityBasalz
extends EntityElemental {
    static boolean enable = true;
    static boolean restrictLightLevel = true;
    static int spawnLightLevel = 8;
    static int spawnWeight = 10;
    static int spawnMin = 1;
    static int spawnMax = 4;
    public static boolean effect = true;

    public static void initialize(int id) {
        EntityBasalz.config();
        if (!enable) {
            return;
        }
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thermalfoundation:basalz"), EntityBasalz.class, (String)"thermalfoundation.basalz", (int)id, (Object)ThermalFoundation.instance, (int)64, (int)1, (boolean)true, (int)0x606060, (int)0xB3ABA3);
        HashSet validBiomes = new HashSet();
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
        validBiomes.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
        EntityRegistry.addSpawn(EntityBasalz.class, (int)spawnWeight, (int)spawnMin, (int)spawnMax, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])validBiomes.toArray(new Biome[validBiomes.size()]));
    }

    public static void config() {
        String category = "Mob.Basalz";
        String comment = "If TRUE, Basalzes will spawn naturally.";
        enable = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Enable", category, enable, comment);
        comment = "If TRUE, Basalzes will only spawn below a specified light level.";
        restrictLightLevel = ThermalFoundation.CONFIG.getConfiguration().getBoolean("LightLevelRestriction", category, restrictLightLevel, comment);
        comment = "This sets the maximum light level Basalzes can spawn at, if restricted.";
        spawnLightLevel = ThermalFoundation.CONFIG.getConfiguration().getInt("LightLevel", category, spawnLightLevel, 0, 15, comment);
        comment = "This sets the minimum number of Basalzes that spawn in a group.";
        spawnMin = ThermalFoundation.CONFIG.getConfiguration().getInt("MinGroupSize", category, spawnMin, 1, 10, comment);
        comment = "This sets the maximum number of Basalzes that spawn in a group.";
        spawnMax = ThermalFoundation.CONFIG.getConfiguration().getInt("MaxGroupSize", category, spawnMax, spawnMin, 24, comment);
        comment = "This sets the relative spawn weight for Basalzes.";
        spawnWeight = ThermalFoundation.CONFIG.getConfiguration().getInt("SpawnWeight", category, spawnWeight, 1, 20, comment);
        comment = "If TRUE, Basalz attacks will inflict Weakness.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
    }

    public EntityBasalz(World world) {
        super(world);
        this.ambientParticle = EnumParticleTypes.TOWN_AURA;
        this.ambientSound = TFSounds.BASALZ_AMBIENT;
    }

    protected void func_70628_a(boolean wasHitByPlayer, int looting) {
        if (wasHitByPlayer) {
            int i;
            int items = this.field_70146_Z.nextInt(2 + looting);
            for (i = 0; i < items; ++i) {
                this.func_70099_a(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian, (int)1), 0.0f);
            }
            items = this.field_70146_Z.nextInt(2 + looting);
            for (i = 0; i < items; ++i) {
                this.func_70099_a(ItemHelper.cloneStack((ItemStack)ItemMaterial.rodBasalz, (int)1), 0.0f);
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIBasalzBoltAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected boolean restrictLightLevel() {
        return restrictLightLevel;
    }

    @Override
    protected int getSpawnLightLevel() {
        return spawnLightLevel;
    }

    static class AIBasalzBoltAttack
    extends EntityAIBase {
        private final EntityBasalz basalz;
        private int attackStep;
        private int attackTime;

        public AIBasalzBoltAttack(EntityBasalz entity) {
            this.basalz = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.basalz.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.basalz.setInAttackMode(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase target = this.basalz.func_70638_az();
            double d0 = this.basalz.func_70068_e((Entity)target);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.basalz.func_70652_k((Entity)target);
                }
                this.basalz.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            } else if (d0 < 256.0) {
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                        this.basalz.setInAttackMode(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                        this.basalz.setInAttackMode(false);
                    }
                    if (this.attackStep > 1) {
                        this.basalz.field_70170_p.func_180498_a(null, 1009, new BlockPos((int)this.basalz.field_70165_t, (int)this.basalz.field_70163_u, (int)this.basalz.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntityBasalzBolt bolt = new EntityBasalzBolt(this.basalz.field_70170_p, (EntityLivingBase)this.basalz);
                            bolt.func_70186_c(target.field_70165_t - this.basalz.field_70165_t, target.field_70163_u - this.basalz.field_70163_u, target.field_70161_v - this.basalz.field_70161_v, 1.5f, 1.0f);
                            bolt.field_70163_u = this.basalz.field_70163_u + (double)(this.basalz.field_70131_O / 2.0f) + 0.5;
                            this.basalz.func_184185_a(TFSounds.BASALZ_ATTACK, 2.0f, (this.basalz.field_70146_Z.nextFloat() - this.basalz.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                            this.basalz.field_70170_p.func_72838_d((Entity)bolt);
                        }
                    }
                }
                this.basalz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
            } else {
                this.basalz.func_70661_as().func_75499_g();
                this.basalz.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }
    }
}

