/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.ItemBlockStorage;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStorage
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static ItemStack blockCopper;
    public static ItemStack blockTin;
    public static ItemStack blockSilver;
    public static ItemStack blockLead;
    public static ItemStack blockAluminum;
    public static ItemStack blockNickel;
    public static ItemStack blockPlatinum;
    public static ItemStack blockIridium;
    public static ItemStack blockMithril;

    public BlockStorage() {
        super(Material.field_151573_f, "thermalfoundation");
        this.func_149663_c("storage");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.COPPER)));
        this.setHarvestLevel("pickaxe", 2);
        this.setHarvestLevel("pickaxe", 1, this.func_176203_a(Type.COPPER.getMetadata()));
        this.setHarvestLevel("pickaxe", 1, this.func_176203_a(Type.TIN.getMetadata()));
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(Type.PLATINUM.getMetadata()));
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(Type.IRIDIUM.getMetadata()));
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(Type.MITHRIL.getMetadata()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Type.byMetadata(state.func_177230_c().func_176201_c(state)).light;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return Type.byMetadata(state.func_177230_c().func_176201_c(state)).hardness;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return Type.byMetadata(state.func_177230_c().func_176201_c(state)).resistance;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    public boolean preInit() {
        this.setRegistryName("storage");
        GameRegistry.register((IForgeRegistryEntry)this);
        ItemBlockStorage itemBlock = new ItemBlockStorage((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        blockCopper = new ItemStack((Block)this, 1, Type.COPPER.getMetadata());
        blockTin = new ItemStack((Block)this, 1, Type.TIN.getMetadata());
        blockSilver = new ItemStack((Block)this, 1, Type.SILVER.getMetadata());
        blockLead = new ItemStack((Block)this, 1, Type.LEAD.getMetadata());
        blockAluminum = new ItemStack((Block)this, 1, Type.ALUMINUM.getMetadata());
        blockNickel = new ItemStack((Block)this, 1, Type.NICKEL.getMetadata());
        blockPlatinum = new ItemStack((Block)this, 1, Type.PLATINUM.getMetadata());
        blockIridium = new ItemStack((Block)this, 1, Type.IRIDIUM.getMetadata());
        blockMithril = new ItemStack((Block)this, 1, Type.MITHRIL.getMetadata());
        ItemHelper.registerWithHandlers((String)"blockCopper", (ItemStack)blockCopper);
        ItemHelper.registerWithHandlers((String)"blockTin", (ItemStack)blockTin);
        ItemHelper.registerWithHandlers((String)"blockSilver", (ItemStack)blockSilver);
        ItemHelper.registerWithHandlers((String)"blockLead", (ItemStack)blockLead);
        ItemHelper.registerWithHandlers((String)"blockAluminum", (ItemStack)blockAluminum);
        ItemHelper.registerWithHandlers((String)"blockNickel", (ItemStack)blockNickel);
        ItemHelper.registerWithHandlers((String)"blockPlatinum", (ItemStack)blockPlatinum);
        ItemHelper.registerWithHandlers((String)"blockIridium", (ItemStack)blockIridium);
        ItemHelper.registerWithHandlers((String)"blockMithril", (ItemStack)blockMithril);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        ItemHelper.addStorageRecipe((ItemStack)blockCopper, (String)"ingotCopper");
        ItemHelper.addStorageRecipe((ItemStack)blockTin, (String)"ingotTin");
        ItemHelper.addStorageRecipe((ItemStack)blockSilver, (String)"ingotSilver");
        ItemHelper.addStorageRecipe((ItemStack)blockLead, (String)"ingotLead");
        ItemHelper.addStorageRecipe((ItemStack)blockAluminum, (String)"ingotAluminum");
        ItemHelper.addStorageRecipe((ItemStack)blockNickel, (String)"ingotNickel");
        ItemHelper.addStorageRecipe((ItemStack)blockPlatinum, (String)"ingotPlatinum");
        ItemHelper.addStorageRecipe((ItemStack)blockIridium, (String)"ingotIridium");
        ItemHelper.addStorageRecipe((ItemStack)blockMithril, (String)"ingotMithril");
        return true;
    }

    public boolean postInit() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        COPPER(0, "copper"),
        TIN(1, "tin"),
        SILVER(2, "silver", 4),
        LEAD(3, "lead", 4.0f, 12.0f),
        ALUMINUM(4, "aluminum", 4.0f, 6.0f),
        NICKEL(5, "nickel", 10.0f, 6.0f),
        PLATINUM(6, "platinum", 4, 5.0f, 10.0f, EnumRarity.UNCOMMON),
        IRIDIUM(7, "iridium", 4, 10.0f, 15.0f, EnumRarity.UNCOMMON),
        MITHRIL(8, "mithril", 8, 30.0f, 120.0f, EnumRarity.RARE);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;
        private final float hardness;
        private final float resistance;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, float hardness, float resistance, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.hardness = hardness;
            this.resistance = resistance;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, int light, float hardness, float resistance) {
            this(metadata, name, light, hardness, resistance, EnumRarity.COMMON);
        }

        private Type(int metadata, String name, float hardness, float resistance) {
            this(metadata, name, 0, hardness, resistance, EnumRarity.COMMON);
        }

        private Type(int metadata, String name, int light) {
            this(metadata, name, light, 5.0f, 6.0f, EnumRarity.COMMON);
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0, 5.0f, 6.0f, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

