/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementButton;
import cofh.thermaldynamics.gui.client.DirectoryEntry;
import cofh.thermaldynamics.gui.client.GuiTransport;
import java.util.List;

public class ElementDirectoryButton
extends ElementButton {
    final int index;
    final GuiTransport gui;
    DirectoryEntry entry;

    public ElementDirectoryButton(int index, GuiTransport gui, int posX, int posY, int sizeX, int sizeY, int sheetX, int sheetY, int hoverX, int hoverY, String texture) {
        super((GuiBase)gui, posX, posY, sizeX, sizeY, sheetX, sheetY, hoverX, hoverY, texture);
        this.index = index;
        this.gui = gui;
    }

    public ElementDirectoryButton(int i, GuiTransport gui, int x0, int y0) {
        this(i, gui, x0, y0 + i * 23, 155, 22, 0, 204, 0, 226, "thermaldynamics:textures/gui/transport.png");
    }

    public void setEntry(DirectoryEntry entry) {
        this.entry = entry;
    }

    public boolean isVisible() {
        return super.isVisible() && this.entry != null;
    }

    public void onClick() {
        if (this.entry != null) {
            this.gui.goToDest(this.entry);
        }
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        super.drawBackground(mouseX, mouseY, gameTicks);
    }

    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (this.entry == null) {
            return;
        }
        String text = this.getFontRenderer().func_78269_a(this.entry.getName(), this.sizeX - this.sizeY - 4);
        this.getFontRenderer().func_175063_a(text, (float)(this.posX + this.sizeY + 4), (float)(this.posY + (this.sizeY - 8) / 2), this.getTextColor(mouseX, mouseY));
        if (!this.entry.icon.func_190926_b()) {
            this.gui.drawItemStack(this.entry.icon, this.posX + 3, this.posY + 3, false, null);
        }
    }

    protected int getTextColor(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            return -6250336;
        }
        if (this.intersectsWith(mouseX, mouseY)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public void setPosX(int x0) {
        this.posX = x0;
    }

    public void addTooltip(List<String> list) {
        list.add(this.entry.getName());
        list.add(String.format("x: %d", this.entry.x));
        list.add(String.format("y: %d", this.entry.y));
        list.add(String.format("z: %d", this.entry.z));
    }
}

