/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.world.IFeatureGenerator;
import cofh.lib.world.biome.BiomeInfo;
import cofh.lib.world.biome.BiomeInfoSet;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class FeatureBase
implements IFeatureGenerator {
    public final String name;
    public final GenRestriction biomeRestriction;
    public final GenRestriction dimensionRestriction;
    public final boolean regen;
    public boolean withVillage = true;
    protected int rarity;
    protected final BiomeInfoSet biomes = new BiomeInfoSet(1);
    protected final Set<Integer> dimensions = new THashSet();

    public FeatureBase(String name, boolean regen) {
        this(name, GenRestriction.NONE, regen, GenRestriction.NONE);
    }

    public FeatureBase(String name, boolean regen, GenRestriction dimRes) {
        this(name, GenRestriction.NONE, regen, dimRes);
    }

    public FeatureBase(String name, GenRestriction biomeRes, boolean regen) {
        this(name, biomeRes, regen, GenRestriction.NONE);
    }

    public FeatureBase(String name, GenRestriction biomeRes, boolean regen, GenRestriction dimRes) {
        this.name = name;
        this.biomeRestriction = biomeRes;
        this.dimensionRestriction = dimRes;
        this.regen = regen;
    }

    public void setRarity(int rarity) {
        this.rarity = rarity;
    }

    public FeatureBase addBiome(BiomeInfo biome) {
        this.biomes.add(biome);
        return this;
    }

    public FeatureBase addBiomes(BiomeInfoSet biomes) {
        this.biomes.addAll(biomes);
        return this;
    }

    public FeatureBase addDimension(int dimID) {
        this.dimensions.add(dimID);
        return this;
    }

    @Override
    public final String getFeatureName() {
        return this.name;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world, boolean hasVillage, boolean newGen) {
        if (!newGen && !this.regen) {
            return false;
        }
        if (hasVillage && !this.withVillage) {
            return false;
        }
        if (this.dimensionRestriction != GenRestriction.NONE && this.dimensionRestriction == GenRestriction.BLACKLIST == this.dimensions.contains(world.field_73011_w.getDimension())) {
            return false;
        }
        if (this.rarity > 1 && random.nextInt(this.rarity) != 0) {
            return false;
        }
        return this.generateFeature(random, chunkX * 16 + 8, chunkZ * 16 + 8, world);
    }

    protected abstract boolean generateFeature(Random var1, int var2, int var3, World var4);

    protected boolean canGenerateInBiome(World world, int x, int z, Random rand) {
        if (this.biomeRestriction != GenRestriction.NONE) {
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            return this.biomeRestriction == GenRestriction.BLACKLIST != this.biomes.contains(biome, rand);
        }
        return true;
    }

    public static enum GenRestriction {
        NONE,
        BLACKLIST,
        WHITELIST;


        public static GenRestriction get(String restriction) {
            if (restriction.equalsIgnoreCase("blacklist")) {
                return BLACKLIST;
            }
            if (restriction.equalsIgnoreCase("whitelist")) {
                return WHITELIST;
            }
            return NONE;
        }
    }
}

