/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import java.util.Set;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    Configuration modConfiguration;
    String modVersion;

    public ConfigHandler(String version) {
        this.modVersion = version;
    }

    public ConfigHandler setConfiguration(Configuration config) {
        this.modConfiguration = config;
        this.modConfiguration.load();
        return this;
    }

    public Configuration getConfiguration() {
        return this.modConfiguration;
    }

    public String getVersion() {
        return this.modVersion;
    }

    public String getConfigVersion() {
        return this.get("Version", "Identifier", this.modVersion);
    }

    public boolean isOldConfig() {
        return !this.getConfigVersion().equals(this.modVersion);
    }

    public void save() {
        this.modConfiguration.save();
    }

    public double get(String category, String key, double defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue, null).getDouble(0.0);
    }

    public double get(String category, String key, double defaultValue, String comment) {
        return this.modConfiguration.get(category, key, defaultValue, comment).getDouble(0.0);
    }

    public int get(String category, String key, int defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue, null).getInt();
    }

    public int get(String category, String key, int defaultValue, String comment) {
        return this.modConfiguration.get(category, key, defaultValue, comment).getInt();
    }

    public boolean get(String category, String key, boolean defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue, null).getBoolean(defaultValue);
    }

    public boolean get(String category, String key, boolean defaultValue, String comment) {
        return this.modConfiguration.get(category, key, defaultValue, comment).getBoolean(defaultValue);
    }

    public String get(String category, String key, String defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue, null).getString();
    }

    public String get(String category, String key, String defaultValue, String comment) {
        return this.modConfiguration.get(category, key, defaultValue, comment).getString();
    }

    public void set(String category, String key, double value) {
        this.getProperty(category, key, value).set(value);
    }

    public void set(String category, String key, int value) {
        this.getProperty(category, key, value).set(value);
    }

    public void set(String category, String key, boolean value) {
        this.getProperty(category, key, value).set(value);
    }

    public void set(String category, String key, String value) {
        this.getProperty(category, key, value).set(value);
    }

    public Property getProperty(String category, String key, double defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public Property getProperty(String category, String key, int defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public Property getProperty(String category, String key, boolean defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public Property getProperty(String category, String key, String defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public ConfigCategory getCategory(String category) {
        return this.modConfiguration.getCategory(category);
    }

    public Set<String> getCategoryNames() {
        return this.modConfiguration.getCategoryNames();
    }

    public Set<String> getCategoryKeys(String category) {
        return this.modConfiguration.getCategory(category).getValues().keySet();
    }

    public boolean hasCategory(String category) {
        return this.modConfiguration.hasCategory(category);
    }

    public boolean hasKey(String category, String key) {
        return this.modConfiguration.hasKey(category, key);
    }

    public boolean copyProperty(String category, String key, String newCategory, String newKey, boolean forceValue) {
        if (this.modConfiguration.hasKey(category, key)) {
            Property prop = this.modConfiguration.getCategory(category).get(key);
            if (prop.isIntValue()) {
                int value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getInt();
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else if (prop.isBooleanValue()) {
                boolean value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getBoolean(false);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else if (prop.isDoubleValue()) {
                double value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getDouble(0.0);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else {
                String value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getString();
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            }
            return true;
        }
        return false;
    }

    public boolean renameProperty(String category, String key, String newCategory, String newKey, boolean forceValue) {
        if (this.modConfiguration.hasKey(category, key)) {
            Property prop = this.modConfiguration.getCategory(category).get(key);
            if (prop.isIntValue()) {
                int value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getInt();
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else if (prop.isBooleanValue()) {
                boolean value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getBoolean(false);
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else if (prop.isDoubleValue()) {
                double value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getDouble(0.0);
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else {
                String value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getString();
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            }
            return true;
        }
        return false;
    }

    public boolean removeProperty(String category, String key) {
        if (!this.modConfiguration.hasKey(category, key)) {
            return false;
        }
        this.modConfiguration.getCategory(category).remove((Object)key);
        return true;
    }

    public boolean renameCategory(String category, String newCategory) {
        if (!this.modConfiguration.hasCategory(category)) {
            return false;
        }
        this.modConfiguration.getCategory(category);
        for (Property prop : this.modConfiguration.getCategory(category).values()) {
            this.copyProperty(category, prop.getName(), newCategory, prop.getName(), true);
        }
        this.removeCategory(category);
        return true;
    }

    public boolean removeCategory(String category) {
        if (!this.modConfiguration.hasCategory(category)) {
            return false;
        }
        this.modConfiguration.removeCategory(this.modConfiguration.getCategory(category));
        return true;
    }

    public void cleanUp(boolean delConfig, boolean saveVersion) {
        this.removeProperty("Version", "Identifier");
        if (saveVersion) {
            this.getConfigVersion();
        }
        this.modConfiguration.save();
        if (delConfig) {
            this.modConfiguration = null;
        }
    }
}

