/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network;

import cofh.CoFHCore;
import cofh.core.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, PacketBase> {
    public static final PacketHandler instance = new PacketHandler();
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private final LinkedList<Class<? extends PacketBase>> packets = new LinkedList();
    private boolean isPostInitialised = false;

    public static void preInit() {
        PacketHandler.instance.channels = NetworkRegistry.INSTANCE.newChannel("CoFH", new ChannelHandler[]{instance});
    }

    public static void postInit() {
        if (PacketHandler.instance.isPostInitialised) {
            return;
        }
        PacketHandler.instance.isPostInitialised = true;
        PacketHandler.instance.packets.sort((packetClass1, packetClass2) -> {
            int com = String.CASE_INSENSITIVE_ORDER.compare(packetClass1.getCanonicalName(), packetClass2.getCanonicalName());
            if (com == 0) {
                com = packetClass1.getCanonicalName().compareTo(packetClass2.getCanonicalName());
            }
            return com;
        });
    }

    protected void encode(ChannelHandlerContext ctx, PacketBase msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> packetClass = msg.getClass();
        if (!this.packets.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(packetClass);
        buffer.writeByte((int)discriminator);
        msg.encodeInto(ctx, buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(new PacketBuffer(buffer.copy()), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class<? extends PacketBase> packetClass = this.packets.get(discriminator);
        if (packetClass == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        PacketBase pkt = packetClass.newInstance();
        pkt.decodeInto(ctx, payload.slice());
        switch ((Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get()) {
            case CLIENT: {
                EntityPlayer player = CoFHCore.proxy.getClientPlayer();
                this.handlePacketClient(pkt, player);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                this.handlePacketServer(pkt, (EntityPlayer)player);
                break;
            }
        }
    }

    private void handlePacketClient(PacketBase packet, EntityPlayer player) {
        IThreadListener threadListener = CoFHCore.proxy.getClientListener();
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> this.handlePacketClient(packet, player));
        } else {
            packet.handleClientSide(player);
        }
    }

    private void handlePacketServer(PacketBase packet, EntityPlayer player) {
        IThreadListener threadListener = CoFHCore.proxy.getServerListener();
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> this.handlePacketServer(packet, player));
        } else {
            packet.handleServerSide(player);
        }
    }

    private void injectPacket(byte[] data) throws Exception {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            throw new RuntimeException("Packet hack only works for the client end.");
        }
        ByteBuf buf = Unpooled.copiedBuffer((byte[])data);
        byte discriminator = buf.readByte();
        Class<? extends PacketBase> packetClass = this.packets.get(discriminator);
        if (packetClass == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        PacketBase pkt = packetClass.newInstance();
        pkt.decodeInto(null, buf.slice());
        this.handlePacketClient(pkt, CoFHCore.proxy.getClientPlayer());
    }

    public boolean registerPacket(Class<? extends PacketBase> packet) {
        if (this.packets.size() > 256) {
            return false;
        }
        if (this.packets.contains(packet)) {
            return false;
        }
        if (this.isPostInitialised) {
            return false;
        }
        this.packets.add(packet);
        return true;
    }

    public static void handleNBTPacket(NBTTagCompound tagCompound) {
        try {
            instance.injectPacket(tagCompound.func_74770_j("CoFH:data"));
        }
        catch (Exception e) {
            FMLLog.severe((String)"Unable to handle CoFH packet!", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void sendToAll(PacketBase message) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendTo(PacketBase message, EntityPlayerMP player) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendTo(PacketBase message, EntityPlayer player) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToAllAround(PacketBase message, NetworkRegistry.TargetPoint point) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToAllAround(PacketBase message, TileEntity theTile) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(theTile.func_145831_w().field_73011_w.getDimension(), (double)theTile.func_174877_v().func_177958_n(), (double)theTile.func_174877_v().func_177956_o(), (double)theTile.func_174877_v().func_177952_p(), 192.0));
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToAllAround(PacketBase message, World world, int x, int y, int z) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)x, (double)y, (double)z, 192.0));
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToDimension(PacketBase message, int dimensionId) {
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        PacketHandler.instance.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        PacketHandler.instance.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public static void sendToServer(PacketBase message) {
        PacketHandler.instance.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketHandler.instance.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }

    public static Packet toMCPacket(PacketBase packet) {
        return PacketHandler.instance.channels.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    public static NBTTagCompound toNBTTag(PacketBase packetBase, NBTTagCompound inputTag) {
        ByteBuf buf = Unpooled.buffer();
        byte discriminator = (byte)PacketHandler.instance.packets.indexOf(packetBase.getClass());
        buf.writeByte((int)discriminator);
        packetBase.encodeInto(null, buf);
        inputTag.func_74773_a("CoFH:data", buf.array());
        return inputTag;
    }

    public static SPacketUpdateTileEntity toTilePacket(PacketBase packet, BlockPos pos) {
        return new SPacketUpdateTileEntity(pos, 0, PacketHandler.toNBTTag(packet, new NBTTagCompound()));
    }
}

