/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import cofh.CoFHCore;
import cofh.core.enchantment.EnchantmentHolding;
import cofh.core.enchantment.EnchantmentMultishot;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

public class CoreProps {
    private static final String BUILD = "2388";
    private static final String FORGE_REQ = "13.20.0.2388";
    private static final String FORGE_REQ_MAX = "13.21.0.0";
    public static final String FORGE_DEP = "required-after:forge@[13.20.0.2388,13.21.0.0);";
    public static File configDir;
    public static MinecraftServer server;
    public static final GameProfile DEFAULT_OWNER;
    public static final int TIME_CONSTANT = 32;
    public static final int TIME_CONSTANT_HALF = 16;
    public static final int TIME_CONSTANT_QUARTER = 8;
    public static final int TIME_CONSTANT_EIGHTH = 4;
    public static final int RF_PER_MJ = 10;
    public static final int LAVA_RF = 200000;
    public static final int ENTITY_TRACKING_DISTANCE = 64;
    public static final int[] EMPTY_INVENTORY;
    public static final int[] SINGLE_INVENTORY;
    public static final List<ItemStack> EMPTY_DROPS;
    public static final int[] STORAGE_SIZE;
    public static final int[][] SLOTS;
    public static final String PATH_GFX = "cofh:textures/";
    public static final String PATH_GUI = "cofh:textures/gui/";
    public static final String PATH_GUI_STORAGE = "cofh:textures/gui/storage/";
    public static final ResourceLocation[] TEXTURE_STORAGE;
    public static final int NETWORK_UPDATE_RANGE = 192;
    public static boolean disableParticles;
    public static boolean enableDismantleLogging;
    public static boolean enableItemStacking;
    public static boolean enableLivingEntityDeathMessages;
    public static boolean enableColorBlindTextures;
    public static boolean enableGUISlotBorders;
    public static boolean enableShaderEffects;
    public static boolean holidayAprilFools;
    public static boolean holidayChristmas;
    public static boolean enableHorseArmorCrafting;
    public static boolean enableSaddleCrafting;
    public static boolean enableOpSecureAccess;
    public static boolean enableOpSecureAccessWarning;
    public static int treeGrowthChance;

    private CoreProps() {
    }

    public static void preInit() {
        CoreProps.configCommon();
        CoreProps.configClient();
    }

    public static void loadComplete() {
    }

    private static void configCommon() {
        String category = "General";
        String comment = "If TRUE, a log message is generated when a block is dismantled.";
        enableDismantleLogging = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("EnableDismantleLogging", category, enableDismantleLogging, comment);
        comment = "If TRUE, death messages are displayed for any named entity.";
        enableLivingEntityDeathMessages = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("EnableGenericDeathMessage", category, enableLivingEntityDeathMessages, comment);
        category = "Enchantment";
        comment = "If TRUE, the Holding Enchantment is available for various Storage Items.";
        EnchantmentHolding.enable = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("EnableHoldingEnchant", category, EnchantmentHolding.enable, comment);
        comment = "If TRUE, the Multishot Enchantment is available for various Bows.";
        EnchantmentMultishot.enable = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("EnableMultishotEnchant", category, EnchantmentMultishot.enable, comment);
        category = "Holidays";
        comment = "If TRUE, April Foolishness is disabled. Boring! :P";
        holidayAprilFools = !CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("IHateApril", category, !holidayAprilFools, comment);
        comment = "If TRUE, Christmas cheer is disabled. Scrooge. :(";
        holidayChristmas = !CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("HoHoNo", category, !holidayChristmas, comment);
        category = "Items";
        comment = "If TRUE, Horse Armor will be craftable.";
        enableHorseArmorCrafting = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("EnableHorseArmorCrafting", category, enableHorseArmorCrafting, comment);
        comment = "If TRUE, Saddles will be craftable.";
        enableSaddleCrafting = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("EnableSaddleCrafting", category, enableSaddleCrafting, comment);
        category = "Security";
        comment = "If TRUE, Server Ops can access \"secure\" blocks. Your players will be warned upon server connection.";
        enableOpSecureAccess = CoFHCore.CONFIG_CORE.getConfiguration().getBoolean("OpsCanAccessSecureBlocks", category, enableOpSecureAccess, comment);
        category = "World";
        comment = "This adjusts the % chance that a tree will grow as normal when it is meant to. Reducing this value will mean that trees take longer to grow, on average.";
        treeGrowthChance = CoFHCore.CONFIG_CORE.getConfiguration().getInt("TreeGrowthChance", category, treeGrowthChance, 1, 100, comment);
    }

    private static void configClient() {
        String category = "Global";
        CoFHCore.CONFIG_CLIENT.getCategory(category).setComment("The options in this section change core Minecraft behavior and are not limited to CoFH mods.");
        String comment = "If TRUE, particles will be disabled.";
        disableParticles = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("DisableParticles", category, disableParticles, comment);
        category = "Render";
        comment = "If TRUE, Color Blind Textures will be enabled in CoFH Mods, where applicable.";
        enableColorBlindTextures = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("EnableColorBlindTextures", category, enableColorBlindTextures, comment);
        comment = "If TRUE, borders will be drawn on GUI slots in CoFH Mods, where applicable.";
        enableGUISlotBorders = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("EnableGUISlotBorders", category, enableGUISlotBorders, comment);
        comment = "If TRUE, Shader Effects will be enabled in CoFH Mods, where applicable.";
        enableShaderEffects = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("EnableShaderEffects", category, enableShaderEffects, comment);
        category = "Interface";
        comment = "If TRUE, a tooltip will be used which prompts to press Shift for more details on various items.";
        StringHelper.displayShiftForDetail = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("DisplayHoldShiftForDetail", category, StringHelper.displayShiftForDetail, comment);
        comment = "If TRUE, large item counts will be displayed as stacks rather than a single quantity.";
        StringHelper.displayStackCount = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("DisplayContainedItemsAsStackCount", category, StringHelper.displayStackCount, comment);
        category = "Security";
        comment = "If TRUE, a warning will display if Ops have access to \"secure\" blocks upon logging on to a server.";
        enableOpSecureAccessWarning = CoFHCore.CONFIG_CLIENT.getConfiguration().getBoolean("OpsCanAccessSecureBlocksWarning", category, enableOpSecureAccessWarning, comment);
    }

    private static void configLoot() {
    }

    static {
        int i;
        DEFAULT_OWNER = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
        EMPTY_INVENTORY = new int[0];
        SINGLE_INVENTORY = new int[]{0};
        EMPTY_DROPS = new ArrayList<ItemStack>();
        STORAGE_SIZE = new int[]{1, 9, 18, 27, 36, 45, 54, 63, 72, 81, 90, 99, 108, 117, 126};
        SLOTS = new int[STORAGE_SIZE.length][];
        for (i = 0; i < STORAGE_SIZE.length; ++i) {
            CoreProps.SLOTS[i] = new int[STORAGE_SIZE[i]];
            for (int j = 0; j < STORAGE_SIZE[i]; ++j) {
                CoreProps.SLOTS[i][j] = j;
            }
        }
        TEXTURE_STORAGE = new ResourceLocation[STORAGE_SIZE.length];
        for (i = 0; i < STORAGE_SIZE.length; ++i) {
            CoreProps.TEXTURE_STORAGE[i] = new ResourceLocation("cofh:textures/gui/storage/storage_" + STORAGE_SIZE[i] + ".png");
        }
        disableParticles = false;
        enableDismantleLogging = false;
        enableItemStacking = true;
        enableLivingEntityDeathMessages = true;
        enableColorBlindTextures = false;
        enableGUISlotBorders = true;
        enableShaderEffects = true;
        holidayAprilFools = true;
        holidayChristmas = true;
        enableHorseArmorCrafting = true;
        enableSaddleCrafting = true;
        enableOpSecureAccess = false;
        enableOpSecureAccessWarning = true;
        treeGrowthChance = 100;
    }
}

