/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui;

import cofh.core.init.CoreTextures;
import cofh.lib.gui.GuiBase;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public abstract class GuiCore
extends GuiBase {
    public static final int NONE = 0;
    public static final int INPUT_ALL = 1;
    public static final int OUTPUT_PRIMARY = 2;
    public static final int OUTPUT_SECONDARY = 3;
    public static final int OUTPUT_ALL = 4;
    public static final int INPUT_PRIMARY = 5;
    public static final int INPUT_SECONDARY = 6;
    public static final int OPEN = 7;
    public static final int OMNI = 8;
    public static final String TEX_INFO_INPUT = "cofh:textures/gui/elements/info_input.png";
    public static final String TEX_INFO_OUTPUT = "cofh:textures/gui/elements/info_output.png";
    public static final String TEX_ARROW_LEFT = "cofh:textures/gui/elements/progress_arrow_left.png";
    public static final String TEX_ARROW_RIGHT = "cofh:textures/gui/elements/progress_arrow_right.png";
    public static final String TEX_ARROW_FLUID_LEFT = "cofh:textures/gui/elements/progress_arrow_fluid_left.png";
    public static final String TEX_ARROW_FLUID_RIGHT = "cofh:textures/gui/elements/progress_arrow_fluid_right.png";
    public static final String TEX_DROP_LEFT = "cofh:textures/gui/elements/progress_fluid_left.png";
    public static final String TEX_DROP_RIGHT = "cofh:textures/gui/elements/progress_fluid_right.png";
    public static final String TEX_ALCHEMY = "cofh:textures/gui/elements/scale_alchemy.png";
    public static final String TEX_BUBBLE = "cofh:textures/gui/elements/scale_bubble.png";
    public static final String TEX_COMPACT = "cofh:textures/gui/elements/scale_compact.png";
    public static final String TEX_CRUSH = "cofh:textures/gui/elements/scale_crush.png";
    public static final String TEX_FLAME = "cofh:textures/gui/elements/scale_flame.png";
    public static final String TEX_FLAME_GREEN = "cofh:textures/gui/elements/scale_flame_green.png";
    public static final String TEX_FLUX = "cofh:textures/gui/elements/scale_flux.png";
    public static final String TEX_SAW = "cofh:textures/gui/elements/scale_saw.png";
    public static final String TEX_SPIN = "cofh:textures/gui/elements/scale_spin.png";
    public static final String TEX_SUN = "cofh:textures/gui/elements/scale_sun.png";
    public static final String TEX_SNOWFLAKE = "cofh:textures/gui/elements/scale_snowflake.png";
    public static final String TEX_BUTTONS = "cofh:textures/gui/elements/buttons.png";
    public static final int PROGRESS = 24;
    public static final int SPEED = 16;
    protected String myInfo = "";

    public GuiCore(Container container) {
        super(container);
    }

    public GuiCore(Container container, ResourceLocation texture) {
        super(container, texture);
    }

    protected void generateInfo(String tileString) {
        int i = 0;
        String line = tileString + "." + i;
        while (StringHelper.canLocalize(line)) {
            if (i > 0) {
                this.myInfo = this.myInfo + "\n\n";
            }
            this.myInfo = this.myInfo + StringHelper.localize(line);
            line = tileString + "." + ++i;
        }
    }

    @Override
    public void drawButton(TextureAtlasSprite icon, int x, int y, int mode) {
        switch (mode) {
            case 0: {
                this.drawIcon(CoreTextures.ICON_BUTTON, x, y);
                break;
            }
            case 1: {
                this.drawIcon(CoreTextures.ICON_BUTTON_HIGHLIGHT, x, y);
                break;
            }
            default: {
                this.drawIcon(CoreTextures.ICON_BUTTON_INACTIVE, x, y);
            }
        }
        this.drawIcon(icon, x, y);
    }
}

