/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm.repack.immibis.bon;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Mapping {
    private Map<String, String> classes = new HashMap<String, String>();
    private Map<String, String> methods = new HashMap<String, String>();
    private Map<String, String> fields = new HashMap<String, String>();
    private Map<String, List<String>> exceptions = new HashMap<String, List<String>>();
    private Map<String, String> classPrefixes = new HashMap<String, String>();
    private String defaultPackage = "";

    public void setClass(String in, String out) {
        this.classes.put(in, out);
    }

    public void setMethod(String clazz, String name, String desc, String out) {
        this.methods.put(clazz + "/" + name + desc, out);
    }

    public void setField(String clazz, String name, String out) {
        this.fields.put(clazz + "/" + name, out);
    }

    public void setExceptions(String clazz, String method, String desc, List<String> exc) {
        this.exceptions.put(clazz + "/" + method + desc, exc);
    }

    public String getClass(String in) {
        String ret;
        if (in == null) {
            return null;
        }
        if (in.startsWith("[")) {
            return "[" + this.getClass(in.substring(1));
        }
        if (in.startsWith("L") && in.endsWith(";")) {
            return "L" + this.getClass(in.substring(1, in.length() - 1)) + ";";
        }
        if (in.length() == 1) {
            switch (in.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return in;
                }
            }
        }
        if ((ret = this.classes.get(in)) != null) {
            return ret;
        }
        for (Map.Entry<String, String> e : this.classPrefixes.entrySet()) {
            if (!in.startsWith(e.getKey())) continue;
            return e.getValue() + in.substring(e.getKey().length());
        }
        if (!in.contains("/")) {
            return this.defaultPackage + in;
        }
        return in;
    }

    public String getMethod(String clazz, String name, String desc) {
        String ret = this.methods.get(clazz + "/" + name + desc);
        return ret == null ? name : ret;
    }

    public String getField(String clazz, String name, String desc) {
        String ret = this.fields.get(clazz + "/" + name);
        return ret == null ? name : ret;
    }

    public List<String> getExceptions(String clazz, String method, String desc) {
        List<String> ret = this.exceptions.get(clazz + "/" + method + desc);
        return ret == null ? Collections.emptyList() : ret;
    }

    public void addPrefix(String old, String new_) {
        this.classPrefixes.put(old, new_);
    }

    public void setDefaultPackage(String p) {
        this.defaultPackage = p;
    }

    public String parseTypes(String type, boolean generic, boolean method) {
        if (type == null) {
            return null;
        }
        int pos = 0;
        int len = type.length();
        int l = type.indexOf(60);
        StringBuilder out = new StringBuilder(len);
        block5: do {
            char c = type.charAt(pos);
            switch (c) {
                case '(': 
                case ')': {
                    if (!method) break;
                }
                case '<': 
                case '>': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case '[': {
                    out.append(c);
                    ++pos;
                    continue block5;
                }
                case 'L': {
                    out.append('L');
                    char o = ';';
                    int end = type.indexOf(59, pos);
                    if (l > 0 & end > l) {
                        end = l;
                        o = '<';
                        l = type.indexOf(60, l + 1);
                    }
                    String obf = type.substring(pos + 1, end);
                    out.append(this.getClass(obf)).append(o);
                    pos = end + 1;
                    continue block5;
                }
                default: {
                    if (!generic) break;
                    out.append(c);
                    ++pos;
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown character in descriptor: " + type.charAt(pos) + " (in " + type + ")");
        } while (pos < len);
        return out.toString();
    }

    public String mapMethodDescriptor(String desc) {
        if (desc.length() == 0 || desc.charAt(0) != '(' || desc.indexOf(")") < 1) {
            throw new IllegalArgumentException("Not a valid method descriptor: " + desc);
        }
        return this.parseTypes(desc, false, true);
    }

    public String mapTypeDescriptor(String in) {
        if (in.length() == 0) {
            throw new IllegalArgumentException("Not a valid type descriptor: " + in);
        }
        return this.parseTypes(in, false, false);
    }
}

