/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.LoadingPlugin;
import cofh.asm.repack.codechicken.lib.asm.ObfMapping;
import cofh.asm.repack.immibis.bon.JoinMapping;
import cofh.asm.repack.immibis.bon.Mapping;
import cofh.asm.repack.immibis.bon.mcp.CsvFile;
import cofh.asm.repack.immibis.bon.mcp.SrgFile;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Resource
public class CoFHAccessTransformer
implements IClassTransformer {
    private static List<String> mapFileList = new LinkedList<String>();
    private static ClassHelper helper = new ClassHelper();
    private static int depth = 0;
    private static Mapping mapping = null;
    private static HashMap<String, String> modifiers = new HashMap();
    private static HashMap<String, String> superClasses = new HashMap();
    private static HashMap<String, Modifier> classAccess = new HashMap();
    private static HashMap<String, Modifier> fieldAccess = new HashMap();
    private static HashMap<String, Modifier> methodAccess = new HashMap();

    public CoFHAccessTransformer() throws IOException {
        superClasses.put(null, null);
        for (String file : mapFileList) {
            this.readMapFile(file);
        }
    }

    void readMapFile(String rulesFile) throws IOException {
        File file = new File(rulesFile);
        URL rulesResource = file.exists() ? file.toURI().toURL() : Resources.getResource((String)rulesFile);
        CoFHAccessTransformer.processATFile(Resources.asCharSource((URL)rulesResource, (Charset)Charsets.UTF_8).openStream());
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassReader classReader;
        block25: {
            if (bytes == null) {
                return null;
            }
            classReader = new ClassReader(bytes);
            String owner = classReader.getClassName();
            String zuper = classReader.getSuperName();
            superClasses.put(owner, zuper);
            if (!superClasses.containsKey(zuper)) {
                superClasses.put(zuper, null);
                try {
                    ++depth;
                    Class.forName(zuper.replace('/', '.'), false, helper.getClassLoader());
                    --depth;
                }
                catch (Throwable e) {
                    depth = 0;
                    Throwables.propagate((Throwable)e);
                }
            }
            while (owner != null) {
                if (!modifiers.containsKey(owner)) {
                    owner = superClasses.get(owner);
                    continue;
                }
                break block25;
            }
            return bytes;
        }
        ClassNode cn = new ClassNode();
        classReader.accept((ClassVisitor)cn, 0);
        Modifier m = classAccess.get(cn.name);
        if (m != null) {
            cn.access = m.getFixedAccess(cn.access);
        }
        if (cn.innerClasses != null) {
            for (InnerClassNode in : cn.innerClasses) {
                m = classAccess.get(in.name);
                if (m == null) continue;
                in.access = m.getFixedAccess(in.access);
            }
        }
        for (FieldNode fn : cn.fields) {
            m = fieldAccess.get(cn.name + '/' + fn.name);
            if (m != null) {
                fn.access = m.getFixedAccess(fn.access);
            }
            if ((m = fieldAccess.get(cn.name + "/*")) == null) continue;
            fn.access = m.getFixedAccess(fn.access);
        }
        ArrayList nowOverridable = Lists.newArrayList();
        Modifier overrideAll = methodAccess.get(cn.name + "/*()V");
        for (MethodNode mn : cn.methods) {
            int access = mn.access;
            if (overrideAll != null) {
                String entry = cn.name + '/' + mn.name + mn.desc;
                m = methodAccess.get(entry);
                access = overrideAll.getFixedAccess(access);
                if (m == null) {
                    methodAccess.put(entry, overrideAll);
                } else {
                    switch (m.getFixedAccess(2)) {
                        case 2: {
                            if (overrideAll.getFixedAccess(2) == 0) {
                                methodAccess.put(entry, overrideAll);
                                break;
                            }
                        }
                        case 0: {
                            if (overrideAll.getFixedAccess(0) == 4) {
                                methodAccess.put(entry, overrideAll);
                                break;
                            }
                        }
                        case 4: {
                            if (overrideAll.getFixedAccess(4) != 1) break;
                            methodAccess.put(entry, overrideAll);
                            break;
                        }
                    }
                }
            }
            String owner = cn.name;
            while (owner != null) {
                m = methodAccess.get(owner + '/' + mn.name + mn.desc);
                if (m != null) {
                    access = m.getFixedAccess(access);
                }
                owner = superClasses.get(owner);
            }
            if ((mn.access & 2) != 0 && (access & 2) == 0) {
                nowOverridable.add(mn);
            }
            mn.access = access;
        }
        this.replaceInvokeSpecial(cn, nowOverridable);
        ClassWriter writer = new ClassWriter(1);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void replaceInvokeSpecial(ClassNode clazz, List<MethodNode> toReplace) {
        for (MethodNode method : clazz.methods) {
            block1: for (AbstractInsnNode insn : method.instructions) {
                if (insn.getOpcode() != 183) continue;
                MethodInsnNode mInsn = (MethodInsnNode)insn;
                if ("<init>".equals(mInsn.name)) continue;
                for (MethodNode n : toReplace) {
                    if (!n.name.equals(mInsn.name) || !n.desc.equals(mInsn.desc)) continue;
                    mInsn.setOpcode(182);
                    continue block1;
                }
            }
        }
    }

    static void initForDeobf() throws IOException {
        String mcpName;
        String srgName;
        String srgName2;
        File[] data = ObfMapping.MCPRemapper.getConfFiles();
        Mapping forwardSRG = new Mapping();
        Mapping forwardCSV = new Mapping();
        SrgFile srg = new SrgFile(data[0], false);
        forwardSRG.setDefaultPackage("net/minecraft/src/");
        HashMap<String, HashSet<String>> srgMethodDescriptors = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> srgMethodOwners = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> srgFieldOwners = new HashMap<String, HashSet<String>>();
        for (Map.Entry<String, String> entry : srg.classes.entrySet()) {
            String obfClass = entry.getKey();
            String srgClass = entry.getValue();
            forwardSRG.setClass(obfClass, srgClass);
        }
        for (Map.Entry<String, String> entry : srg.fields.entrySet()) {
            String obfOwnerAndName = entry.getKey();
            srgName2 = entry.getValue();
            String obfOwner = obfOwnerAndName.substring(0, obfOwnerAndName.lastIndexOf(47));
            String obfName = obfOwnerAndName.substring(obfOwnerAndName.lastIndexOf(47) + 1);
            String srgOwner = srg.classes.get(obfOwner);
            if (srgName2.startsWith("field_")) {
                HashSet<String> owners;
                if (srgFieldOwners.containsKey(srgName2)) {
                    System.out.println("SRG field " + srgName2 + " appears in multiple classes (at least " + srgFieldOwners.get(srgName2) + " and " + srgOwner + ")");
                }
                if ((owners = (HashSet<String>)srgFieldOwners.get(srgName2)) == null) {
                    owners = new HashSet<String>();
                    srgFieldOwners.put(srgName2, owners);
                }
                owners.add(srgOwner);
            }
            forwardSRG.setField(obfOwner, obfName, srgName2);
        }
        for (Map.Entry<String, String> entry : srg.methods.entrySet()) {
            String obfOwnerNameAndDesc = entry.getKey();
            srgName2 = entry.getValue();
            String obfOwnerAndName = obfOwnerNameAndDesc.substring(0, obfOwnerNameAndDesc.indexOf(40));
            String obfOwner = obfOwnerAndName.substring(0, obfOwnerAndName.lastIndexOf(47));
            String obfName = obfOwnerAndName.substring(obfOwnerAndName.lastIndexOf(47) + 1);
            String obfDesc = obfOwnerNameAndDesc.substring(obfOwnerNameAndDesc.indexOf(40));
            String srgDesc = forwardSRG.mapMethodDescriptor(obfDesc);
            String srgOwner = srg.classes.get(obfOwner);
            HashSet<String> srgMethodDescriptorsThis = (HashSet<String>)srgMethodDescriptors.get(srgName2);
            if (srgMethodDescriptorsThis == null) {
                srgMethodDescriptorsThis = new HashSet<String>();
                srgMethodDescriptors.put(srgName2, srgMethodDescriptorsThis);
            }
            srgMethodDescriptorsThis.add(srgDesc);
            HashSet<String> srgMethodOwnersThis = (HashSet<String>)srgMethodOwners.get(srgName2);
            if (srgMethodOwnersThis == null) {
                srgMethodOwnersThis = new HashSet<String>();
                srgMethodOwners.put(srgName2, srgMethodOwnersThis);
            }
            srgMethodOwnersThis.add(srgOwner);
            forwardSRG.setMethod(obfOwner, obfName, obfDesc, srgName2);
        }
        int[] sideNumbers = new int[]{2, 1, 0};
        Map<String, String> fieldNames = CsvFile.read(data[2], sideNumbers);
        Map<String, String> methodNames = CsvFile.read(data[1], sideNumbers);
        for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
            srgName = entry.getKey();
            mcpName = entry.getValue();
            if (srgFieldOwners.get(srgName) == null) continue;
            for (String srgOwner : (HashSet)srgFieldOwners.get(srgName)) {
                forwardCSV.setField(srgOwner, srgName, mcpName);
            }
        }
        for (Map.Entry<String, String> entry : methodNames.entrySet()) {
            srgName = entry.getKey();
            mcpName = entry.getValue();
            if (srgMethodOwners.get(srgName) == null) continue;
            for (String srgOwner : (HashSet)srgMethodOwners.get(srgName)) {
                for (String srgDesc : (HashSet)srgMethodDescriptors.get(srgName)) {
                    forwardCSV.setMethod(srgOwner, srgName, srgDesc, mcpName);
                }
            }
        }
        mapping = new JoinMapping(forwardSRG, forwardCSV);
    }

    static void processATFile(Reader rules) throws IOException {
        LineReader reader = new LineReader(rules);
        String input;
        while ((input = reader.readLine()) != null) {
            HashMap<String, Modifier> map;
            String lookupName;
            if (input.length() == 0) continue;
            int i = input.indexOf(35);
            String line = i < 0 ? input : input.substring(0, i);
            String[] parts = line.split(" ");
            if (parts.length > 3 || parts.length < 2) {
                throw new RuntimeException("Invalid config file line " + input);
            }
            String desc = "";
            String originalName = lookupName = parts[1].replace('.', '/');
            if (mapping != null) {
                lookupName = mapping.getClass(lookupName);
            }
            modifiers.put(lookupName, null);
            if (parts.length == 2) {
                map = classAccess;
            } else {
                String nameReference = parts[2];
                if (mapping != null) {
                    nameReference = mapping.getField(originalName, nameReference, "V");
                }
                lookupName = lookupName + '/' + nameReference;
                int parenIdx = nameReference.indexOf(40);
                if (parenIdx > 0) {
                    map = methodAccess;
                    desc = nameReference.substring(parenIdx);
                    nameReference = nameReference.substring(0, parenIdx);
                    if (mapping != null) {
                        String newName = mapping.getMethod(originalName, nameReference, desc);
                        desc = mapping.mapMethodDescriptor(desc);
                        nameReference = newName;
                        lookupName = originalName + '/' + nameReference + desc;
                    }
                } else {
                    map = fieldAccess;
                }
                parts[1] = nameReference;
            }
            Modifier mod = map.get(lookupName);
            if (mod == null) {
                map.put(lookupName, new Modifier(parts[0], parts[1], desc));
                continue;
            }
            mod.setTargetAccess(parts[0]);
        }
        return;
    }

    private static class ClassHelper
    extends SecurityManager {
        private ClassHelper() {
        }

        public ClassLoader getClassLoader() {
            Class<?> clazz;
            Class<?>[] classes = this.getClassContext();
            ClassLoader loader = null;
            int l = depth * 6;
            if (classes.length > l && (clazz = classes[l]) != LaunchClassLoader.class) {
                loader = clazz.getClassLoader();
            }
            if (loader != null) {
                return loader;
            }
            return LoadingPlugin.loader;
        }
    }

    static class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        String readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return null;
                        }
                        return new String(this.lineBuf, 0, len);
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return new String(this.lineBuf, 0, len);
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return new String(this.lineBuf, 0, len);
        }
    }

    static class Modifier {
        public String name;
        public String desc;
        public int targetAccess = 2;
        public boolean changeFinal;
        public boolean markFinal;

        public Modifier(String access, String name, String desc) {
            this.setTargetAccess(access);
            this.name = name;
            this.desc = desc;
        }

        public void setTargetAccess(String name) {
            switch (this.targetAccess) {
                case 2: {
                    if (name.startsWith("default")) {
                        this.targetAccess = 0;
                    }
                }
                case 0: {
                    if (name.startsWith("protected")) {
                        this.targetAccess = 4;
                    }
                }
                case 4: {
                    if (!name.startsWith("public")) break;
                    this.targetAccess = 1;
                }
            }
            if (name.endsWith("-f")) {
                this.changeFinal = true;
                this.markFinal = false;
            } else if (!this.changeFinal && name.endsWith("+f")) {
                this.changeFinal = true;
                this.markFinal = true;
            }
        }

        public int getFixedAccess(int access) {
            int t = this.targetAccess & 7;
            int ret = access & 0xFFFFFFF8;
            switch (access & 7) {
                case 2: {
                    ret |= t;
                    break;
                }
                case 0: {
                    ret |= t != 2 ? t : 0;
                    break;
                }
                case 4: {
                    ret |= t != 2 && t != 0 ? t : 4;
                    break;
                }
                case 1: {
                    ret |= 1;
                    break;
                }
                default: {
                    throw new RuntimeException("The fuck?");
                }
            }
            if (this.changeFinal) {
                ret = this.markFinal ? (ret |= 0x10) : (ret &= 0xFFFFFFEF);
            }
            return ret;
        }
    }
}

