/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.traits.TraitProgressiveStats;

public class ToolGrowth
extends TraitProgressiveStats {
    protected static float DURABILITY_COEFFICIENT = 0.04f;
    protected static float SPEED_INCREMENT = 0.05f;
    protected static float ATTACK_INCREMENT = 0.03f;
    protected static int DURABILITY_STEP = 1;
    protected static float SPEED_STEP = 0.01f;
    protected static float ATTACK_STEP = 0.01f;

    public ToolGrowth() {
        super("toolgrowth", TextFormatting.WHITE);
        this.addAspects(new ModifierAspect.SingleAspect(this));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof FakePlayer || world.field_72995_K) {
            return;
        }
        if (random.nextFloat() > 6.0E-4f) {
            return;
        }
        if (this.playerIsBreakingBlock(entity)) {
            return;
        }
        NBTTagCompound root = TagUtil.getTagSafe(tool);
        TraitProgressiveStats.StatNBT pool = this.getPool(root);
        TraitProgressiveStats.StatNBT bonus = this.getBonus(root);
        ToolNBT data = TagUtil.getToolStats(tool);
        int choice = random.nextInt(3);
        if (choice == 0) {
            if (pool.durability >= DURABILITY_STEP) {
                pool.durability -= DURABILITY_STEP;
                bonus.durability += DURABILITY_STEP;
                data.durability += DURABILITY_STEP;
            }
        } else if (choice == 1) {
            if (pool.speed >= SPEED_STEP) {
                pool.speed -= SPEED_STEP;
                bonus.speed += SPEED_STEP;
                data.speed += SPEED_STEP;
            }
        } else if (choice == 2 && pool.attack >= ATTACK_STEP) {
            pool.attack -= ATTACK_STEP;
            bonus.attack += ATTACK_STEP;
            data.attack += ATTACK_STEP;
        }
        TagUtil.setToolTag(tool, data.get());
        this.setBonus(root, bonus);
        this.setPool(root, pool);
    }

    @Override
    public void onRepair(ItemStack tool, int amount) {
        NBTTagCompound root = TagUtil.getTagSafe(tool);
        TraitProgressiveStats.StatNBT pool = this.getPool(root);
        float famount = amount;
        int totalDurability = ToolHelper.getDurabilityStat(tool);
        if (famount > (float)(totalDurability - ToolHelper.getCurrentDurability(tool))) {
            famount = totalDurability - ToolHelper.getCurrentDurability(tool);
        }
        int extra = (int)(this.calcDimishingReturns(totalDurability, 1000.0f) * (famount *= 0.975f + random.nextFloat() * 0.05f) * DURABILITY_COEFFICIENT);
        pool.durability += 1 + extra;
        this.setPool(root, pool);
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        if (player instanceof FakePlayer || world.field_72995_K) {
            return;
        }
        if (!wasEffective || random.nextFloat() > 0.1f) {
            return;
        }
        NBTTagCompound root = TagUtil.getTagSafe(tool);
        TraitProgressiveStats.StatNBT pool = this.getPool(root);
        float totalSpeed = ToolHelper.getMiningSpeedStat(tool);
        float extra = this.calcDimishingReturns(totalSpeed, 5.0f) * SPEED_INCREMENT;
        pool.speed += extra + 0.005f;
        this.setPool(root, pool);
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (player instanceof FakePlayer || player.func_130014_f_().field_72995_K) {
            return;
        }
        if (random.nextFloat() > 0.1f) {
            return;
        }
        NBTTagCompound root = TagUtil.getTagSafe(tool);
        TraitProgressiveStats.StatNBT pool = this.getPool(root);
        float totalSpeed = ToolHelper.getMiningSpeedStat(tool);
        float extra = this.calcDimishingReturns(totalSpeed, 10.0f) * ATTACK_INCREMENT;
        pool.attack += extra + 0.005f;
        this.setPool(root, pool);
    }

    protected float calcDimishingReturns(float value, float baseline) {
        return 2.0f / (1.0f + value / baseline * (value / baseline));
    }
}

