/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.WorldEvents;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeLeaves;
import slimeknights.tconstruct.world.block.BlockSlimeSapling;
import slimeknights.tconstruct.world.block.BlockSlimeVine;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;
import slimeknights.tconstruct.world.entity.EntityBlueSlime;
import slimeknights.tconstruct.world.item.ItemBlockLeaves;
import slimeknights.tconstruct.world.worldgen.MagmaSlimeIslandGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeIslandGenerator;

@Pulse(id="TinkerWorld", description="Everything that's found in the world and worldgen")
public class TinkerWorld
extends TinkerPulse {
    public static final String PulseId = "TinkerWorld";
    static final Logger log = Util.getLogger("TinkerWorld");
    @SidedProxy(clientSide="slimeknights.tconstruct.world.WorldClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockSlimeDirt slimeDirt;
    public static BlockSlimeGrass slimeGrass;
    public static BlockSlimeLeaves slimeLeaves;
    public static BlockTallSlimeGrass slimeGrassTall;
    public static BlockSlimeSapling slimeSapling;
    public static BlockSlimeVine slimeVineBlue1;
    public static BlockSlimeVine slimeVinePurple1;
    public static BlockSlimeVine slimeVineBlue2;
    public static BlockSlimeVine slimeVinePurple2;
    public static BlockSlimeVine slimeVineBlue3;
    public static BlockSlimeVine slimeVinePurple3;
    public static final EnumPlantType slimePlantType;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        slimeDirt = TinkerWorld.registerEnumBlock(new BlockSlimeDirt(), "slime_dirt");
        slimeGrass = TinkerWorld.registerBlock(new BlockSlimeGrass(), "slime_grass", BlockSlimeGrass.TYPE);
        slimeLeaves = (BlockSlimeLeaves)((Object)TinkerWorld.registerBlock((ItemBlock)new ItemBlockLeaves((Block)new BlockSlimeLeaves()), "slime_leaves"));
        ItemBlockMeta.setMappingProperty((Block)slimeLeaves, BlockSlimeGrass.FOLIAGE);
        slimeGrassTall = TinkerWorld.registerBlock(new BlockTallSlimeGrass(), "slime_grass_tall", BlockTallSlimeGrass.TYPE);
        slimeSapling = TinkerWorld.registerBlock(new BlockSlimeSapling(), "slime_sapling", BlockSlimeGrass.FOLIAGE);
        slimeVineBlue3 = TinkerWorld.registerBlock(new BlockSlimeVine(BlockSlimeGrass.FoliageType.BLUE, null), "slime_vine_blue_end");
        slimeVineBlue2 = TinkerWorld.registerBlock(new BlockSlimeVine(BlockSlimeGrass.FoliageType.BLUE, slimeVineBlue3), "slime_vine_blue_mid");
        slimeVineBlue1 = TinkerWorld.registerBlock(new BlockSlimeVine(BlockSlimeGrass.FoliageType.BLUE, slimeVineBlue2), "slime_vine_blue");
        slimeVinePurple3 = TinkerWorld.registerBlock(new BlockSlimeVine(BlockSlimeGrass.FoliageType.PURPLE, null), "slime_vine_purple_end");
        slimeVinePurple2 = TinkerWorld.registerBlock(new BlockSlimeVine(BlockSlimeGrass.FoliageType.PURPLE, slimeVinePurple3), "slime_vine_purple_mid");
        slimeVinePurple1 = TinkerWorld.registerBlock(new BlockSlimeVine(BlockSlimeGrass.FoliageType.PURPLE, slimeVinePurple2), "slime_vine_purple");
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("blueslime"), EntityBlueSlime.class, (String)"blueslime", (int)1, (Object)TConstruct.instance, (int)64, (int)5, (boolean)true, (int)4714485, (int)11337716);
        LootTableList.func_186375_a((ResourceLocation)EntityBlueSlime.LOOT_TABLE);
        proxy.preInit();
        TinkerRegistry.tabWorld.setDisplayIcon(new ItemStack((Block)slimeSapling));
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        this.addRecipies();
        proxy.init();
    }

    private void addRecipies() {
        IBlockState vanillaDirtState = Blocks.field_150346_d.func_176223_P();
        IBlockState grassState = slimeGrass.func_176223_P().func_177226_a(BlockSlimeGrass.TYPE, (Comparable)((Object)BlockSlimeGrass.DirtType.VANILLA));
        int meta = slimeGrass.func_176201_c(grassState.func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.BLUE)));
        ItemStack slime = TinkerCommons.matSlimeBallBlue.func_77946_l();
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)slimeGrass, 1, meta), (Object[])new Object[]{" s ", "sBs", " s ", Character.valueOf('s'), slime, Character.valueOf('B'), Blocks.field_150349_c});
        meta = slimeGrass.func_176201_c(grassState.func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.PURPLE)));
        slime = TinkerCommons.matSlimeBallPurple.func_77946_l();
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)slimeGrass, 1, meta), (Object[])new Object[]{" s ", "sBs", " s ", Character.valueOf('s'), slime, Character.valueOf('B'), Blocks.field_150349_c});
        meta = slimeGrass.func_176201_c(grassState.func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.ORANGE)));
        slime = TinkerCommons.matSlimeBallMagma.func_77946_l();
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)slimeGrass, 1, meta), (Object[])new Object[]{" s ", "sBs", " s ", Character.valueOf('s'), slime, Character.valueOf('B'), Blocks.field_150349_c});
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)SlimeIslandGenerator.INSTANCE, (int)25);
        GameRegistry.registerWorldGenerator((IWorldGenerator)MagmaSlimeIslandGenerator.INSTANCE, (int)25);
        MinecraftForge.EVENT_BUS.register((Object)new WorldEvents());
        proxy.postInit();
    }

    static {
        slimePlantType = EnumPlantType.getPlantType((String)"slime");
    }
}

